/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils;

import com.buuz135.industrial.IndustrialForegoing;
import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.lwjgl.opengl.GL11;

public class BlockUtils {
    private static HashMultimap<String, Block> oreDictBlocks = HashMultimap.create();

    public static List<BlockPos> getBlockPosInAABB(AxisAlignedBB axisAlignedBB) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        for (double y = axisAlignedBB.field_72338_b; y < axisAlignedBB.field_72337_e; y += 1.0) {
            for (double x = axisAlignedBB.field_72340_a; x < axisAlignedBB.field_72336_d; x += 1.0) {
                for (double z = axisAlignedBB.field_72339_c; z < axisAlignedBB.field_72334_f; z += 1.0) {
                    blocks.add(new BlockPos(x, y, z));
                }
            }
        }
        return blocks;
    }

    public static boolean isBlockstateInMaterial(BlockState state, Material[] materials) {
        for (Material material : materials) {
            if (state.func_185904_a() != material) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockTag(World world, BlockPos pos, ITag.INamedTag<Block> tag) {
        return BlockUtils.isBlockStateTag(world.func_180495_p(pos), tag);
    }

    public static boolean isBlockStateTag(BlockState state, ITag.INamedTag<Block> tag) {
        return state.func_177230_c().func_203417_a(tag);
    }

    public static boolean isBlockOreDict(World world, BlockPos pos, String ore) {
        return false;
    }

    public static boolean isLog(World world, BlockPos pos) {
        return BlockUtils.isBlockTag(world, pos, (ITag.INamedTag<Block>)BlockTags.field_200031_h);
    }

    public static boolean isLeaves(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a() == Material.field_151584_j || world.func_180495_p(pos).func_235714_a_((ITag)BlockTags.field_232874_ao_) || world.func_180495_p(pos).func_235714_a_((ITag)BlockTags.field_206952_E) || world.func_180495_p(pos).func_177230_c().equals(Blocks.field_235383_mw_);
    }

    public static boolean isChorus(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().equals(Blocks.field_185765_cR) || world.func_180495_p(pos).func_177230_c().equals(Blocks.field_185766_cS);
    }

    public static boolean canBlockBeBroken(World world, BlockPos pos) {
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, world.func_180495_p(pos), (PlayerEntity)IndustrialForegoing.getFakePlayer(world));
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    public static List<ItemStack> getBlockDrops(World world, BlockPos pos) {
        return BlockUtils.getBlockDrops(world, pos, 0);
    }

    public static List<ItemStack> getBlockDrops(World world, BlockPos pos, int fortune) {
        BlockState state = world.func_180495_p(pos);
        NonNullList stacks = NonNullList.func_191196_a();
        stacks.addAll((Collection)Block.func_220070_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)pos, (TileEntity)world.func_175625_s(pos)));
        return stacks;
    }

    public static boolean spawnItemStack(ItemStack stack, World world, BlockPos pos) {
        ItemEntity item = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p() + 0.5);
        item.func_213293_j(0.0, -1.0, 0.0);
        item.func_174867_a(40);
        item.func_92058_a(stack);
        return world.func_217376_c((Entity)item);
    }

    public static void renderLaserBeam(TileEntity tile, double x, double y, double z, Direction direction, float partialTicks, int length) {
        Tessellator tess = Tessellator.func_178181_a();
        RenderSystem.pushMatrix();
        double tempX = x;
        double tempY = y;
        double tempZ = z;
        switch (direction) {
            case NORTH: {
                RenderSystem.rotatef((float)270.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                tempY = -z;
                tempZ = y;
                break;
            }
            case SOUTH: {
                RenderSystem.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                tempY = z + 1.0;
                tempZ = -y - 1.0;
                break;
            }
            case EAST: {
                RenderSystem.rotatef((float)270.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                tempY = x + 1.0;
                tempX = -y - 1.0;
                break;
            }
            case WEST: {
                RenderSystem.rotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                tempY = -x;
                tempX = y;
                break;
            }
            default: {
                tempY -= (double)length;
            }
        }
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        BufferBuilder buffer = tess.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float d1 = (float)(-(tile.func_145831_w().func_82737_E() % 15L)) / 15.0f;
        float d2 = (float)(tile.func_145831_w().func_82737_E() % 40L) / 2.0f;
        double pointA = 0.45 - (double)d2 / 200.0;
        if (d2 >= 10.0f) {
            pointA = 0.35 + (double)d2 / 200.0;
        }
        double pointB = 1.0 - pointA;
        float uStart = 0.0f;
        float uEnd = 1.0f;
        float vStart = -1.0f + d1;
        float vEnd = (float)(length * 2) + vStart;
        buffer.func_225582_a_(tempX + pointA, tempY + (double)length, tempZ + pointA).func_225583_a_(uEnd, vEnd).func_181675_d();
        buffer.func_225582_a_(tempX + pointA, tempY, tempZ + pointA).func_225583_a_(uEnd, vStart).func_181675_d();
        buffer.func_225582_a_(tempX + pointB, tempY, tempZ + pointA).func_225583_a_(uStart, vStart).func_181675_d();
        buffer.func_225582_a_(tempX + pointB, tempY + (double)length, tempZ + pointA).func_225583_a_(uStart, vEnd).func_181675_d();
        buffer.func_225582_a_(tempX + pointB, tempY + (double)length, tempZ + pointB).func_225583_a_(uEnd, vEnd).func_181675_d();
        buffer.func_225582_a_(tempX + pointB, tempY, tempZ + pointB).func_225583_a_(uEnd, vStart).func_181675_d();
        buffer.func_225582_a_(tempX + pointA, tempY, tempZ + pointB).func_225583_a_(uStart, vStart).func_181675_d();
        buffer.func_225582_a_(tempX + pointA, tempY + (double)length, tempZ + pointB).func_225583_a_(uStart, vEnd).func_181675_d();
        buffer.func_225582_a_(tempX + pointB, tempY + (double)length, tempZ + pointA).func_225583_a_(uEnd, vEnd).func_181675_d();
        buffer.func_225582_a_(tempX + pointB, tempY, tempZ + pointA).func_225583_a_(uEnd, vStart).func_181675_d();
        buffer.func_225582_a_(tempX + pointB, tempY, tempZ + pointB).func_225583_a_(uStart, vStart).func_181675_d();
        buffer.func_225582_a_(tempX + pointB, tempY + (double)length, tempZ + pointB).func_225583_a_(uStart, vEnd).func_181675_d();
        buffer.func_225582_a_(tempX + pointA, tempY + (double)length, tempZ + pointB).func_225583_a_(uEnd, vEnd).func_181675_d();
        buffer.func_225582_a_(tempX + pointA, tempY, tempZ + pointB).func_225583_a_(uEnd, vStart).func_181675_d();
        buffer.func_225582_a_(tempX + pointA, tempY, tempZ + pointA).func_225583_a_(uStart, vStart).func_181675_d();
        buffer.func_225582_a_(tempX + pointA, tempY + (double)length, tempZ + pointA).func_225583_a_(uStart, vEnd).func_181675_d();
        tess.func_78381_a();
        GL11.glEnable((int)2884);
        RenderSystem.popMatrix();
    }
}

