/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.block.BasicBlock;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.module.api.RegistryManager;
import com.hrznstudio.titanium.nbthandler.NBTManager;
import com.hrznstudio.titanium.util.TileUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class BasicTileBlock<T extends BasicTile<T>>
extends BasicBlock
implements ITileEntityProvider {
    private final Class<T> tileClass;
    private TileEntityType tileEntityType;

    public BasicTileBlock(AbstractBlock.Properties properties, Class<T> tileClass) {
        super(properties);
        this.tileClass = tileClass;
    }

    @Override
    public void addAlternatives(RegistryManager<?> registry) {
        super.addAlternatives(registry);
        NBTManager.getInstance().scanTileClassForAnnotations(this.tileClass);
        this.tileEntityType = TileEntityType.Builder.func_223042_a(this.getTileEntityFactory()::create, (Block[])new Block[]{this}).func_206865_a(null);
        this.tileEntityType.setRegistryName(this.getRegistryName());
        registry.content(TileEntityType.class, this.tileEntityType);
    }

    public abstract IFactory<T> getTileEntityFactory();

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        this.getTile((IBlockReader)worldIn, pos).ifPresent(tile -> tile.onNeighborChanged(blockIn, fromPos));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        return this.getTile((IBlockReader)worldIn, pos).map(tile -> tile.onActivated(player, hand, ray.func_216354_b(), ray.func_216347_e().field_72450_a, ray.func_216347_e().field_72448_b, ray.func_216347_e().field_72449_c)).orElseGet(() -> super.func_225533_a_(state, worldIn, pos, player, hand, ray));
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return (TileEntity)this.getTileEntityFactory().create();
    }

    public Optional<T> getTile(IBlockReader access, BlockPos pos) {
        return TileUtil.getTileEntity(access, pos, this.tileClass);
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        return (TileEntity)this.getTileEntityFactory().create();
    }

    public TileEntityType getTileEntityType() {
        return this.tileEntityType;
    }

    public Class<T> getTileClass() {
        return this.tileClass;
    }
}

