/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile;

import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.PoweredTile;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;

public abstract class GeneratorTile<T extends GeneratorTile<T>>
extends PoweredTile<T> {
    @Save
    private ProgressBarComponent<T> progressBar = this.getProgressBar().setComponentHarness(this.getSelf()).setCanIncrease(tileEntity -> !this.isSmart() || this.getEnergyCapacity() - this.getEnergyStorage().getEnergyStored() >= this.getEnergyProducedEveryTick()).setIncreaseType(false).setOnStart(() -> {
        this.progressBar.setMaxProgress(this.consumeFuel());
        this.progressBar.setProgress(this.progressBar.getMaxProgress());
        this.markForUpdate();
    }).setCanReset(tileEntity -> this.canStart() && this.progressBar.getProgress() == 0).setOnTickWork(() -> this.getEnergyStorage().setEnergyStored(this.getEnergyProducedEveryTick() + this.getEnergyStorage().getEnergyStored()));

    public GeneratorTile(BasicTileBlock<T> basicTileBlock) {
        super(basicTileBlock);
        this.addProgressBar(this.progressBar);
    }

    public abstract int consumeFuel();

    public abstract boolean canStart();

    public abstract int getEnergyProducedEveryTick();

    public abstract ProgressBarComponent<T> getProgressBar();

    public abstract int getEnergyCapacity();

    public abstract int getExtractingEnergy();

    public boolean isSmart() {
        return true;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        for (Direction facing : Direction.values()) {
            BlockPos checking = this.field_174879_c.func_177972_a(facing);
            TileEntity checkingTile = this.field_145850_b.func_175625_s(checking);
            if (checkingTile == null) continue;
            checkingTile.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()).ifPresent(storage -> this.getEnergyStorage().extractEnergy(storage.receiveEnergy(this.getEnergyStorage().extractEnergy(this.getExtractingEnergy(), true), false), false));
        }
    }

    @Override
    @Nonnull
    protected EnergyStorageComponent<T> createEnergyStorage() {
        return new EnergyStorageComponent(this.getEnergyCapacity(), 0, this.getExtractingEnergy(), 10, 20);
    }
}

