/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile;

import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.IMachine;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.PoweredTile;
import com.hrznstudio.titanium.client.screen.addon.AssetScreenAddon;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;

public abstract class MachineTile<T extends MachineTile<T>>
extends PoweredTile<T>
implements IMachine {
    @Save
    private SidedInventoryComponent<T> augmentInventory = (SidedInventoryComponent)this.getAugmentFactory().create().setComponentHarness(this.getSelf()).setInputFilter((stack, integer) -> AugmentWrapper.isAugment(stack) && this.canAcceptAugment((ItemStack)stack));

    public MachineTile(BasicTileBlock<T> basicTileBlock) {
        super(basicTileBlock);
        this.addInventory(this.augmentInventory);
        this.addGuiAddonFactory(this.getAugmentBackground());
        for (FacingUtil.Sideness value : FacingUtil.Sideness.values()) {
            ((HashMap)this.augmentInventory.getFacingModes()).put(value, IFacingComponent.FaceMode.NONE);
        }
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public boolean isPaused() {
        return false;
    }

    @Override
    public boolean canAcceptAugment(ItemStack augment) {
        return AugmentWrapper.isAugment(augment);
    }

    @Override
    public List<ItemStack> getInstalledAugments() {
        return this.getItemStackAugments().stream().filter(AugmentWrapper::isAugment).collect(Collectors.toList());
    }

    @Override
    public List<ItemStack> getInstalledAugments(IAugmentType filter) {
        return this.getItemStackAugments().stream().filter(AugmentWrapper::isAugment).filter(stack -> AugmentWrapper.hasType(stack, filter)).collect(Collectors.toList());
    }

    @Override
    public boolean hasAugmentInstalled(IAugmentType augmentType) {
        return this.getInstalledAugments(augmentType).size() > 0;
    }

    public IFactory<InventoryComponent<T>> getAugmentFactory() {
        return () -> new SidedInventoryComponent("augments", 180, 11, 4, 0).disableFacingAddon().setColor(DyeColor.PURPLE).setRange(1, 4);
    }

    public IFactory<? extends IScreenAddon> getAugmentBackground() {
        return () -> new AssetScreenAddon(AssetTypes.AUGMENT_BACKGROUND, 175, 4, true);
    }

    private List<ItemStack> getItemStackAugments() {
        ArrayList<ItemStack> augments = new ArrayList<ItemStack>();
        for (int i = 0; i < this.augmentInventory.getSlots(); ++i) {
            augments.add(this.augmentInventory.getStackInSlot(i));
        }
        return augments;
    }

    @Override
    public ActionResultType onActivated(PlayerEntity playerIn, Hand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == ActionResultType.SUCCESS) {
            return ActionResultType.SUCCESS;
        }
        this.openGui(playerIn);
        return ActionResultType.SUCCESS;
    }
}

