/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon;

import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Rectangle;
import net.minecraft.client.gui.screen.Screen;

public class AssetScreenAddon
extends BasicScreenAddon {
    private IAssetType assetType;
    private boolean isBackground;
    private Rectangle area;

    public AssetScreenAddon(IAssetType assetType, int posX, int posY, boolean isBackground) {
        super(posX, posY);
        this.assetType = assetType;
        this.isBackground = isBackground;
    }

    @Override
    public int getXSize() {
        return this.area != null ? this.area.width : 0;
    }

    @Override
    public int getYSize() {
        return this.area != null ? this.area.height : 0;
    }

    @Override
    public void drawBackgroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        if (this.assetType != null) {
            Object asset = provider.getAsset(this.assetType);
            this.area = asset.getArea();
            AssetUtil.drawAsset(stack, screen, asset, this.getPosX() + guiX, this.getPosY() + guiY);
        }
    }

    @Override
    public void drawForegroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
        if (this.assetType != null) {
            AssetUtil.drawAsset(stack, screen, provider.getAsset(this.assetType), this.getPosX() + guiX, this.getPosY() + guiY);
        }
    }

    public boolean isBackground() {
        return this.isBackground;
    }
}

