/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.container;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.assets.types.IBackgroundAsset;
import com.hrznstudio.titanium.client.screen.IScreenAddonConsumer;
import com.hrznstudio.titanium.client.screen.addon.AssetScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.interfaces.ICanMouseDrag;
import com.hrznstudio.titanium.client.screen.addon.interfaces.IClickable;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.glfw.GLFW;

public class BasicContainerScreen<T extends Container>
extends ContainerScreen<T>
implements IScreenAddonConsumer {
    private final T container;
    private final ITextComponent title;
    private IAssetProvider assetProvider;
    private int xCenter;
    private int yCenter;
    private List<IScreenAddon> addons;
    private int dragX;
    private int dragY;
    private boolean isMouseDragging;

    public BasicContainerScreen(T container, PlayerInventory inventory, ITextComponent title) {
        super(container, inventory, title);
        this.container = container;
        this.title = title;
        this.assetProvider = IAssetProvider.DEFAULT_PROVIDER;
        IBackgroundAsset background = IAssetProvider.getAsset(this.assetProvider, AssetTypes.BACKGROUND);
        this.field_146999_f = background.getArea().width;
        this.field_147000_g = background.getArea().height;
        this.isMouseDragging = false;
        this.addons = new ArrayList<IScreenAddon>();
    }

    public BasicContainerScreen(T container, PlayerInventory inventory, ITextComponent title, IAssetProvider provider) {
        super(container, inventory, title);
        this.container = container;
        this.title = title;
        this.assetProvider = provider;
        IBackgroundAsset background = IAssetProvider.getAsset(this.assetProvider, AssetTypes.BACKGROUND);
        this.field_146999_f = background.getArea().width;
        this.field_147000_g = background.getArea().height;
        this.addons = new ArrayList<IScreenAddon>();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.getAddons().forEach(screenAddon -> screenAddon.init(this.field_147003_i, this.field_147009_r));
    }

    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(stack);
        this.xCenter = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.yCenter = (this.field_230709_l_ - this.field_147000_g) / 2;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(IAssetProvider.getAsset(this.assetProvider, AssetTypes.BACKGROUND).getResourceLocation());
        this.func_238474_b_(stack, this.xCenter, this.yCenter, 0, 0, this.field_146999_f, this.field_147000_g);
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(stack, TextFormatting.DARK_GRAY + this.title.getString(), (float)(this.xCenter + this.field_146999_f / 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(this.title.getString()) / 2), (float)(this.yCenter + 6), 0xFFFFFF);
        this.checkForMouseDrag(mouseX, mouseY);
        this.addons.forEach(iGuiAddon -> {
            if (iGuiAddon instanceof AssetScreenAddon) {
                AssetScreenAddon assetGuiAddon = (AssetScreenAddon)iGuiAddon;
                if (assetGuiAddon.isBackground()) {
                    iGuiAddon.drawBackgroundLayer(stack, (Screen)this, this.assetProvider, this.xCenter, this.yCenter, mouseX, mouseY, partialTicks);
                }
            } else {
                iGuiAddon.drawBackgroundLayer(stack, (Screen)this, this.assetProvider, this.xCenter, this.yCenter, mouseX, mouseY, partialTicks);
            }
        });
    }

    protected void func_230451_b_(MatrixStack stack, int mouseX, int mouseY) {
        this.addons.forEach(iGuiAddon -> {
            if (iGuiAddon instanceof AssetScreenAddon) {
                AssetScreenAddon assetGuiAddon = (AssetScreenAddon)iGuiAddon;
                if (assetGuiAddon.isBackground()) {
                    iGuiAddon.drawForegroundLayer(stack, (Screen)this, this.assetProvider, this.xCenter, this.yCenter, mouseX, mouseY);
                }
            } else {
                iGuiAddon.drawForegroundLayer(stack, (Screen)this, this.assetProvider, this.xCenter, this.yCenter, mouseX, mouseY);
            }
        });
        this.func_230459_a_(stack, mouseX - this.xCenter, mouseY - this.yCenter);
        for (IScreenAddon iScreenAddon : this.addons) {
            if (!iScreenAddon.isInside((Screen)this, mouseX - this.xCenter, mouseY - this.yCenter) || iScreenAddon.getTooltipLines().isEmpty()) continue;
            this.func_243308_b(stack, iScreenAddon.getTooltipLines(), mouseX - this.xCenter, mouseY - this.yCenter);
        }
    }

    private void checkForMouseDrag(int mouseX, int mouseY) {
        if (GLFW.glfwGetMouseButton((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)0) == 1) {
            if (!this.isMouseDragging) {
                this.isMouseDragging = true;
            } else {
                for (IScreenAddon iScreenAddon : this.addons) {
                    if (!(iScreenAddon instanceof ICanMouseDrag) || !iScreenAddon.isInside(null, mouseX - this.xCenter, mouseY - this.yCenter)) continue;
                    ((ICanMouseDrag)((Object)iScreenAddon)).drag(mouseX - this.xCenter, mouseY - this.yCenter);
                }
            }
            this.dragX = mouseX;
            this.dragY = mouseY;
        } else {
            this.isMouseDragging = false;
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        super.func_231044_a_(mouseX, mouseY, mouseButton);
        new ArrayList<IScreenAddon>(this.addons).stream().filter(iGuiAddon -> iGuiAddon instanceof IClickable && iGuiAddon.isInside((Screen)this, mouseX - (double)this.xCenter, mouseY - (double)this.yCenter)).forEach(iGuiAddon -> ((IClickable)((Object)iGuiAddon)).handleClick((Screen)this, this.xCenter, this.yCenter, mouseX, mouseY, mouseButton));
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scan, int modifiers) {
        return this.getAddons().stream().anyMatch(screenAddon -> screenAddon.keyPressed(keyCode, scan, modifiers)) || super.func_231046_a_(keyCode, scan, modifiers);
    }

    public int getX() {
        return this.xCenter;
    }

    public int getY() {
        return this.yCenter;
    }

    @Nonnull
    public T func_212873_a_() {
        return this.container;
    }

    public List<IScreenAddon> getAddons() {
        return this.addons;
    }

    public void setAddons(List<IScreenAddon> addons) {
        this.addons = addons;
    }

    public IAssetProvider getAssetProvider() {
        return this.assetProvider;
    }

    public void setAssetProvider(IAssetProvider assetProvider) {
        this.assetProvider = assetProvider;
    }
}

