/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.component.inventory;

import com.google.common.collect.Lists;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.client.screen.addon.SlotsScreenAddon;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.container.addon.IContainerAddonProvider;
import com.hrznstudio.titanium.container.addon.SlotContainerAddon;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class InventoryComponent<T extends IComponentHarness>
extends ItemStackHandler
implements IScreenAddonProvider,
IContainerAddonProvider {
    private final String name;
    private int xPos;
    private int yPos;
    private int xSize;
    private int ySize;
    private T componentHarness;
    private BiPredicate<ItemStack, Integer> insertPredicate;
    private BiPredicate<ItemStack, Integer> extractPredicate;
    private BiConsumer<ItemStack, Integer> onSlotChanged;
    private Map<Integer, Integer> slotAmountFilter;
    private Map<Integer, ItemStack> slotToStackRenderMap;
    private boolean colorGuiEnabled;
    private Map<Integer, Color> slotToColorRenderMap;
    private int slotLimit;
    private Function<Integer, Pair<Integer, Integer>> slotPosition;
    private Predicate<Integer> slotVisiblePredicate;

    public InventoryComponent(String name, int xPos, int yPos, int size) {
        this.name = name;
        this.xPos = xPos;
        this.yPos = yPos;
        this.setSize(size);
        this.setRange(size, 1);
        this.insertPredicate = (stack, integer) -> true;
        this.extractPredicate = (stack, integer) -> true;
        this.onSlotChanged = (stack, integer) -> {};
        this.slotAmountFilter = new HashMap<Integer, Integer>();
        this.slotToStackRenderMap = new HashMap<Integer, ItemStack>();
        this.colorGuiEnabled = false;
        this.slotToColorRenderMap = new HashMap<Integer, Color>();
        this.slotLimit = 64;
        this.slotPosition = integer -> Pair.of((Object)(18 * (integer % this.xSize)), (Object)(18 * (integer / this.xSize)));
        this.slotVisiblePredicate = integer -> true;
    }

    public InventoryComponent<T> setRange(int x, int y) {
        this.xSize = x;
        this.ySize = y;
        return this;
    }

    public InventoryComponent<T> setComponentHarness(T componentHarness) {
        this.componentHarness = componentHarness;
        return this;
    }

    public InventoryComponent<T> setInputFilter(BiPredicate<ItemStack, Integer> predicate) {
        this.insertPredicate = predicate;
        return this;
    }

    public InventoryComponent<T> setOutputFilter(BiPredicate<ItemStack, Integer> predicate) {
        this.extractPredicate = predicate;
        return this;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existingStack = (ItemStack)this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existingStack.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existingStack)) {
                return stack;
            }
            limit -= existingStack.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existingStack.func_190926_b()) {
                this.stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
            } else {
                existingStack.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }

    protected void onContentsChanged(int slot) {
        if (this.componentHarness != null) {
            this.componentHarness.markComponentDirty();
        }
        this.onSlotChanged.accept(this.getStackInSlot(slot), slot);
    }

    public String getName() {
        return this.name;
    }

    public int getXPos() {
        return this.xPos;
    }

    public void setXPos(int xPos) {
        this.xPos = xPos;
    }

    public int getYPos() {
        return this.yPos;
    }

    public void setYPos(int yPos) {
        this.yPos = yPos;
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public T getComponentHarness() {
        return this.componentHarness;
    }

    public BiPredicate<ItemStack, Integer> getInsertPredicate() {
        return this.insertPredicate;
    }

    public BiPredicate<ItemStack, Integer> getExtractPredicate() {
        return this.extractPredicate;
    }

    public BiConsumer<ItemStack, Integer> getOnSlotChanged() {
        return this.onSlotChanged;
    }

    public InventoryComponent<T> setColorGuiEnabled(boolean colorGuiEnabled) {
        this.colorGuiEnabled = colorGuiEnabled;
        return this;
    }

    public boolean isColorGuiEnabled() {
        return this.colorGuiEnabled;
    }

    public Map<Integer, Color> getSlotToColorRenderMap() {
        return this.slotToColorRenderMap;
    }

    public InventoryComponent<T> setOnSlotChanged(BiConsumer<ItemStack, Integer> onSlotChanged) {
        this.onSlotChanged = onSlotChanged;
        return this;
    }

    public InventoryComponent<T> setSlotLimit(int slot, int limit) {
        this.slotAmountFilter.put(slot, limit);
        return this;
    }

    public InventoryComponent<T> setSlotToItemStackRender(int slot, ItemStack stack) {
        this.slotToStackRenderMap.put(slot, stack);
        return this;
    }

    public InventoryComponent<T> setSlotToColorRender(int slot, int color) {
        if (!this.colorGuiEnabled) {
            this.setColorGuiEnabled(true);
        }
        this.slotToColorRenderMap.put(slot, new Color(color));
        return this;
    }

    public InventoryComponent<T> setSlotToColorRender(int slot, DyeColor color) {
        if (!this.colorGuiEnabled) {
            this.setColorGuiEnabled(true);
        }
        this.slotToColorRenderMap.put(slot, new Color(color.getColorValue()));
        return this;
    }

    public InventoryComponent<T> setSlotToColorRender(int slot, Color color) {
        if (!this.colorGuiEnabled) {
            this.setColorGuiEnabled(true);
        }
        this.slotToColorRenderMap.put(slot, color);
        return this;
    }

    public ItemStack getItemStackForSlotRendering(int slot) {
        return this.slotToStackRenderMap.getOrDefault(slot, ItemStack.field_190927_a);
    }

    public Color getColorForSlotRendering(int slot) {
        return this.slotToColorRenderMap.get(slot);
    }

    public InventoryComponent<T> setSlotLimit(int limit) {
        this.slotLimit = limit;
        return this;
    }

    public Predicate<Integer> getSlotVisiblePredicate() {
        return this.slotVisiblePredicate;
    }

    public InventoryComponent<T> setSlotVisiblePredicate(Predicate<Integer> slotVisiblePredicate) {
        this.slotVisiblePredicate = slotVisiblePredicate;
        return this;
    }

    public int getSlotLimit(int slot) {
        return this.slotAmountFilter.getOrDefault(slot, this.slotLimit);
    }

    public Function<Integer, Pair<Integer, Integer>> getSlotPosition() {
        return this.slotPosition;
    }

    public InventoryComponent<T> setSlotPosition(Function<Integer, Pair<Integer, Integer>> slotPosition) {
        this.slotPosition = slotPosition;
        return this;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.insertPredicate.test(stack, slot);
    }

    @Override
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList<IFactory<? extends IScreenAddon>> addons = new ArrayList<IFactory<? extends IScreenAddon>>();
        addons.add(() -> new SlotsScreenAddon(this));
        return addons;
    }

    @Override
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        return Lists.newArrayList((Object[])new IFactory[]{() -> new SlotContainerAddon((IItemHandler)this, this.xPos, this.yPos, this.slotPosition)});
    }
}

