/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.event.handler;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.GenericEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class EventManager {
    public static <T extends Event> FilteredEventManager<T> forge(Class<T> clazz) {
        return EventManager.create(clazz, EventPriority.NORMAL, Bus.FORGE);
    }

    public static <T extends Event> FilteredEventManager<T> mod(Class<T> clazz) {
        return EventManager.create(clazz, EventPriority.NORMAL, Bus.MOD);
    }

    public static <T extends Event> FilteredEventManager<T> mod(Class<T> clazz, EventPriority priority) {
        return EventManager.create(clazz, priority, Bus.MOD);
    }

    public static <T extends Event> FilteredEventManager<T> forge(Class<T> clazz, EventPriority priority) {
        return EventManager.create(clazz, priority, Bus.FORGE);
    }

    public static <T extends Event> FilteredEventManager<T> create(Class<T> clazz, Bus bus) {
        return EventManager.create(clazz, EventPriority.NORMAL, bus);
    }

    public static <T extends Event> FilteredEventManager<T> create(Class<T> clazz, EventPriority priority, Bus bus) {
        return new FilteredEventManager<T>(clazz, bus, priority);
    }

    public static <T extends GenericEvent<? extends F>, F> GenericEventManager<T, F> forgeGeneric(Class<T> clazz, Class<F> generic) {
        return EventManager.createGeneric(clazz, EventPriority.NORMAL, Bus.FORGE, generic);
    }

    public static <T extends GenericEvent<? extends F>, F> GenericEventManager<T, F> modGeneric(Class<T> clazz, Class<F> generic) {
        return EventManager.createGeneric(clazz, EventPriority.NORMAL, Bus.MOD, generic);
    }

    public static <T extends GenericEvent<? extends F>, F> GenericEventManager<T, F> modGeneric(Class<T> clazz, EventPriority priority, Class<F> generic) {
        return EventManager.createGeneric(clazz, priority, Bus.MOD, generic);
    }

    public static <T extends GenericEvent<? extends F>, F> GenericEventManager<T, F> forgeGeneric(Class<T> clazz, EventPriority priority, Class<F> generic) {
        return EventManager.createGeneric(clazz, priority, Bus.FORGE, generic);
    }

    public static <T extends GenericEvent<? extends F>, F> GenericEventManager<T, F> createGeneric(Class<T> clazz, Bus bus, Class<F> generic) {
        return EventManager.createGeneric(clazz, EventPriority.NORMAL, bus, generic);
    }

    public static <T extends GenericEvent<? extends F>, F> GenericEventManager<T, F> createGeneric(Class<T> clazz, EventPriority priority, Bus bus, Class<F> generic) {
        return new GenericEventManager<T, F>(clazz, bus, priority, generic);
    }

    public static class GenericEventManager<T extends GenericEvent<? extends F>, F>
    implements ISubscribe {
        private Predicate<T> filter;
        private Consumer<T> process;
        private Class<T> event;
        private boolean cancel;
        private Bus bus;
        private EventPriority priority;
        private Class<F> generic;

        public GenericEventManager(Class<T> clazz, Bus bus, EventPriority priority, Class<F> generic) {
            this.event = clazz;
            this.filter = t -> true;
            this.process = t -> {};
            this.bus = bus;
            this.priority = priority;
            this.generic = generic;
        }

        @Override
        public void subscribe() {
            this.bus.bus().addGenericListener(this.generic, this.priority, false, this.event, event -> {
                if (event.getClass().isAssignableFrom(this.event) && this.filter.test((GenericEvent)event)) {
                    if (this.cancel && event.isCancelable()) {
                        event.setCanceled(true);
                    }
                    this.process.accept((GenericEvent)event);
                }
            });
        }

        public GenericEventManager<T, F> filter(Predicate<T> predicateFilter) {
            this.filter = this.filter.and(predicateFilter);
            return this;
        }

        public GenericEventManager<T, F> process(Consumer<T> process) {
            this.process = this.process.andThen(process);
            return this;
        }

        public GenericEventManager<T, F> cancel() {
            this.cancel = true;
            return this;
        }
    }

    public static class FilteredEventManager<T extends Event>
    implements ISubscribe {
        private Predicate<T> filter;
        private Consumer<T> process;
        private Class<T> event;
        private boolean cancel;
        private Bus bus;
        private EventPriority priority;

        public FilteredEventManager(Class<T> clazz, Bus bus, EventPriority priority) {
            this.event = clazz;
            this.filter = t -> true;
            this.process = t -> {};
            this.bus = bus;
            this.priority = priority;
        }

        @Override
        public void subscribe() {
            this.bus.bus().addListener(this.priority, false, this.event, event -> {
                if (event.getClass().isAssignableFrom(this.event) && this.filter.test((Event)event)) {
                    if (this.cancel && event.isCancelable()) {
                        event.setCanceled(true);
                    }
                    this.process.accept((Event)event);
                }
            });
        }

        public FilteredEventManager<T> filter(Predicate<T> predicateFilter) {
            this.filter = this.filter.and(predicateFilter);
            return this;
        }

        public FilteredEventManager<T> process(Consumer<T> process) {
            this.process = this.process.andThen(process);
            return this;
        }

        public FilteredEventManager<T> cancel() {
            this.cancel = true;
            return this;
        }
    }

    public static interface ISubscribe {
        public void subscribe();
    }

    public static enum Bus {
        FORGE(() -> MinecraftForge.EVENT_BUS),
        MOD(() -> FMLJavaModLoadingContext.get().getModEventBus());

        private final Supplier<IEventBus> busSupplier;

        private Bus(Supplier<IEventBus> eventBusSupplier) {
            this.busSupplier = eventBusSupplier;
        }

        public IEventBus bus() {
            return this.busSupplier.get();
        }
    }
}

