/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.network;

import com.google.gson.JsonObject;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class CompoundSerializableDataHandler {
    private static final HashMap<Class, Pair<Reader, Writer>> FIELD_SERIALIZER = new HashMap();

    public static <T> void map(Class<T> type, Reader<T> reader, Writer<T> writer) {
        FIELD_SERIALIZER.put(type, (Pair<Reader, Writer>)Pair.of(reader, writer));
    }

    private static long[] readLongArray(PacketBuffer buf) {
        return buf.func_186873_b(new long[0]);
    }

    private static String readString(PacketBuffer buf) {
        return buf.func_150789_c(Short.MAX_VALUE);
    }

    private static FluidStack readFluidStack(PacketBuffer buf) throws IOException {
        return FluidStack.loadFluidStackFromNBT((CompoundNBT)buf.func_150793_b());
    }

    private static void writeFluidStack(PacketBuffer buf, FluidStack stack) {
        buf.func_150786_a(stack == null ? FluidStack.EMPTY.writeToNBT(new CompoundNBT()) : stack.writeToNBT(new CompoundNBT()));
    }

    public static RegistryKey<?> readRegistryKey(PacketBuffer buffer) {
        return RegistryKey.func_240903_a_((RegistryKey)RegistryKey.func_240904_a_((ResourceLocation)buffer.func_192575_l()), (ResourceLocation)buffer.func_192575_l());
    }

    public static void writeRegistryKey(PacketBuffer buffer, RegistryKey<?> biome) {
        buffer.func_192572_a(biome.getRegistryName());
        buffer.func_192572_a(biome.func_240901_a_());
    }

    private static void writeUpdatePacket(PacketBuffer buf, SUpdateTileEntityPacket packet) {
        try {
            packet.func_148840_b(buf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Ingredient.IItemList[] readIItemListArray(PacketBuffer buf) {
        Ingredient.IItemList[] list = new Ingredient.IItemList[buf.readInt()];
        for (int i = 0; i < list.length; ++i) {
            list[i] = new CollectionItemList(buf);
        }
        return list;
    }

    private static void writeIItemListArray(PacketBuffer buf, Ingredient.IItemList[] list) {
        buf.writeInt(list.length);
        for (Ingredient.IItemList iItemList : list) {
            CollectionItemList.serializeBuffer(buf, iItemList);
        }
    }

    public static RegistryKey<?>[] readRegistryArray(PacketBuffer buffer) {
        RegistryKey[] registryKeys = new RegistryKey[buffer.readInt()];
        for (int i = 0; i < registryKeys.length; ++i) {
            registryKeys[i] = CompoundSerializableDataHandler.readRegistryKey(buffer);
        }
        return registryKeys;
    }

    public static void writeRegistryArray(PacketBuffer buffer, RegistryKey<?>[] registryKeys) {
        buffer.writeInt(registryKeys.length);
        for (RegistryKey<?> registryKey : registryKeys) {
            CompoundSerializableDataHandler.writeRegistryKey(buffer, registryKey);
        }
    }

    public static Ingredient[] readIngredientArray(PacketBuffer buffer) {
        Ingredient[] ingredients = new Ingredient[buffer.readInt()];
        for (int i = 0; i < ingredients.length; ++i) {
            ingredients[i] = Ingredient.func_199566_b((PacketBuffer)buffer);
        }
        return ingredients;
    }

    public static void writeIngredientArray(PacketBuffer buffer, Ingredient[] ingredients) {
        buffer.writeInt(ingredients.length);
        for (Ingredient ingredient : ingredients) {
            ingredient.func_199564_a(buffer);
        }
    }

    private static SUpdateTileEntityPacket readUpdatePacket(PacketBuffer buf) {
        SUpdateTileEntityPacket packet = new SUpdateTileEntityPacket();
        try {
            packet.func_148840_b(buf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return packet;
    }

    public static Pair<Reader, Writer> getHandler(Class<?> clazz) {
        Pair<Reader, Writer> pair = FIELD_SERIALIZER.get(clazz);
        if (pair == null) {
            throw new RuntimeException("No R/W handler for  " + clazz);
        }
        return pair;
    }

    public static void writeField(Field f, Class clazz, PacketBuffer buf, Object instance) throws IllegalArgumentException, IllegalAccessException {
        Pair<Reader, Writer> handler = CompoundSerializableDataHandler.getHandler(clazz);
        ((Writer)handler.getRight()).write(buf, f.get(instance));
    }

    public static void readField(Field f, Class clazz, PacketBuffer buf, Object instance) throws IllegalArgumentException, IllegalAccessException, IOException {
        Pair<Reader, Writer> handler = CompoundSerializableDataHandler.getHandler(clazz);
        f.set(instance, ((Reader)handler.getLeft()).read(buf));
    }

    public static boolean acceptField(Field f, Class<?> type) {
        int mods = f.getModifiers();
        return !Modifier.isFinal(mods) && !Modifier.isStatic(mods) && !Modifier.isTransient(mods) && CompoundSerializableDataHandler.getHandler(type) != null;
    }

    static {
        CompoundSerializableDataHandler.map(Byte.TYPE, PacketBuffer::readByte, PacketBuffer::writeByte);
        CompoundSerializableDataHandler.map(Short.TYPE, PacketBuffer::readShort, PacketBuffer::writeShort);
        CompoundSerializableDataHandler.map(Integer.TYPE, PacketBuffer::func_150792_a, PacketBuffer::func_150787_b);
        CompoundSerializableDataHandler.map(Long.TYPE, PacketBuffer::func_179260_f, PacketBuffer::func_179254_b);
        CompoundSerializableDataHandler.map(Float.TYPE, PacketBuffer::readFloat, PacketBuffer::writeFloat);
        CompoundSerializableDataHandler.map(Double.TYPE, PacketBuffer::readDouble, PacketBuffer::writeDouble);
        CompoundSerializableDataHandler.map(Boolean.TYPE, PacketBuffer::readBoolean, PacketBuffer::writeBoolean);
        CompoundSerializableDataHandler.map(Character.TYPE, PacketBuffer::readChar, PacketBuffer::writeChar);
        CompoundSerializableDataHandler.map(Byte.class, PacketBuffer::readByte, PacketBuffer::writeByte);
        CompoundSerializableDataHandler.map(Short.class, PacketBuffer::readShort, PacketBuffer::writeShort);
        CompoundSerializableDataHandler.map(Integer.class, PacketBuffer::func_150792_a, PacketBuffer::func_150787_b);
        CompoundSerializableDataHandler.map(Long.class, PacketBuffer::func_179260_f, PacketBuffer::func_179254_b);
        CompoundSerializableDataHandler.map(Float.class, PacketBuffer::readFloat, PacketBuffer::writeFloat);
        CompoundSerializableDataHandler.map(Double.class, PacketBuffer::readDouble, PacketBuffer::writeDouble);
        CompoundSerializableDataHandler.map(Boolean.class, PacketBuffer::readBoolean, PacketBuffer::writeBoolean);
        CompoundSerializableDataHandler.map(Character.class, PacketBuffer::readChar, PacketBuffer::writeChar);
        CompoundSerializableDataHandler.map(byte[].class, PacketBuffer::func_179251_a, PacketBuffer::func_179250_a);
        CompoundSerializableDataHandler.map(int[].class, PacketBuffer::func_186863_b, PacketBuffer::func_186875_a);
        CompoundSerializableDataHandler.map(long[].class, CompoundSerializableDataHandler::readLongArray, PacketBuffer::func_186865_a);
        CompoundSerializableDataHandler.map(String.class, CompoundSerializableDataHandler::readString, PacketBuffer::func_180714_a);
        CompoundSerializableDataHandler.map(CompoundNBT.class, PacketBuffer::func_150793_b, PacketBuffer::func_150786_a);
        CompoundSerializableDataHandler.map(ItemStack.class, PacketBuffer::func_150791_c, PacketBuffer::func_150788_a);
        CompoundSerializableDataHandler.map(FluidStack.class, CompoundSerializableDataHandler::readFluidStack, CompoundSerializableDataHandler::writeFluidStack);
        CompoundSerializableDataHandler.map(BlockPos.class, PacketBuffer::func_179259_c, PacketBuffer::func_179255_a);
        CompoundSerializableDataHandler.map(ITextComponent.class, PacketBuffer::func_179258_d, PacketBuffer::func_179256_a);
        CompoundSerializableDataHandler.map(Date.class, PacketBuffer::func_192573_m, PacketBuffer::func_192574_a);
        CompoundSerializableDataHandler.map(UUID.class, PacketBuffer::func_179253_g, PacketBuffer::func_179252_a);
        CompoundSerializableDataHandler.map(SUpdateTileEntityPacket.class, CompoundSerializableDataHandler::readUpdatePacket, CompoundSerializableDataHandler::writeUpdatePacket);
        CompoundSerializableDataHandler.map(LocatorInstance.class, LocatorFactory::readPacketBuffer, LocatorFactory::writePacketBuffer);
        CompoundSerializableDataHandler.map(Ingredient.IItemList.class, CollectionItemList::new, CollectionItemList::serializeBuffer);
        CompoundSerializableDataHandler.map(Ingredient.class, Ingredient::func_199566_b, (buf, ingredient) -> ingredient.func_199564_a(buf));
        CompoundSerializableDataHandler.map(Block.class, buf -> (Block)ForgeRegistries.BLOCKS.getValue(buf.func_192575_l()), (buf, block) -> buf.func_192572_a(block.getRegistryName()));
        CompoundSerializableDataHandler.map(Ingredient.IItemList[].class, CompoundSerializableDataHandler::readIItemListArray, CompoundSerializableDataHandler::writeIItemListArray);
        CompoundSerializableDataHandler.map(Ingredient[].class, CompoundSerializableDataHandler::readIngredientArray, CompoundSerializableDataHandler::writeIngredientArray);
        CompoundSerializableDataHandler.map(RegistryKey.class, CompoundSerializableDataHandler::readRegistryKey, CompoundSerializableDataHandler::writeRegistryKey);
        CompoundSerializableDataHandler.map(RegistryKey[].class, CompoundSerializableDataHandler::readRegistryArray, CompoundSerializableDataHandler::writeRegistryArray);
        CompoundSerializableDataHandler.map(ResourceLocation.class, PacketBuffer::func_192575_l, PacketBuffer::func_192572_a);
    }

    public static class CollectionItemList
    implements Ingredient.IItemList {
        private List<ItemStack> stackList = new ArrayList<ItemStack>();

        public CollectionItemList(PacketBuffer buffer) {
            int amount = buffer.readInt();
            for (int i = 0; i < amount; ++i) {
                this.stackList.add(buffer.func_150791_c());
            }
        }

        public static void serializeBuffer(PacketBuffer buffer, Ingredient.IItemList list) {
            buffer.writeInt(list.func_199799_a().size());
            list.func_199799_a().forEach(arg_0 -> ((PacketBuffer)buffer).func_150788_a(arg_0));
        }

        public Collection<ItemStack> func_199799_a() {
            return this.stackList;
        }

        public JsonObject func_200303_b() {
            return new JsonObject();
        }
    }

    public static interface Reader<T> {
        public T read(PacketBuffer var1) throws IOException;
    }

    public static interface Writer<T> {
        public void write(PacketBuffer var1, T var2);
    }
}

