/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.registry;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;

public class BlockRegistryObjectGroup<B extends Block, I extends Item, T extends TileEntity>
implements Supplier<B> {
    private final String name;
    private final Supplier<B> blockCreator;
    private final Function<B, I> itemCreator;
    private final Supplier<T> tileSupplier;
    private RegistryObject<B> block;
    private RegistryObject<I> item;
    private RegistryObject<TileEntityType<T>> tileEntity;

    public BlockRegistryObjectGroup(String name, Supplier<B> blockCreator, Function<B, I> itemCreator) {
        this(name, blockCreator, itemCreator, null);
    }

    public BlockRegistryObjectGroup(String name, Supplier<B> blockCreator, Function<B, I> itemCreator, Supplier<T> tileSupplier) {
        this.name = name;
        this.blockCreator = blockCreator;
        this.itemCreator = itemCreator;
        this.tileSupplier = tileSupplier;
    }

    @Nonnull
    public B getBlock() {
        return (B)((Block)Objects.requireNonNull(this.block).get());
    }

    @Nonnull
    public I getItem() {
        return (I)((Item)Objects.requireNonNull(this.item).get());
    }

    @Nonnull
    public TileEntityType<T> getTileEntityType() {
        return (TileEntityType)Objects.requireNonNull(this.tileEntity).get();
    }

    public BlockRegistryObjectGroup<B, I, ?> register(DeferredRegister<Block> blockRegistry, DeferredRegister<Item> itemRegistry) {
        this.block = blockRegistry.register(this.name, this.blockCreator);
        this.item = itemRegistry.register(this.name, () -> (Item)this.itemCreator.apply(this.getBlock()));
        return this;
    }

    public BlockRegistryObjectGroup<B, I, T> register(DeferredRegister<Block> blockRegistry, DeferredRegister<Item> itemRegistry, DeferredRegister<TileEntityType<?>> tileEntityTypeRegistry) {
        this.register(blockRegistry, itemRegistry);
        if (this.tileSupplier != null) {
            this.tileEntity = tileEntityTypeRegistry.register(this.name, () -> TileEntityType.Builder.func_223042_a(this.tileSupplier, (Block[])new Block[]{this.getBlock()}).func_206865_a(null));
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public B get() {
        return this.getBlock();
    }
}

