/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.common.collect.Streams;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.patchouli.client.book.AbstractReadStateHolder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookIcon;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;

public class BookCategory
extends AbstractReadStateHolder
implements Comparable<BookCategory> {
    private String name;
    private String description;
    private String parent;
    private String flag;
    @SerializedName(value="icon")
    private String iconRaw;
    private int sortnum;
    private boolean secret = false;
    private transient Book book;
    private transient Book trueProvider;
    private transient boolean checkedParent = false;
    private transient BookCategory parentCategory;
    private transient List<BookCategory> children = new ArrayList<BookCategory>();
    private transient List<BookEntry> entries = new ArrayList<BookEntry>();
    private transient boolean locked;
    private transient BookIcon icon = null;
    private transient ResourceLocation id;
    private transient boolean built;

    public ITextComponent getName() {
        return this.book.i18n ? new TranslationTextComponent(this.name) : new StringTextComponent(this.name);
    }

    public String getDescription() {
        return this.description;
    }

    public BookIcon getIcon() {
        if (this.icon == null) {
            this.icon = BookIcon.from(this.iconRaw);
        }
        return this.icon;
    }

    public void addEntry(BookEntry entry) {
        this.entries.add(entry);
    }

    public void addChildCategory(BookCategory category) {
        this.children.add(category);
    }

    public List<BookEntry> getEntries() {
        return this.entries;
    }

    public BookCategory getParentCategory() {
        if (!this.checkedParent && !this.isRootCategory()) {
            if (this.parent.contains(":")) {
                this.parentCategory = this.book.contents.categories.get(new ResourceLocation(this.parent));
            } else {
                if (this.isExtension()) {
                    this.parentCategory = this.book.contents.categories.get(new ResourceLocation(this.trueProvider.getModNamespace(), this.parent));
                }
                if (this.parentCategory == null) {
                    this.parentCategory = this.book.contents.categories.get(new ResourceLocation(this.book.getModNamespace(), this.parent));
                }
            }
            this.checkedParent = true;
        }
        return this.parentCategory;
    }

    public void updateLockStatus(boolean rootOnly) {
        boolean wasLocked;
        block4: {
            if (rootOnly && !this.isRootCategory()) {
                return;
            }
            this.children.forEach(c -> c.updateLockStatus(false));
            wasLocked = this.locked;
            this.locked = !this.children.isEmpty() || !this.entries.isEmpty();
            for (BookCategory c2 : this.children) {
                if (c2.isLocked()) continue;
                this.locked = false;
                break block4;
            }
            for (BookEntry e : this.entries) {
                if (e.isLocked()) continue;
                this.locked = false;
                break;
            }
        }
        if (!this.locked && wasLocked) {
            this.book.markUpdated();
        }
    }

    public boolean isSecret() {
        return this.secret;
    }

    public boolean shouldHide() {
        return this.isSecret() && this.isLocked();
    }

    public boolean isLocked() {
        return this.getBook().advancementsEnabled() && this.locked;
    }

    public boolean isRootCategory() {
        return this.parent == null || this.parent.isEmpty();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean canAdd() {
        return this.flag == null || this.flag.isEmpty() || PatchouliConfig.getConfigFlag(this.flag);
    }

    @Override
    public int compareTo(BookCategory o) {
        if (!this.book.advancementsEnabled() && o.locked != this.locked) {
            return this.locked ? 1 : -1;
        }
        return this.sortnum - o.sortnum;
    }

    public void setBook(Book book) {
        if (book.isExtension) {
            this.book = book.extensionTarget;
            this.trueProvider = book;
        } else {
            this.book = book;
        }
    }

    public void build(ResourceLocation id) {
        if (this.built) {
            return;
        }
        this.id = id;
        BookCategory parent = this.getParentCategory();
        if (parent != null) {
            parent.addChildCategory(this);
        }
        this.built = true;
    }

    public Book getBook() {
        return this.book;
    }

    public Book getTrueProvider() {
        return this.trueProvider;
    }

    public boolean isExtension() {
        return this.getTrueProvider() != null && this.getTrueProvider() != this.getBook();
    }

    @Override
    protected EntryDisplayState computeReadState() {
        Stream<EntryDisplayState> entryStream = this.entries.stream().filter(e -> !e.isLocked()).map(AbstractReadStateHolder::getReadState);
        Stream<EntryDisplayState> childrenStream = this.children.stream().map(AbstractReadStateHolder::getReadState);
        return BookCategory.mostImportantState(Streams.concat((Stream[])new Stream[]{entryStream, childrenStream}));
    }

    @Override
    public void markReadStateDirty() {
        super.markReadStateDirty();
        if (this.parentCategory != null) {
            this.parentCategory.markReadStateDirty();
        } else {
            this.book.contents.markReadStateDirty();
        }
    }
}

