/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.book;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookFolderLoader;

public class BookRegistry {
    public static final BookRegistry INSTANCE = new BookRegistry();
    public static final String BOOKS_LOCATION = "patchouli_books";
    public final Map<ResourceLocation, Book> books = new HashMap<ResourceLocation, Book>();
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create();
    private boolean loaded = false;

    private BookRegistry() {
    }

    public void init() {
        List mods = ModList.get().getMods();
        HashMap<Pair, String> foundBooks = new HashMap<Pair, String>();
        mods.forEach(mod -> {
            String id = mod.getModId();
            BookRegistry.findFiles((IModInfo)mod, String.format("data/%s/%s", id, BOOKS_LOCATION), path -> Files.exists(path, new LinkOption[0]), (path, file) -> {
                if (file.toString().endsWith("book.json")) {
                    String fileStr = file.toString().replaceAll("\\\\", "/");
                    String relPath = fileStr.substring(fileStr.indexOf(BOOKS_LOCATION) + BOOKS_LOCATION.length() + 1);
                    String bookName = relPath.substring(0, relPath.indexOf("/"));
                    if (bookName.contains("/")) {
                        Patchouli.LOGGER.warn("Ignored book.json @ {}", file);
                        return true;
                    }
                    String assetPath = fileStr.substring(fileStr.indexOf("/data"));
                    ResourceLocation bookId = new ResourceLocation(id, bookName);
                    foundBooks.put(Pair.of((Object)mod, (Object)bookId), assetPath);
                }
                return true;
            }, true);
        });
        foundBooks.forEach((pair, file) -> {
            ModInfo mod = (ModInfo)pair.getLeft();
            Optional container = ModList.get().getModContainerById(mod.getModId());
            container.ifPresent(c -> {
                ResourceLocation res = (ResourceLocation)pair.getRight();
                Class<?> ownerClass = c.getMod().getClass();
                try (InputStream stream = ownerClass.getResourceAsStream((String)file);){
                    this.loadBook((IModInfo)mod, ownerClass, res, stream, false);
                }
                catch (Exception e) {
                    Patchouli.LOGGER.error("Failed to load book {} defined by mod {}, skipping", (Object)res, (Object)c.getModInfo().getModId(), (Object)e);
                }
            });
        });
        BookFolderLoader.findBooks();
    }

    public void loadBook(IModInfo mod, Class<?> ownerClass, ResourceLocation res, InputStream stream, boolean external) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        Book book = (Book)GSON.fromJson((Reader)reader, Book.class);
        book.build(mod, ownerClass, res, external);
        this.books.put(res, book);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void reloadContents() {
        PatchouliConfig.reloadBuiltinFlags();
        this.books.values().forEach(Book::reloadContents);
        this.books.values().forEach(Book::reloadExtensionContents);
        ClientBookRegistry.INSTANCE.reloadLocks(false);
        this.loaded = true;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public static void findFiles(IModInfo mod, String base, Predicate<Path> rootFilter, BiFunction<Path, Path, Boolean> processor, boolean visitAllFiles) {
        block17: {
            if (mod.getModId().equals("minecraft") || mod.getModId().equals("forge")) {
                return;
            }
            IModFileInfo info = mod.getOwningFile();
            if (!(info instanceof ModFileInfo)) {
                return;
            }
            Path source = ((ModFileInfo)info).getFile().getFilePath();
            try {
                if (Files.isRegularFile(source, new LinkOption[0])) {
                    try (FileSystem fs = FileSystems.newFileSystem(source, null);){
                        BookRegistry.walk(fs.getPath("/" + base, new String[0]), rootFilter, processor, visitAllFiles);
                        break block17;
                    }
                }
                BookRegistry.walk(source.resolve(base), rootFilter, processor, visitAllFiles);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    private static void walk(Path root, Predicate<Path> rootFilter, BiFunction<Path, Path, Boolean> processor, boolean visitAllFiles) throws IOException {
        if (root == null || !Files.exists(root, new LinkOption[0]) || !rootFilter.test(root)) {
            return;
        }
        if (processor != null) {
            Iterator itr = Files.walk(root, new FileVisitOption[0]).iterator();
            while (itr.hasNext()) {
                boolean cont = processor.apply(root, (Path)itr.next());
                if (visitAllFiles || cont) continue;
                return;
            }
        }
    }
}

