/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.client;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.SidedCache;
import atomicstryker.infernalmobs.common.mods.MM_Gravity;
import atomicstryker.infernalmobs.common.network.HealthPacket;
import atomicstryker.infernalmobs.common.network.MobModsPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.BossHealthOverlay;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="infernalmobs")
public class InfernalMobsClient {
    private static final ResourceLocation GUI_BARS_LOCATION = new ResourceLocation("textures/gui/bars.png");
    private static int airOverrideValue = -999;
    private static final double NAME_VISION_DISTANCE = 32.0;
    private static long airDisplayTimeout;
    private static Minecraft mc;
    private static long nextPacketTime;
    private static long healthBarRetainTime;
    private static LivingEntity retainedTarget;
    private static LinkedHashMap<UUID, LerpingBossEvent> vanillaBossEventsMap;

    @SubscribeEvent
    public static void playerLoginToServer(ClientPlayerNetworkEvent.LoggedInEvent evt) {
        mc = Minecraft.m_91087_();
        if (evt.getPlayer() != null) {
            InfernalMobsCore.instance().initIfNeeded(evt.getPlayer().f_19853_);
        }
    }

    public static void load() {
        nextPacketTime = 0L;
        healthBarRetainTime = 0L;
        retainedTarget = null;
    }

    @SubscribeEvent
    public static void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().f_46443_ && InfernalMobsClient.mc.f_91074_ != null && (event.getEntity() instanceof Mob || event.getEntity() instanceof LivingEntity && event.getEntity() instanceof Enemy)) {
            InfernalMobsCore.instance().networkHelper.sendPacketToServer(new MobModsPacket(InfernalMobsClient.mc.f_91074_.m_7755_().m_6111_(), event.getEntity().m_142049_(), 0));
            InfernalMobsCore.LOGGER.debug("onEntityJoinedWorld {}, ent-id {} querying modifiers from server", (Object)event.getEntity(), (Object)event.getEntity().m_142049_());
        }
    }

    private static void askServerMods(Entity ent) {
        if (System.currentTimeMillis() > nextPacketTime && (ent instanceof Mob || ent instanceof LivingEntity && ent instanceof Enemy)) {
            InfernalMobsCore.instance().networkHelper.sendPacketToServer(new MobModsPacket(InfernalMobsClient.mc.f_91074_.m_7755_().m_6111_(), ent.m_142049_(), 0));
            InfernalMobsCore.LOGGER.debug("askServerMods {}, ent-id {} querying modifiers from server", (Object)ent, (Object)ent.m_142049_());
            nextPacketTime = System.currentTimeMillis() + 250L;
        }
    }

    private static void askServerHealth(Entity ent) {
        if (System.currentTimeMillis() > nextPacketTime) {
            InfernalMobsCore.instance().networkHelper.sendPacketToServer(new HealthPacket(InfernalMobsClient.mc.f_91074_.m_7755_().m_6111_(), ent.m_142049_(), 0.0f, 0.0f));
            nextPacketTime = System.currentTimeMillis() + 250L;
        }
    }

    @SubscribeEvent
    public static void playerLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent evt) {
        if (evt.getPlayer() != null && evt.getPlayer().f_19853_ != null) {
            SidedCache.getInfernalMobs(evt.getPlayer().f_19853_).clear();
        }
    }

    @SubscribeEvent
    public static void onPreRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (InfernalMobsCore.instance().getIsHealthBarDisabled() || event.getType() != RenderGameOverlayEvent.ElementType.CHAT || InfernalMobsClient.mc.f_91065_.m_93090_().m_93713_()) {
            return;
        }
        LivingEntity ent = InfernalMobsClient.getEntityCrosshairOver(event.getPartialTicks(), mc);
        boolean retained = false;
        if (ent == null && System.currentTimeMillis() < healthBarRetainTime) {
            ent = retainedTarget;
            retained = true;
        } else if (retainedTarget != null) {
            vanillaBossEventsMap.remove(retainedTarget.m_142081_());
            retainedTarget = null;
        }
        if (vanillaBossEventsMap == null) {
            boolean hackSuccess = false;
            for (Field declaredField : BossHealthOverlay.class.getDeclaredFields()) {
                if (declaredField.getType() != Map.class) continue;
                declaredField.setAccessible(true);
                try {
                    vanillaBossEventsMap = (LinkedHashMap)declaredField.get(InfernalMobsClient.mc.f_91065_.m_93090_());
                    hackSuccess = true;
                }
                catch (IllegalAccessException e) {
                    hackSuccess = false;
                }
            }
            if (!hackSuccess) {
                vanillaBossEventsMap = new LinkedHashMap();
            }
        }
        if (ent != null) {
            MobModifier mod = InfernalMobsCore.getMobModifiers(ent);
            if (mod != null) {
                BossEvent.BossBarColor color;
                int modStr;
                InfernalMobsClient.askServerHealth((Entity)ent);
                UUID uuid = ent.m_142081_();
                TextComponent name = new TextComponent(mod.getEntityDisplayName(ent));
                float progress = mod.getActualHealth(ent) / mod.getActualMaxHealth(ent);
                if (ent.m_21224_()) {
                    progress = 0.01f;
                }
                BossEvent.BossBarColor bossBarColor = (modStr = mod.getModSize()) <= 5 ? BossEvent.BossBarColor.GREEN : (color = modStr <= 10 ? BossEvent.BossBarColor.YELLOW : BossEvent.BossBarColor.RED);
                if (!vanillaBossEventsMap.containsKey(uuid)) {
                    vanillaBossEventsMap.put(uuid, new LerpingBossEvent(uuid, (Component)name, progress, color, BossEvent.BossBarOverlay.PROGRESS, false, false, false));
                } else {
                    LerpingBossEvent bossEvent = vanillaBossEventsMap.get(uuid);
                    bossEvent.m_142711_(progress);
                }
                if (vanillaBossEventsMap.size() == 1) {
                    InfernalMobsClient.drawModifiersUnderHealthBar(event, ent, mod);
                }
                if (!retained) {
                    retainedTarget = ent;
                    healthBarRetainTime = System.currentTimeMillis() + 3000L;
                }
            } else {
                InfernalMobsClient.askServerMods((Entity)ent);
            }
        }
    }

    private static void drawModifiersUnderHealthBar(RenderGameOverlayEvent.Pre event, LivingEntity ent, MobModifier mod) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_BARS_LOCATION);
        int screenwidth = mc.m_91268_().m_85445_();
        Font fontR = InfernalMobsClient.mc.f_91062_;
        PoseStack matrixStack = event.getMatrixStack();
        int yCoord = 10;
        String[] display = mod.getDisplayNames();
        for (int i = 0; i < display.length && display[i] != null; ++i) {
            fontR.m_92750_(matrixStack, display[i], (float)(screenwidth / 2 - fontR.m_92895_(display[i]) / 2), (float)(yCoord += 10), 0xFFFFFF);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
    }

    private static LivingEntity getEntityCrosshairOver(float partialTicks, Minecraft mc) {
        Entity entity = mc.m_91288_();
        if (entity != null && mc.f_91073_ != null) {
            AABB axisalignedbb;
            double distance = 32.0;
            HitResult result = entity.m_19907_(distance, partialTicks, false);
            Vec3 vec3d = entity.m_20299_(partialTicks);
            double distanceToHit = result.m_82450_().m_82557_(vec3d);
            Vec3 vec3d1 = entity.m_20252_(1.0f);
            Vec3 vec3d2 = vec3d.m_82520_(vec3d1.f_82479_ * distance, vec3d1.f_82480_ * distance, vec3d1.f_82481_ * distance);
            EntityHitResult entityraytraceresult = ProjectileUtil.m_37287_((Entity)entity, (Vec3)vec3d, (Vec3)vec3d2, (AABB)(axisalignedbb = entity.m_142469_().m_82369_(vec3d1.m_82490_(distance)).m_82377_(1.0, 1.0, 1.0)), p_lambda$getMouseOver$0_0_ -> !p_lambda$getMouseOver$0_0_.m_5833_() && p_lambda$getMouseOver$0_0_.m_6087_(), (double)distanceToHit);
            if (entityraytraceresult != null) {
                Entity entity1 = entityraytraceresult.m_82443_();
                Vec3 vec3d3 = entityraytraceresult.m_82450_();
                double d2 = vec3d.m_82557_(vec3d3);
                if (d2 < distanceToHit && entity1 instanceof LivingEntity) {
                    return (LivingEntity)entity1;
                }
            }
        }
        return null;
    }

    public static void onHealthPacketForClient(int entID, float health, float maxhealth) {
        Minecraft.m_91087_().m_18689_(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> InfernalMobsClient.onHealthPacket(entID, health, maxhealth)));
    }

    private static void onHealthPacket(int entID, float health, float maxhealth) {
        MobModifier mod;
        Entity ent = Minecraft.m_91087_().f_91073_.m_6815_(entID);
        if (ent instanceof LivingEntity && (mod = InfernalMobsCore.getMobModifiers((LivingEntity)ent)) != null) {
            mod.setActualHealth(health, maxhealth);
        }
    }

    public static void onKnockBackPacket(float xv, float zv) {
        mc.m_18689_(() -> MM_Gravity.knockBack((LivingEntity)InfernalMobsClient.mc.f_91074_, xv, zv));
    }

    public static void onMobModsPacketToClient(String stringData, int entID) {
        InfernalMobsCore.instance().addRemoteEntityModifiers((Level)InfernalMobsClient.mc.f_91073_, entID, stringData);
    }

    public static void onVelocityPacket(float xv, float yv, float zv) {
        mc.m_18689_(() -> InfernalMobsClient.mc.f_91074_.m_5997_((double)xv, (double)yv, (double)zv));
    }

    public static void onAirPacket(int air) {
        airOverrideValue = air;
        airDisplayTimeout = System.currentTimeMillis() + 3000L;
    }

    public static File getMcFolder() {
        return Minecraft.m_91087_().f_91069_;
    }

    @SubscribeEvent
    public static void onTick(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.LAYER) {
            if (System.currentTimeMillis() > airDisplayTimeout) {
                airOverrideValue = -999;
            }
            if (!InfernalMobsClient.mc.f_91074_.m_19941_((Tag)FluidTags.f_13131_) && airOverrideValue != -999) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
                int leftScreenCoordinate = mc.m_91268_().m_85445_() / 2 + 91;
                int topScreenCoordinate = mc.m_91268_().m_85446_() - 59;
                int maxHearts = InfernalMobsClient.getVehicleMaxHearts((LivingEntity)InfernalMobsClient.mc.f_91074_);
                int maxAir = InfernalMobsClient.mc.f_91074_.m_6062_();
                int currentAir = Math.min(airOverrideValue, maxAir);
                int rowCount = InfernalMobsClient.getVisibleVehicleHeartRows(maxHearts) - 1;
                topScreenCoordinate -= rowCount * 10;
                int fullBubbles = Mth.m_14165_((double)((double)(currentAir - 2) * 10.0 / (double)maxAir));
                int partialBubbles = Mth.m_14165_((double)((double)currentAir * 10.0 / (double)maxAir)) - fullBubbles;
                for (int j5 = 0; j5 < fullBubbles + partialBubbles; ++j5) {
                    if (j5 < fullBubbles) {
                        InfernalMobsClient.mc.f_91065_.m_93228_(event.getMatrixStack(), leftScreenCoordinate - j5 * 8 - 9, topScreenCoordinate, 16, 18, 9, 9);
                        continue;
                    }
                    InfernalMobsClient.mc.f_91065_.m_93228_(event.getMatrixStack(), leftScreenCoordinate - j5 * 8 - 9, topScreenCoordinate, 25, 18, 9, 9);
                }
            }
        }
    }

    private static int getVehicleMaxHearts(LivingEntity livingEntity) {
        if (livingEntity != null && livingEntity.m_20152_()) {
            float maxHealth = livingEntity.m_21233_();
            int roundedHalf = (int)(maxHealth + 0.5f) / 2;
            if (roundedHalf > 30) {
                roundedHalf = 30;
            }
            return roundedHalf;
        }
        return 0;
    }

    private static int getVisibleVehicleHeartRows(int heartCount) {
        return (int)Math.ceil((double)heartCount / 10.0);
    }

    static {
        vanillaBossEventsMap = null;
    }
}

