/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.network;

import atomicstryker.infernalmobs.client.InfernalMobsClient;
import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.network.NetworkHelper;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;

public class HealthPacket
implements NetworkHelper.IPacket {
    private String stringData;
    private int entID;
    private float health;
    private float maxhealth;

    public HealthPacket() {
    }

    public HealthPacket(String u, int i, float entHealth, float entMaxHealth) {
        this.stringData = u;
        this.entID = i;
        this.health = entHealth;
        this.maxhealth = entMaxHealth;
    }

    @Override
    public void encode(Object msg, FriendlyByteBuf packetBuffer) {
        HealthPacket healthPacket = (HealthPacket)msg;
        packetBuffer.m_130070_(healthPacket.stringData);
        packetBuffer.writeInt(healthPacket.entID);
        packetBuffer.writeFloat(healthPacket.health);
        packetBuffer.writeFloat(healthPacket.maxhealth);
    }

    @Override
    public <MSG> MSG decode(FriendlyByteBuf packetBuffer) {
        HealthPacket result = new HealthPacket();
        result.stringData = packetBuffer.m_130136_(Short.MAX_VALUE);
        result.entID = packetBuffer.readInt();
        result.health = packetBuffer.readFloat();
        result.maxhealth = packetBuffer.readFloat();
        return (MSG)result;
    }

    @Override
    public void handle(Object msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            HealthPacket healthPacket = (HealthPacket)msg;
            if (healthPacket.maxhealth > 0.0f) {
                InfernalMobsClient.onHealthPacketForClient(healthPacket.entID, healthPacket.health, healthPacket.maxhealth);
            } else {
                LivingEntity e;
                MobModifier mod;
                Entity ent;
                ServerPlayer p = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(healthPacket.stringData);
                if (p != null && (ent = p.f_19853_.m_6815_(healthPacket.entID)) instanceof LivingEntity && (mod = InfernalMobsCore.getMobModifiers(e = (LivingEntity)ent)) != null) {
                    this.stringData = healthPacket.stringData;
                    this.entID = healthPacket.entID;
                    this.health = e.m_21223_();
                    this.maxhealth = e.m_21233_();
                    InfernalMobsCore.instance().networkHelper.sendPacketToPlayer(new HealthPacket(this.stringData, this.entID, this.health, this.maxhealth), p);
                }
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }

    public String getStringData() {
        return this.stringData;
    }

    public int getEntID() {
        return this.entID;
    }

    public float getHealth() {
        return this.health;
    }

    public float getMaxhealth() {
        return this.maxhealth;
    }
}

