/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.network;

import atomicstryker.infernalmobs.client.InfernalMobsClient;
import atomicstryker.infernalmobs.common.network.NetworkHelper;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class VelocityPacket
implements NetworkHelper.IPacket {
    private float xv;
    private float yv;
    private float zv;

    public VelocityPacket() {
    }

    public VelocityPacket(float x, float y, float z) {
        this.xv = x;
        this.yv = y;
        this.zv = z;
    }

    @Override
    public void encode(Object msg, FriendlyByteBuf packetBuffer) {
        VelocityPacket velocityPacket = (VelocityPacket)msg;
        packetBuffer.writeFloat(velocityPacket.xv);
        packetBuffer.writeFloat(velocityPacket.yv);
        packetBuffer.writeFloat(velocityPacket.zv);
    }

    @Override
    public <MSG> MSG decode(FriendlyByteBuf packetBuffer) {
        VelocityPacket velocityPacket = new VelocityPacket();
        velocityPacket.xv = packetBuffer.readFloat();
        velocityPacket.yv = packetBuffer.readFloat();
        velocityPacket.zv = packetBuffer.readFloat();
        return (MSG)velocityPacket;
    }

    @Override
    public void handle(Object msg, Supplier<NetworkEvent.Context> contextSupplier) {
        VelocityPacket velocityPacket = (VelocityPacket)msg;
        InfernalMobsClient.onVelocityPacket(velocityPacket.xv, velocityPacket.yv, velocityPacket.zv);
        contextSupplier.get().setPacketHandled(true);
    }
}

