/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.mods.MM_Webber;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;

public class MM_Gravity
extends MobModifier {
    private static final long coolDown = 5000L;
    private static Class<?>[] modBans = new Class[]{MM_Webber.class};
    private static String[] suffix = new String[]{"ofRepulsion", "theFlipper"};
    private static String[] prefix = new String[]{"repulsing", "sproing"};
    private long nextAbilityUse = 0L;

    public MM_Gravity() {
    }

    public MM_Gravity(MobModifier next) {
        super(next);
    }

    public static void knockBack(LivingEntity target, double x, double z) {
        target.field_70160_al = true;
        float normalizedPower = MathHelper.func_76133_a((double)(x * x + z * z));
        float knockPower = 0.8f;
        double motionX = target.func_213322_ci().field_72450_a;
        double motionY = target.func_213322_ci().field_72450_a;
        double motionZ = target.func_213322_ci().field_72450_a;
        motionX /= 2.0;
        motionY /= 2.0;
        motionZ /= 2.0;
        motionX -= x / (double)normalizedPower * (double)knockPower;
        motionY += (double)knockPower;
        motionZ -= z / (double)normalizedPower * (double)knockPower;
        if (motionY > (double)0.4f) {
            motionY = 0.4f;
        }
        target.func_213293_j(motionX, motionY, motionZ);
    }

    @Override
    public String getModName() {
        return "Gravity";
    }

    @Override
    public boolean onUpdate(LivingEntity mob) {
        if (this.hasSteadyTarget() && this.getMobTarget() instanceof PlayerEntity) {
            this.tryAbility(mob, this.getMobTarget());
        }
        return super.onUpdate(mob);
    }

    private void tryAbility(LivingEntity mob, LivingEntity target) {
        if (target == null || !mob.func_70685_l((Entity)target)) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time > this.nextAbilityUse) {
            this.nextAbilityUse = time + 5000L;
            double diffX = target.func_226277_ct_() - mob.func_226277_ct_();
            double diffZ = target.func_226281_cx_() - mob.func_226281_cx_();
            while (diffX * diffX + diffZ * diffZ < 1.0E-4) {
                diffX = (Math.random() - Math.random()) * 0.01;
                diffZ = (Math.random() - Math.random()) * 0.01;
            }
            mob.field_70170_p.func_184133_a(null, mob.func_233580_cy_(), SoundEvents.field_187596_cD, SoundCategory.HOSTILE, 1.0f + mob.func_70681_au().nextFloat(), mob.func_70681_au().nextFloat() * 0.7f + 0.3f);
            if (mob.field_70170_p.field_72995_K || !(target instanceof ServerPlayerEntity)) {
                MM_Gravity.knockBack(target, diffX, diffZ);
            } else {
                InfernalMobsCore.instance().sendKnockBackPacket((ServerPlayerEntity)target, (float)diffX, (float)diffZ);
            }
        }
    }

    @Override
    public Class<?>[] getModsNotToMixWith() {
        return modBans;
    }

    @Override
    protected String[] getModNameSuffix() {
        return suffix;
    }

    @Override
    protected String[] getModNamePrefix() {
        return prefix;
    }
}

