/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public final class BlockHelpers {
    public static <T extends Comparable<T>> T getSafeBlockStateProperty(@Nullable BlockState state, Property<T> property, T fallback) {
        Comparable value;
        if (state == null) {
            return fallback;
        }
        try {
            value = state.func_177229_b(property);
        }
        catch (IllegalArgumentException e) {
            return fallback;
        }
        if (value == null) {
            return fallback;
        }
        return (T)value;
    }

    public static CompoundNBT serializeBlockState(BlockState blockState) {
        return NBTUtil.func_190009_a((BlockState)blockState);
    }

    public static BlockState deserializeBlockState(CompoundNBT serializedBlockState) {
        return NBTUtil.func_190008_d((CompoundNBT)serializedBlockState);
    }

    public static BlockState getBlockStateFromItemStack(ItemStack itemStack) {
        Block block = ((BlockItem)itemStack.func_77973_b()).func_179223_d();
        return block.func_176223_P();
    }

    public static ItemStack getItemStackFromBlockState(BlockState blockState) {
        return new ItemStack((IItemProvider)blockState.func_177230_c().func_199767_j());
    }

    public static void markForUpdate(World world, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        world.func_184138_a(pos, blockState, blockState, 3);
    }

    public static void addCollisionBoxToList(BlockPos pos, AxisAlignedBB collidingBox, List<AxisAlignedBB> collisions, AxisAlignedBB addingBox) {
        AxisAlignedBB axisalignedbb;
        if (addingBox != null && collidingBox.func_72326_a(axisalignedbb = addingBox.func_186670_a(pos))) {
            collisions.add(axisalignedbb);
        }
    }

    public static boolean doesBlockHaveSolidTopSurface(IWorldReader world, BlockPos blockPos) {
        return world.func_180495_p(blockPos.func_177982_a(0, -1, 0)).func_200015_d((IBlockReader)world, blockPos);
    }

    public static void setFireInfo(Block blockIn, int encouragement, int flammability) {
        if (blockIn == Blocks.field_150350_a) {
            throw new IllegalArgumentException("Tried to set air on fire... This is bad.");
        }
        ((FireBlock)Blocks.field_150480_ab).field_149849_a.put((Object)blockIn, encouragement);
        ((FireBlock)Blocks.field_150480_ab).field_149848_b.put((Object)blockIn, flammability);
    }
}

