/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBookRegistry;
import org.cyclops.cyclopscore.infobook.InfoBookParser;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.pageelement.AdvancementRewards;

public class InfoBookRegistry
implements IInfoBookRegistry {
    private final Map<IInfoBook, String> bookPaths = Maps.newIdentityHashMap();
    private final Map<IInfoBook, InfoSection> bookRoots = Maps.newIdentityHashMap();
    private final List<SectionInjection> sectionInjections = Lists.newArrayList();
    private volatile boolean infobookStageTags = false;
    private volatile boolean infobookStageRecipes = false;

    public InfoBookRegistry() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onClientTagsLoaded);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onClientRecipesLoaded);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarted);
    }

    @Override
    public void registerInfoBook(IInfoBook infoBook, String path) {
        this.bookPaths.put(infoBook, path);
    }

    @Override
    public void registerSection(IInfoBook infoBook, String parentSection, String sectionPath) {
        this.sectionInjections.add(new SectionInjection(infoBook, parentSection, sectionPath));
    }

    @Override
    public InfoSection getRoot(IInfoBook infoBook) {
        return this.bookRoots.get(infoBook);
    }

    public void onClientTagsLoaded(TagsUpdatedEvent event) {
        this.infobookStageTags = true;
        if (this.infobookStageTags && this.infobookStageRecipes) {
            this.afterRecipesAndTagsLoaded();
        }
    }

    public void onClientRecipesLoaded(RecipesUpdatedEvent event) {
        this.infobookStageRecipes = true;
        if (this.infobookStageTags && this.infobookStageRecipes) {
            this.afterRecipesAndTagsLoaded();
        }
    }

    public void onServerStarted(FMLServerStartedEvent event) {
        if (!MinecraftHelpers.isClientSide()) {
            this.afterRecipesAndTagsLoaded();
        }
    }

    public void afterRecipesAndTagsLoaded() {
        AdvancementRewards.reset();
        this.infobookStageTags = false;
        this.infobookStageRecipes = false;
        for (Map.Entry<IInfoBook, String> entry : this.bookPaths.entrySet()) {
            this.bookRoots.put(entry.getKey(), InfoBookParser.initializeInfoBook(entry.getKey(), entry.getValue(), null));
            entry.getKey().setCurrentSection(null);
        }
        for (SectionInjection sectionInjection : this.sectionInjections) {
            InfoSection section = sectionInjection.getInfoBook().getSection(sectionInjection.getParentSection());
            if (section == null) {
                throw new IllegalArgumentException(String.format("Could not find section '%s' in infobook '%s'.", sectionInjection.getParentSection(), sectionInjection.getInfoBook()));
            }
            section.registerSection(InfoBookParser.initializeInfoBook(sectionInjection.getInfoBook(), sectionInjection.getSectionPath(), section));
        }
    }

    private static final class SectionInjection {
        private final IInfoBook infoBook;
        private final String parentSection;
        private final String sectionPath;

        private SectionInjection(IInfoBook infoBook, String parentSection, String sectionPath) {
            this.infoBook = infoBook;
            this.parentSection = parentSection;
            this.sectionPath = sectionPath;
        }

        public IInfoBook getInfoBook() {
            return this.infoBook;
        }

        public String getParentSection() {
            return this.parentSection;
        }

        public String getSectionPath() {
            return this.sectionPath;
        }
    }
}

