/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;

public class FurnaceRecipeAppendix
extends RecipeAppendix<IRecipe<IInventory>> {
    private static final int SLOT_OFFSET_X = 16;
    private static final int SLOT_OFFSET_Y = 3;
    private static final int START_X_RESULT = 68;
    private static final AdvancedButtonEnum INPUT = AdvancedButtonEnum.create();
    private static final AdvancedButtonEnum RESULT = AdvancedButtonEnum.create();

    public FurnaceRecipeAppendix(IInfoBook infoBook, IRecipe<IInventory> recipe) {
        super(infoBook, recipe);
    }

    @Override
    protected int getWidth() {
        return 100;
    }

    @Override
    protected int getHeightInner() {
        return 22;
    }

    @Override
    protected String getUnlocalizedTitle() {
        return "block.minecraft.furnace";
    }

    @Override
    public void bakeElement(InfoSection infoSection) {
        this.renderItemHolders.put(INPUT, new RecipeAppendix.ItemButton(this.getInfoBook()));
        this.renderItemHolders.put(RESULT, new RecipeAppendix.ItemButton(this.getInfoBook()));
        super.bakeElement(infoSection);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawElementInner(ScreenInfoBook gui, MatrixStack matrixStack, int x, int y, int width, int height, int page, int mx, int my) {
        int middle = (width - 16) / 2;
        gui.drawArrowRight(matrixStack, x + middle - 3, y + 3 + 2);
        int tick = this.getTick(gui);
        ItemStack input = this.prepareItemStacks(Lists.newArrayList((Object[])((Ingredient)((IRecipe)this.recipe).func_192400_c().get(0)).func_193365_a()), tick);
        ItemStack result = this.prepareItemStack(((IRecipe)this.recipe).func_77571_b(), tick);
        this.renderItem(gui, matrixStack, x + 16, y + 3, input, mx, my, INPUT);
        this.renderItem(gui, matrixStack, x + 68, y + 3, result, mx, my, RESULT);
        this.renderItem(gui, matrixStack, x + middle, y + 3, new ItemStack((IItemProvider)Blocks.field_150460_al), mx, my, false, null);
    }
}

