/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.fluidhandler;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.commoncapabilities.api.capability.fluidhandler.FluidMatch;

public class FilteredFluidHandlerFluidStackIterator
implements Iterator<FluidStack> {
    private final IFluidHandler fluidHandler;
    private final FluidStack prototype;
    private final int matchFlags;
    private int slot = 0;
    private FluidStack next;

    public FilteredFluidHandlerFluidStackIterator(IFluidHandler fluidHandler, FluidStack prototype, int matchFlags) {
        this.fluidHandler = fluidHandler;
        this.prototype = prototype;
        this.matchFlags = matchFlags;
        this.next = this.findNext();
    }

    protected FluidStack findNext() {
        while (this.slot < this.fluidHandler.getTanks()) {
            FluidStack fluidStack;
            if (!FluidMatch.areFluidStacksEqual(fluidStack = this.fluidHandler.getFluidInTank(this.slot++), this.prototype, this.matchFlags)) continue;
            return fluidStack;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public FluidStack next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Slot out of bounds");
        }
        FluidStack next = this.next;
        this.next = this.findNext();
        return next;
    }
}

