/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.data.ModelProperty;
import org.cyclops.cyclopscore.block.BlockTile;
import org.cyclops.cyclopscore.client.icon.Icon;
import org.cyclops.cyclopscore.client.model.IDynamicModelElement;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.IDynamicLight;
import org.cyclops.integrateddynamics.api.block.IDynamicRedstone;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.block.shapes.VoxelShapeComponentsFactoryHandlerCableCenter;
import org.cyclops.integrateddynamics.block.shapes.VoxelShapeComponentsFactoryHandlerCableConnections;
import org.cyclops.integrateddynamics.block.shapes.VoxelShapeComponentsFactoryHandlerFacade;
import org.cyclops.integrateddynamics.block.shapes.VoxelShapeComponentsFactoryHandlerParts;
import org.cyclops.integrateddynamics.capability.dynamiclight.DynamicLightConfig;
import org.cyclops.integrateddynamics.capability.dynamicredstone.DynamicRedstoneConfig;
import org.cyclops.integrateddynamics.client.model.CableModel;
import org.cyclops.integrateddynamics.client.model.IRenderState;
import org.cyclops.integrateddynamics.core.block.BlockRayTraceResultComponent;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponents;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponentsFactory;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.tileentity.TileMultipartTicking;

public class BlockCable
extends BlockTile
implements IDynamicModelElement,
IWaterLoggable {
    public static final float BLOCK_HARDNESS = 3.0f;
    public static final Material BLOCK_MATERIAL = Material.field_151592_s;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final ModelProperty<Boolean> REALCABLE = new ModelProperty();
    public static final ModelProperty<Boolean>[] CONNECTED = new ModelProperty[6];
    public static final ModelProperty<PartRenderPosition>[] PART_RENDERPOSITIONS = new ModelProperty[6];
    public static final ModelProperty<Optional<BlockState>> FACADE = new ModelProperty();
    public static final ModelProperty<IPartContainer> PARTCONTAINER;
    public static final ModelProperty<IRenderState> RENDERSTATE;
    public static final AxisAlignedBB CABLE_CENTER_BOUNDINGBOX;
    private static final EnumFacingMap<AxisAlignedBB> CABLE_SIDE_BOUNDINGBOXES;
    private final VoxelShapeComponentsFactory voxelShapeComponentsFactory = new VoxelShapeComponentsFactory(new VoxelShapeComponentsFactoryHandlerCableCenter(), new VoxelShapeComponentsFactoryHandlerCableConnections(), new VoxelShapeComponentsFactoryHandlerFacade(), new VoxelShapeComponentsFactoryHandlerParts());
    @OnlyIn(value=Dist.CLIENT)
    @Icon(location="block/cable")
    public TextureAtlasSprite texture;
    private boolean disableCollisionBox = false;

    public BlockCable(AbstractBlock.Properties properties) {
        super(properties, TileMultipartTicking::new);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        if (MinecraftHelpers.isClientSide()) {
            IntegratedDynamics._instance.getIconProvider().registerIconHolderObject((Object)this);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) == false && fluidIn == Fluids.field_204546_a && !CableHelpers.hasFacade(worldIn, pos);
    }

    public void onBlockExploded(BlockState state, World world, BlockPos blockPos, Explosion explosion) {
        CableHelpers.onCableRemoving(world, blockPos, true, false);
        Collection<Direction> connectedCables = CableHelpers.getExternallyConnectedCables(world, blockPos);
        super.onBlockExploded(state, world, blockPos, explosion);
        CableHelpers.onCableRemoved(world, blockPos, connectedCables);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        BlockRayTraceResultComponent rayTraceResult = this.getSelectedShape(state, (IBlockReader)world, pos, ISelectionContext.func_216374_a((Entity)player)).rayTrace(pos, (Entity)player);
        if (rayTraceResult != null && rayTraceResult.getComponent().destroy(world, pos, player, false)) {
            return false;
        }
        return rayTraceResult != null && super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ActionResultType actionResultType;
        BlockRayTraceResultComponent rayTraceResult;
        TileMultipartTicking tile = TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)pos, TileMultipartTicking.class).orElse(null);
        if (tile != null && (rayTraceResult = this.getSelectedShape(state, (IBlockReader)world, pos, ISelectionContext.func_216374_a((Entity)player)).rayTrace(pos, (Entity)player)) != null && (actionResultType = rayTraceResult.getComponent().onBlockActivated(state, world, pos, player, hand, rayTraceResult)).func_226246_a_()) {
            return actionResultType;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, world, pos, oldState, isMoving);
        if (!world.func_201670_d()) {
            CableHelpers.onCableAdded(world, pos);
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        super.func_180633_a(world, pos, state, placer, itemStack);
        if (!world.func_201670_d()) {
            CableHelpers.onCableAddedByPlayer(world, pos, placer);
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos blockPos, PlayerEntity player) {
        BlockRayTraceResultComponent rayTraceResult = this.getSelectedShape(state, world, blockPos, ISelectionContext.func_216374_a((Entity)player)).rayTrace(blockPos, (Entity)player);
        if (rayTraceResult != null) {
            return rayTraceResult.getComponent().getPickBlock((World)world, blockPos);
        }
        return this.func_185473_a(world, blockPos, state);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, world, pos, neighborBlock, fromPos, isMoving);
        NetworkHelpers.onElementProviderBlockNeighborChange(world, pos, neighborBlock, null, fromPos);
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
        if (world instanceof World) {
            NetworkHelpers.onElementProviderBlockNeighborChange((World)world, pos, world.func_180495_p(neighbor).func_177230_c(), null, neighbor);
        }
    }

    public void observedNeighborChange(BlockState observerState, World world, BlockPos observerPos, Block changedBlock, BlockPos changedBlockPos) {
        super.observedNeighborChange(observerState, world, observerPos, changedBlock, changedBlockPos);
        NetworkHelpers.onElementProviderBlockNeighborChange(world, observerPos, changedBlock, null, changedBlockPos);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        super.func_225534_a_(state, world, pos, rand);
        TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)pos, TileMultipartTicking.class).ifPresent(tile -> {
            for (Map.Entry entry : tile.getPartContainer().getPartData().entrySet()) {
                this.updateTickPart(((PartHelpers.PartStateHolder)entry.getValue()).getPart(), (World)world, pos, (IPartState)((PartHelpers.PartStateHolder)entry.getValue()).getState(), rand);
            }
        });
    }

    protected void updateTickPart(IPartType partType, World world, BlockPos pos, IPartState partState, Random random) {
        partType.updateTick(world, pos, partState, random);
    }

    public AxisAlignedBB getCableBoundingBox(Direction side) {
        if (side == null) {
            return CABLE_CENTER_BOUNDINGBOX;
        }
        return (AxisAlignedBB)CABLE_SIDE_BOUNDINGBOXES.get((Object)side);
    }

    public VoxelShapeComponents getSelectedShape(BlockState blockState, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return this.voxelShapeComponentsFactory.createShape(blockState, world, pos, selectionContext);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        VoxelShapeComponents selectedShape = this.getSelectedShape(state, world, pos, selectionContext);
        BlockRayTraceResultComponent rayTraceResult = selectedShape.rayTrace(pos, selectionContext.getEntity());
        if (rayTraceResult != null) {
            return rayTraceResult.getComponent().getShape(state, world, pos, selectionContext);
        }
        return this.getSelectedShape(state, world, pos, selectionContext);
    }

    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        if (this.disableCollisionBox) {
            return VoxelShapes.func_197880_a();
        }
        return super.func_220071_b(p_220071_1_, p_220071_2_, p_220071_3_, p_220071_4_);
    }

    public int func_200011_d(BlockState blockState, IBlockReader world, BlockPos pos) {
        return CableHelpers.hasFacade(world, pos) && !CableHelpers.isLightTransparent(world, pos, null) ? 255 : 0;
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState blockState, World world, RayTraceResult target, ParticleManager particleManager) {
        BlockPos blockPos = ((BlockRayTraceResult)target).func_216350_a();
        if (CableHelpers.hasFacade((IBlockReader)world, blockPos)) {
            CableHelpers.getFacade((IBlockReader)world, blockPos).ifPresent(facadeState -> RenderHelpers.addBlockHitEffects((ParticleManager)particleManager, (ClientWorld)((ClientWorld)world), (BlockState)facadeState, (BlockPos)blockPos, (Direction)((BlockRayTraceResult)target).func_216354_b()));
            return true;
        }
        return super.addHitEffects(blockState, world, target, particleManager);
    }

    public boolean func_149744_f(BlockState blockState) {
        return true;
    }

    public boolean canConnectRedstone(BlockState blockState, IBlockReader world, BlockPos pos, Direction side) {
        if (side == null) {
            for (Direction dummySide : Direction.values()) {
                IDynamicRedstone dynamicRedstone = (IDynamicRedstone)TileHelpers.getCapability((IBlockReader)world, (BlockPos)pos, (Direction)dummySide, DynamicRedstoneConfig.CAPABILITY).orElse(null);
                if (dynamicRedstone == null || dynamicRedstone.getRedstoneLevel() < 0 && !dynamicRedstone.isAllowRedstoneInput()) continue;
                return true;
            }
            return false;
        }
        IDynamicRedstone dynamicRedstone = (IDynamicRedstone)TileHelpers.getCapability((IBlockReader)world, (BlockPos)pos, (Direction)side.func_176734_d(), DynamicRedstoneConfig.CAPABILITY).orElse(null);
        return dynamicRedstone != null && (dynamicRedstone.getRedstoneLevel() >= 0 || dynamicRedstone.isAllowRedstoneInput());
    }

    public int func_176211_b(BlockState blockState, IBlockReader world, BlockPos pos, Direction side) {
        IDynamicRedstone dynamicRedstone = (IDynamicRedstone)TileHelpers.getCapability((IBlockReader)world, (BlockPos)pos, (Direction)side.func_176734_d(), DynamicRedstoneConfig.CAPABILITY).orElse(null);
        return dynamicRedstone != null && dynamicRedstone.isStrong() ? dynamicRedstone.getRedstoneLevel() : 0;
    }

    public int func_180656_a(BlockState blockState, IBlockReader world, BlockPos pos, Direction side) {
        IDynamicRedstone dynamicRedstone = (IDynamicRedstone)TileHelpers.getCapability((IBlockReader)world, (BlockPos)pos, (Direction)side.func_176734_d(), DynamicRedstoneConfig.CAPABILITY).orElse(null);
        return dynamicRedstone != null ? dynamicRedstone.getRedstoneLevel() : 0;
    }

    public int getLightValue(BlockState blockState, IBlockReader world, BlockPos pos) {
        int light = 0;
        for (Direction side : Direction.values()) {
            IDynamicLight dynamicLight = (IDynamicLight)TileHelpers.getCapability((IBlockReader)world, (BlockPos)pos, (Direction)side, DynamicLightConfig.CAPABILITY).orElse(null);
            if (dynamicLight == null) continue;
            light = Math.max(light, dynamicLight.getLightLevel());
        }
        return light;
    }

    public boolean hasDynamicModel() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IBakedModel createDynamicModel(ModelBakeEvent event) {
        CableModel model = new CableModel();
        event.getModelRegistry().put(new ModelResourceLocation(this.getRegistryName(), "waterlogged=false"), model);
        event.getModelRegistry().put(new ModelResourceLocation(this.getRegistryName(), "waterlogged=true"), model);
        event.getModelRegistry().put(new ModelResourceLocation(this.getRegistryName(), "inventory"), model);
        return model;
    }

    public void setDisableCollisionBox(boolean disableCollisionBox) {
        this.disableCollisionBox = disableCollisionBox;
    }

    static {
        for (Direction side : Direction.values()) {
            BlockCable.CONNECTED[side.ordinal()] = new ModelProperty();
            BlockCable.PART_RENDERPOSITIONS[side.ordinal()] = new ModelProperty();
        }
        PARTCONTAINER = new ModelProperty();
        RENDERSTATE = new ModelProperty();
        CABLE_CENTER_BOUNDINGBOX = new AxisAlignedBB(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);
        CABLE_SIDE_BOUNDINGBOXES = EnumFacingMap.forAllValues((Object)new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625), (Object)new AxisAlignedBB(0.375, 0.625, 0.375, 0.625, 1.0, 0.625), (Object)new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 0.375), (Object)new AxisAlignedBB(0.375, 0.625, 0.625, 0.625, 0.375, 1.0), (Object)new AxisAlignedBB(0.0, 0.375, 0.375, 0.375, 0.625, 0.625), (Object)new AxisAlignedBB(0.625, 0.375, 0.375, 1.0, 0.625, 0.625));
    }
}

