/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NBTTypes;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.state.Property;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.nbt.path.INbtPathExpression;
import org.cyclops.cyclopscore.nbt.path.NbtParseException;
import org.cyclops.cyclopscore.nbt.path.NbtPath;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorRegistry;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNumber;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.IOperatorValuePropagator;
import org.cyclops.integrateddynamics.core.evaluate.OperatorBuilders;
import org.cyclops.integrateddynamics.core.evaluate.operator.CombinedOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.CompositionalOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.CurriedOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.GeneralChoiceOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.GeneralConstantOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.GeneralIdentityOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.GeneralOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.IterativeFunction;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorRegistry;
import org.cyclops.integrateddynamics.core.evaluate.operator.ParseOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBlock;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeEntity;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyAppend;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyConcat;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyEntityArmorInventory;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyEntityFluids;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyEntityInventory;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyEntityItems;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyLazyBuilt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNbtAsListByte;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNbtAsListInt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNbtAsListLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNbtAsListTag;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNbtKeys;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNbtValueListByte;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNbtValueListInt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNbtValueListLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNbtValueListTag;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyOperatorMapped;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxySlice;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyTail;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.helper.NbtHelpers;
import org.cyclops.integrateddynamics.core.ingredient.ExtendedIngredientsList;
import org.cyclops.integrateddynamics.core.ingredient.ExtendedIngredientsSingle;
import vendors.com.google.re2j.Pattern;
import vendors.com.google.re2j.PatternSyntaxException;

public final class Operators {
    public static final IOperatorRegistry REGISTRY = Operators.constructRegistry();
    public static final IOperator LOGICAL_AND = REGISTRY.register(OperatorBuilders.LOGICAL_2.symbol("&&").operatorName("and").function(variables -> {
        ValueTypeBoolean.ValueBoolean a = variables.getValue(0, ValueTypes.BOOLEAN);
        if (!a.getRawValue()) {
            return ValueTypeBoolean.ValueBoolean.of(false);
        }
        return variables.getValue(1, ValueTypes.BOOLEAN);
    }).build());
    public static final IOperator LOGICAL_OR = REGISTRY.register(OperatorBuilders.LOGICAL_2.symbol("||").operatorName("or").function(variables -> {
        ValueTypeBoolean.ValueBoolean a = variables.getValue(0, ValueTypes.BOOLEAN);
        if (a.getRawValue()) {
            return ValueTypeBoolean.ValueBoolean.of(true);
        }
        return variables.getValue(1, ValueTypes.BOOLEAN);
    }).build());
    public static final IOperator LOGICAL_NOT = REGISTRY.register(OperatorBuilders.LOGICAL_1_PREFIX.symbol("!").operatorName("not").function(variables -> {
        ValueTypeBoolean.ValueBoolean valueBoolean = variables.getValue(0, ValueTypes.BOOLEAN);
        return ValueTypeBoolean.ValueBoolean.of(!valueBoolean.getRawValue());
    }).build());
    public static final IOperator LOGICAL_NAND = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_NOT).apply(LOGICAL_AND).build("!&&", "nand", IConfigRenderPattern.INFIX, "logical"));
    public static final IOperator LOGICAL_NOR = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_NOT).apply(LOGICAL_OR).build("!||", "nor", IConfigRenderPattern.INFIX, "logical"));
    public static final IOperator ARITHMETIC_ADDITION = REGISTRY.register(OperatorBuilders.ARITHMETIC_2.symbol("+").operatorName("addition").function(variables -> ValueTypes.CATEGORY_NUMBER.add(variables.getVariables()[0], variables.getVariables()[1])).build());
    public static final IOperator ARITHMETIC_SUBTRACTION = REGISTRY.register(OperatorBuilders.ARITHMETIC_2.symbol("-").operatorName("subtraction").function(variables -> ValueTypes.CATEGORY_NUMBER.subtract(variables.getVariables()[0], variables.getVariables()[1])).build());
    public static final IOperator ARITHMETIC_MULTIPLICATION = REGISTRY.register(OperatorBuilders.ARITHMETIC_2.symbol("*").operatorName("multiplication").function(variables -> ValueTypes.CATEGORY_NUMBER.multiply(variables.getVariables()[0], variables.getVariables()[1])).build());
    public static final IOperator ARITHMETIC_DIVISION = REGISTRY.register(OperatorBuilders.ARITHMETIC_2.symbol("/").operatorName("division").function(variables -> ValueTypes.CATEGORY_NUMBER.divide(variables.getVariables()[0], variables.getVariables()[1])).build());
    public static final IOperator ARITHMETIC_MAXIMUM = REGISTRY.register(OperatorBuilders.ARITHMETIC_2_PREFIX.symbol("max").operatorName("maximum").function(variables -> ValueTypes.CATEGORY_NUMBER.max(variables.getVariables()[0], variables.getVariables()[1])).build());
    public static final IOperator ARITHMETIC_MINIMUM = REGISTRY.register(OperatorBuilders.ARITHMETIC_2_PREFIX.symbol("min").operatorName("minimum").function(variables -> ValueTypes.CATEGORY_NUMBER.min(variables.getVariables()[0], variables.getVariables()[1])).build());
    private static final ValueTypeInteger.ValueInteger ZERO = ValueTypeInteger.ValueInteger.of(0);
    public static final IOperator INTEGER_MODULUS = REGISTRY.register(OperatorBuilders.INTEGER_2.symbol("%").operatorName("modulus").function(variables -> {
        ValueTypeInteger.ValueInteger b = variables.getValue(1, ValueTypes.INTEGER);
        if (b.getRawValue() == 0) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.divide_by_zero"));
        }
        if (b.getRawValue() == 1) {
            return ZERO;
        }
        ValueTypeInteger.ValueInteger a = variables.getValue(0, ValueTypes.INTEGER);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue() % b.getRawValue());
    }).build());
    public static final IOperator INTEGER_INCREMENT = REGISTRY.register(OperatorBuilders.INTEGER_1_SUFFIX.symbol("++").operatorName("increment").function(variables -> {
        ValueTypeInteger.ValueInteger a = variables.getValue(0, ValueTypes.INTEGER);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue() + 1);
    }).build());
    public static final IOperator INTEGER_DECREMENT = REGISTRY.register(OperatorBuilders.INTEGER_1_SUFFIX.symbol("--").operatorName("decrement").function(variables -> {
        ValueTypeInteger.ValueInteger a = variables.getValue(0, ValueTypes.INTEGER);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue() - 1);
    }).build());
    public static final IOperator RELATIONAL_EQUALS = REGISTRY.register(OperatorBuilders.RELATIONAL.inputTypes(2, (IValueType)ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.INFIX).symbol("==").operatorName("equals").function(variables -> ValueTypeBoolean.ValueBoolean.of(variables.getValue(0).equals(variables.getValue(1)))).typeValidator((operator, input) -> {
        int requiredInputLength = operator.getRequiredInputLength();
        if (input.length != requiredInputLength) {
            return new TranslationTextComponent("operator.integrateddynamics.error.wrong_input_length", new Object[]{operator.getOperatorName(), input.length, requiredInputLength});
        }
        IValueType temporarySecondInputType = null;
        for (int i = 0; i < requiredInputLength; ++i) {
            IValueType inputType = input[i];
            if (inputType instanceof IValueTypeNumber) {
                inputType = ValueTypes.CATEGORY_NUMBER;
            }
            if (inputType == null) {
                return new TranslationTextComponent("operator.integrateddynamics.error.null_type", new Object[]{operator.getOperatorName(), Integer.toString(i)});
            }
            if (i == 0) {
                temporarySecondInputType = inputType;
                continue;
            }
            if (i != 1 || ValueHelpers.correspondsTo(temporarySecondInputType, inputType)) continue;
            return new TranslationTextComponent("operator.integrateddynamics.error.wrong_type", new Object[]{operator.getOperatorName(), new TranslationTextComponent(inputType.getTranslationKey()), Integer.toString(i), new TranslationTextComponent(temporarySecondInputType.getTranslationKey())});
        }
        return null;
    }).build());
    public static final IOperator RELATIONAL_GT = REGISTRY.register(OperatorBuilders.RELATIONAL_2.inputTypes(2, (IValueType)ValueTypes.CATEGORY_NUMBER).symbol(">").operatorName("gt").function(variables -> ValueTypeBoolean.ValueBoolean.of(ValueTypes.CATEGORY_NUMBER.greaterThan(variables.getVariables()[0], variables.getVariables()[1]))).build());
    public static final IOperator RELATIONAL_LT = REGISTRY.register(OperatorBuilders.RELATIONAL_2.inputTypes(2, (IValueType)ValueTypes.CATEGORY_NUMBER).symbol("<").operatorName("lt").function(variables -> ValueTypeBoolean.ValueBoolean.of(ValueTypes.CATEGORY_NUMBER.lessThan(variables.getVariables()[0], variables.getVariables()[1]))).build());
    public static final IOperator RELATIONAL_NOTEQUALS = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_NOT).apply(RELATIONAL_EQUALS).build("!=", "notequals", IConfigRenderPattern.INFIX, "relational"));
    public static final IOperator RELATIONAL_GE = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_OR).apply(RELATIONAL_EQUALS, RELATIONAL_GT).build(">=", "ge", IConfigRenderPattern.INFIX, "relational"));
    public static final IOperator RELATIONAL_LE = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_OR).apply(RELATIONAL_EQUALS, RELATIONAL_LT).build("<=", "le", IConfigRenderPattern.INFIX, "relational"));
    public static final IOperator BINARY_AND = REGISTRY.register(OperatorBuilders.BINARY_2.symbol("&").operatorName("and").function(variables -> {
        ValueTypeInteger.ValueInteger a = variables.getValue(0, ValueTypes.INTEGER);
        ValueTypeInteger.ValueInteger b = variables.getValue(1, ValueTypes.INTEGER);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue() & b.getRawValue());
    }).build());
    public static final IOperator BINARY_OR = REGISTRY.register(OperatorBuilders.BINARY_2.symbol("|").operatorName("or").function(variables -> {
        ValueTypeInteger.ValueInteger a = variables.getValue(0, ValueTypes.INTEGER);
        ValueTypeInteger.ValueInteger b = variables.getValue(1, ValueTypes.INTEGER);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue() | b.getRawValue());
    }).build());
    public static final IOperator BINARY_XOR = REGISTRY.register(OperatorBuilders.BINARY_2.symbol("^").operatorName("xor").function(variables -> {
        ValueTypeInteger.ValueInteger a = variables.getValue(0, ValueTypes.INTEGER);
        ValueTypeInteger.ValueInteger b = variables.getValue(1, ValueTypes.INTEGER);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue() ^ b.getRawValue());
    }).build());
    public static final IOperator BINARY_COMPLEMENT = REGISTRY.register(OperatorBuilders.BINARY_1_PREFIX.symbol("~").operatorName("complement").function(variables -> {
        ValueTypeInteger.ValueInteger a = variables.getValue(0, ValueTypes.INTEGER);
        return ValueTypeInteger.ValueInteger.of(~a.getRawValue());
    }).build());
    public static final IOperator BINARY_LSHIFT = REGISTRY.register(OperatorBuilders.BINARY_2.symbol("<<").operatorName("lshift").function(variables -> {
        ValueTypeInteger.ValueInteger a = variables.getValue(0, ValueTypes.INTEGER);
        ValueTypeInteger.ValueInteger b = variables.getValue(1, ValueTypes.INTEGER);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue() << b.getRawValue());
    }).build());
    public static final IOperator BINARY_RSHIFT = REGISTRY.register(OperatorBuilders.BINARY_2.symbol(">>").operatorName("rshift").function(variables -> {
        ValueTypeInteger.ValueInteger a = variables.getValue(0, ValueTypes.INTEGER);
        ValueTypeInteger.ValueInteger b = variables.getValue(1, ValueTypes.INTEGER);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue() >> b.getRawValue());
    }).build());
    public static final IOperator BINARY_RZSHIFT = REGISTRY.register(OperatorBuilders.BINARY_2.symbol(">>>").operatorName("rzshift").function(variables -> {
        ValueTypeInteger.ValueInteger a = variables.getValue(0, ValueTypes.INTEGER);
        ValueTypeInteger.ValueInteger b = variables.getValue(1, ValueTypes.INTEGER);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue() >>> b.getRawValue());
    }).build());
    public static final IOperator STRING_LENGTH = REGISTRY.register(OperatorBuilders.STRING_1_PREFIX.symbol("len").operatorName("length").output(ValueTypes.INTEGER).function(variables -> {
        ValueTypeString.ValueString a = variables.getValue(0, ValueTypes.STRING);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue().length());
    }).build());
    public static final IOperator STRING_CONCAT = REGISTRY.register(OperatorBuilders.STRING_2.symbol("+").operatorName("concat").function(variables -> {
        ValueTypeString.ValueString a = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString b = variables.getValue(1, ValueTypes.STRING);
        return ValueTypeString.ValueString.of(a.getRawValue() + b.getRawValue());
    }).build());
    public static final IOperator STRING_CONTAINS = REGISTRY.register(OperatorBuilders.STRING_2.symbolOperator("contains").output(ValueTypes.BOOLEAN).function(variables -> {
        ValueTypeString.ValueString search = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(1, ValueTypes.STRING);
        return ValueTypeBoolean.ValueBoolean.of(str.getRawValue().contains(search.getRawValue()));
    }).build());
    public static final IOperator STRING_CONTAINS_REGEX = REGISTRY.register(OperatorBuilders.STRING_2_LONG.symbolOperator("contains_regex").output(ValueTypes.BOOLEAN).function(variables -> {
        ValueTypeString.ValueString pattern = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(1, ValueTypes.STRING);
        try {
            vendors.com.google.re2j.Matcher m = Pattern.compile(pattern.getRawValue()).matcher(str.getRawValue());
            return ValueTypeBoolean.ValueBoolean.of(m.find());
        }
        catch (PatternSyntaxException e) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.regex.invalid", new Object[]{pattern.getRawValue()}));
        }
    }).build());
    public static final IOperator STRING_MATCHES_REGEX = REGISTRY.register(OperatorBuilders.STRING_2_LONG.symbolOperator("matches_regex").output(ValueTypes.BOOLEAN).function(variables -> {
        ValueTypeString.ValueString pattern = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(1, ValueTypes.STRING);
        try {
            vendors.com.google.re2j.Matcher m = Pattern.compile(pattern.getRawValue()).matcher(str.getRawValue());
            return ValueTypeBoolean.ValueBoolean.of(m.matches());
        }
        catch (PatternSyntaxException e) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.regex.invalid", new Object[]{pattern.getRawValue()}));
        }
    }).build());
    public static final IOperator STRING_INDEX_OF = REGISTRY.register(OperatorBuilders.STRING_2_LONG.symbolOperator("index_of").output(ValueTypes.INTEGER).function(variables -> {
        ValueTypeString.ValueString search = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(1, ValueTypes.STRING);
        return ValueTypeInteger.ValueInteger.of(str.getRawValue().indexOf(search.getRawValue()));
    }).build());
    public static final IOperator STRING_INDEX_OF_REGEX = REGISTRY.register(OperatorBuilders.STRING_2_LONG.symbolOperator("index_of_regex").output(ValueTypes.INTEGER).function(variables -> {
        ValueTypeString.ValueString pattern = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(1, ValueTypes.STRING);
        try {
            vendors.com.google.re2j.Matcher m = Pattern.compile(pattern.getRawValue()).matcher(str.getRawValue());
            if (m.find()) {
                return ValueTypeInteger.ValueInteger.of(m.start());
            }
            return ValueTypeInteger.ValueInteger.of(-1);
        }
        catch (PatternSyntaxException e) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.regex.invalid", new Object[]{pattern.getRawValue()}));
        }
    }).build());
    public static final IOperator STRING_STARTS_WITH = REGISTRY.register(OperatorBuilders.STRING_2.symbolOperator("starts_with").output(ValueTypes.BOOLEAN).function(variables -> {
        ValueTypeString.ValueString search = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(1, ValueTypes.STRING);
        return ValueTypeBoolean.ValueBoolean.of(str.getRawValue().startsWith(search.getRawValue()));
    }).build());
    public static final IOperator STRING_ENDS_WITH = REGISTRY.register(OperatorBuilders.STRING_2.symbolOperator("ends_with").output(ValueTypes.BOOLEAN).function(variables -> {
        ValueTypeString.ValueString search = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(1, ValueTypes.STRING);
        return ValueTypeBoolean.ValueBoolean.of(str.getRawValue().endsWith(search.getRawValue()));
    }).build());
    public static final IOperator STRING_SPLIT_ON = REGISTRY.register(OperatorBuilders.STRING_2.symbolOperator("split_on").output(ValueTypes.LIST).function(variables -> {
        ValueTypeString.ValueString search = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(1, ValueTypes.STRING);
        List<String> pieces = Arrays.asList(str.getRawValue().split(java.util.regex.Pattern.quote(search.getRawValue())));
        ArrayList values = Lists.newArrayList();
        for (String piece : pieces) {
            values.add(ValueTypeString.ValueString.of(piece));
        }
        return ValueTypeList.ValueList.ofList(ValueTypes.STRING, values);
    }).build());
    public static final IOperator STRING_SPLIT_ON_REGEX = REGISTRY.register(OperatorBuilders.STRING_2_LONG.symbolOperator("split_on_regex").output(ValueTypes.LIST).function(variables -> {
        ValueTypeString.ValueString pattern = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(1, ValueTypes.STRING);
        try {
            List<String> pieces = Arrays.asList(Pattern.compile(pattern.getRawValue()).split(str.getRawValue()));
            ArrayList values = Lists.newArrayList();
            for (String piece : pieces) {
                values.add(ValueTypeString.ValueString.of(piece));
            }
            return ValueTypeList.ValueList.ofList(ValueTypes.STRING, values);
        }
        catch (PatternSyntaxException e) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.regex.invalid", new Object[]{pattern.getRawValue()}));
        }
    }).build());
    public static final IOperator STRING_SUBSTRING = REGISTRY.register(OperatorBuilders.STRING.symbolOperator("substring").renderPattern(IConfigRenderPattern.PREFIX_3_LONG).inputTypes(ValueTypes.INTEGER, ValueTypes.INTEGER, ValueTypes.STRING).output(ValueTypes.STRING).function(variables -> {
        ValueTypeInteger.ValueInteger from = variables.getValue(0, ValueTypes.INTEGER);
        ValueTypeInteger.ValueInteger to = variables.getValue(1, ValueTypes.INTEGER);
        ValueTypeString.ValueString str = variables.getValue(2, ValueTypes.STRING);
        if (from.getRawValue() > to.getRawValue()) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.substring.to_greater_than_from"));
        }
        if (from.getRawValue() < 0 || to.getRawValue() < 0) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.substring.index_negative"));
        }
        int stringLength = str.getRawValue().length();
        if (from.getRawValue() > stringLength || to.getRawValue() > stringLength) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.substring.longer_than_string"));
        }
        return ValueTypeString.ValueString.of(str.getRawValue().substring(from.getRawValue(), to.getRawValue()));
    }).build());
    public static final IOperator STRING_REGEX_GROUP = REGISTRY.register(OperatorBuilders.STRING.symbolOperator("regex_group").renderPattern(IConfigRenderPattern.PREFIX_3_LONG).inputTypes(ValueTypes.STRING, ValueTypes.INTEGER, ValueTypes.STRING).output(ValueTypes.STRING).function(variables -> {
        ValueTypeString.ValueString pattern = variables.getValue(0, ValueTypes.STRING);
        ValueTypeInteger.ValueInteger group = variables.getValue(1, ValueTypes.INTEGER);
        ValueTypeString.ValueString str = variables.getValue(2, ValueTypes.STRING);
        if (group.getRawValue() < 0) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.group.index_negative"));
        }
        try {
            vendors.com.google.re2j.Matcher m = Pattern.compile(pattern.getRawValue()).matcher(str.getRawValue());
            if (m.find()) {
                String result = m.group(group.getRawValue());
                return ValueTypeString.ValueString.of(result);
            }
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.group.no_match", new Object[]{str.getRawValue(), pattern.getRawValue()}));
        }
        catch (PatternSyntaxException e) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.regex.invalid", new Object[]{pattern.getRawValue()}));
        }
        catch (IndexOutOfBoundsException e) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.group.no_match_group", new Object[]{str.getRawValue(), pattern.getRawValue(), group.getRawValue()}));
        }
    }).build());
    public static final IOperator STRING_REGEX_GROUPS = REGISTRY.register(OperatorBuilders.STRING_2_LONG.symbolOperator("regex_groups").output(ValueTypes.LIST).function(variables -> {
        ValueTypeString.ValueString pattern = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(1, ValueTypes.STRING);
        try {
            vendors.com.google.re2j.Matcher m = Pattern.compile(pattern.getRawValue()).matcher(str.getRawValue());
            if (m.find()) {
                ArrayList values = Lists.newArrayList();
                for (int i = 0; i <= m.groupCount(); ++i) {
                    values.add(ValueTypeString.ValueString.of(m.group(i)));
                }
                return ValueTypeList.ValueList.ofList(ValueTypes.STRING, values);
            }
            return ValueTypeList.ValueList.ofList(ValueTypes.STRING, Collections.emptyList());
        }
        catch (PatternSyntaxException e) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.regex.invalid", new Object[]{pattern.getRawValue()}));
        }
    }).build());
    public static final IOperator STRING_REGEX_SCAN = REGISTRY.register(OperatorBuilders.STRING.symbolOperator("regex_scan").renderPattern(IConfigRenderPattern.PREFIX_3_LONG).inputTypes(ValueTypes.STRING, ValueTypes.INTEGER, ValueTypes.STRING).output(ValueTypes.LIST).function(variables -> {
        ValueTypeString.ValueString pattern = variables.getValue(0, ValueTypes.STRING);
        ValueTypeInteger.ValueInteger group = variables.getValue(1, ValueTypes.INTEGER);
        ValueTypeString.ValueString str = variables.getValue(2, ValueTypes.STRING);
        if (group.getRawValue() < 0) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.regex_scan.index_negative"));
        }
        try {
            vendors.com.google.re2j.Matcher m = Pattern.compile(pattern.getRawValue()).matcher(str.getRawValue());
            ArrayList values = Lists.newArrayList();
            while (m.find()) {
                values.add(ValueTypeString.ValueString.of(m.group(group.getRawValue())));
            }
            return ValueTypeList.ValueList.ofList(ValueTypes.STRING, values);
        }
        catch (PatternSyntaxException e) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.regex.invalid", new Object[]{pattern.getRawValue()}));
        }
        catch (IndexOutOfBoundsException e) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.regex_scan.no_match_group", new Object[]{str.getRawValue(), pattern.getRawValue(), group.getRawValue()}));
        }
    }).build());
    public static final IOperator STRING_REPLACE = REGISTRY.register(OperatorBuilders.STRING.symbolOperator("replace").renderPattern(IConfigRenderPattern.PREFIX_3_LONG).inputTypes(3, (IValueType)ValueTypes.STRING).output(ValueTypes.STRING).function(variables -> {
        ValueTypeString.ValueString search = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString replacement = variables.getValue(1, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(2, ValueTypes.STRING);
        return ValueTypeString.ValueString.of(str.getRawValue().replaceAll(java.util.regex.Pattern.quote(search.getRawValue()), Matcher.quoteReplacement(replacement.getRawValue())));
    }).build());
    public static final IOperator STRING_REPLACE_REGEX = REGISTRY.register(OperatorBuilders.STRING.symbolOperator("replace_regex").renderPattern(IConfigRenderPattern.PREFIX_3_LONG).inputTypes(3, (IValueType)ValueTypes.STRING).output(ValueTypes.STRING).function(variables -> {
        ValueTypeString.ValueString pattern = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString replacement = variables.getValue(1, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(2, ValueTypes.STRING);
        try {
            return ValueTypeString.ValueString.of(Pattern.compile(pattern.getRawValue()).matcher(str.getRawValue()).replaceAll(replacement.getRawValue()));
        }
        catch (PatternSyntaxException e) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.regex.invalid", new Object[]{pattern.getRawValue()}));
        }
    }).build());
    public static final IOperator STRING_JOIN = REGISTRY.register(OperatorBuilders.STRING.symbolOperator("join").renderPattern(IConfigRenderPattern.PREFIX_2).inputTypes(ValueTypes.STRING, ValueTypes.LIST).output(ValueTypes.STRING).function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeString.ValueString delimiter = variables.getValue(0, ValueTypes.STRING);
            ValueTypeList.ValueList elements = variables.getValue(1, ValueTypes.LIST);
            if (!ValueHelpers.correspondsTo(elements.getRawValue().getValueType(), ValueTypes.STRING)) {
                throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("valuetype.integrateddynamics.error.invalid_list_value_type", new Object[]{new TranslationTextComponent(elements.getRawValue().getValueType().getTranslationKey()), ValueTypes.STRING}));
            }
            if (elements.getRawValue().isInfinite()) {
                throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.infinite_list.illegal", new Object[]{STRING_JOIN.getLocalizedNameFull()}));
            }
            StringBuilder sb = new StringBuilder();
            for (IValue value : elements.getRawValue()) {
                if (value.getType() != ValueTypes.STRING) {
                    throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("valuetype.integrateddynamics.error.invalid_list_value_type", new Object[]{new TranslationTextComponent(value.getType().getTranslationKey()), ValueTypes.STRING}));
                }
                if (sb.length() > 0) {
                    sb.append(delimiter.getRawValue());
                }
                sb.append(((ValueTypeString.ValueString)value).getRawValue());
            }
            return ValueTypeString.ValueString.of(sb.toString());
        }
    }).build());
    public static final IOperator NAMED_NAME = REGISTRY.register(OperatorBuilders.STRING_2.symbol("name").operatorName("name").inputType(ValueTypes.CATEGORY_NAMED).renderPattern(IConfigRenderPattern.SUFFIX_1_LONG).function(variables -> ValueTypeString.ValueString.of(ValueTypes.CATEGORY_NAMED.getName(variables.getVariables()[0]))).build());
    public static final IOperator UNIQUELYNAMED_UNIQUENAME = REGISTRY.register(OperatorBuilders.STRING_2.symbol("uname").operatorName("unique_name").inputType(ValueTypes.CATEGORY_UNIQUELY_NAMED).renderPattern(IConfigRenderPattern.SUFFIX_1_LONG).function(variables -> ValueTypeString.ValueString.of(ValueTypes.CATEGORY_UNIQUELY_NAMED.getUniqueName(variables.getVariables()[0]))).build());
    public static final IOperator NUMBER_ROUND = REGISTRY.register(OperatorBuilders.NUMBER_1_PREFIX.inputType(ValueTypes.CATEGORY_NUMBER).output(ValueTypes.INTEGER).symbol("|| ||").operatorName("round").function(variables -> ValueTypes.CATEGORY_NUMBER.round(variables.getVariables()[0])).build());
    public static final IOperator NUMBER_CEIL = REGISTRY.register(OperatorBuilders.DOUBLE_1_PREFIX.inputType(ValueTypes.CATEGORY_NUMBER).output(ValueTypes.INTEGER).symbol("\u2308 \u2309").operatorName("ceil").function(variables -> ValueTypes.CATEGORY_NUMBER.ceil(variables.getVariables()[0])).build());
    public static final IOperator NUMBER_FLOOR = REGISTRY.register(OperatorBuilders.DOUBLE_1_PREFIX.inputType(ValueTypes.CATEGORY_NUMBER).output(ValueTypes.INTEGER).symbol("\u230a \u230b").operatorName("floor").function(variables -> ValueTypes.CATEGORY_NUMBER.floor(variables.getVariables()[0])).build());
    public static final IOperator NULLABLE_ISNULL = REGISTRY.register(OperatorBuilders.NULLABLE_1_PREFIX.symbol("o").operatorName("isnull").inputType(ValueTypes.CATEGORY_ANY).output(ValueTypes.BOOLEAN).function(variables -> {
        if (ValueHelpers.correspondsTo(variables.getVariables()[0].getType(), ValueTypes.CATEGORY_NULLABLE)) {
            return ValueTypeBoolean.ValueBoolean.of(ValueTypes.CATEGORY_NULLABLE.isNull(variables.getVariables()[0]));
        }
        return ValueTypeBoolean.ValueBoolean.of(false);
    }).build());
    public static final IOperator NULLABLE_ISNOTNULL = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_NOT).apply(NULLABLE_ISNULL).build("\u2205", "isnotnull", IConfigRenderPattern.PREFIX_1, "general"));
    public static final IOperator LIST_LENGTH = REGISTRY.register(OperatorBuilders.LIST_1_PREFIX.output(ValueTypes.INTEGER).symbol("| |").operatorName("length").function(variables -> {
        ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy a = valueList.getRawValue();
        return ValueTypeInteger.ValueInteger.of(a.getLength());
    }).build());
    public static final IOperator LIST_EMPTY = REGISTRY.register(OperatorBuilders.LIST_1_PREFIX.output(ValueTypes.BOOLEAN).symbol("\u2205").operatorName("empty").function(variables -> {
        ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy a = valueList.getRawValue();
        return ValueTypeBoolean.ValueBoolean.of(a.getLength() == 0);
    }).build());
    public static final IOperator LIST_NOT_EMPTY = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_NOT).apply(LIST_EMPTY).build("o", "notempty", IConfigRenderPattern.PREFIX_1, "list"));
    public static final IOperator LIST_ELEMENT = REGISTRY.register(OperatorBuilders.LIST_1_PREFIX.inputTypes(ValueTypes.LIST, ValueTypes.INTEGER).output(ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.INFIX).symbolOperator("get").function(variables -> {
        ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy a = valueList.getRawValue();
        ValueTypeInteger.ValueInteger b = variables.getValue(1, ValueTypes.INTEGER);
        if (b.getRawValue() < a.getLength() && b.getRawValue() >= 0) {
            return a.get(b.getRawValue());
        }
        throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.index_out_of_bounds", new Object[]{b.getRawValue(), a.getLength()}));
    }).conditionalOutputTypeDeriver((operator, input) -> {
        try {
            IValueTypeListProxy a = ((ValueTypeList.ValueList)input[0].getValue()).getRawValue();
            return a.getValueType();
        }
        catch (ClassCastException | EvaluationException e) {
            return operator.getOutputType();
        }
    }).build());
    public static final IOperator LIST_ELEMENT_DEFAULT = REGISTRY.register(OperatorBuilders.LIST_1_PREFIX.inputTypes(ValueTypes.LIST, ValueTypes.INTEGER, ValueTypes.CATEGORY_ANY).output(ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.INFIX_2_LONG).symbolOperator("get_or_default").function(variables -> {
        ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy a = valueList.getRawValue();
        ValueTypeInteger.ValueInteger b = variables.getValue(1, ValueTypes.INTEGER);
        if (b.getRawValue() < a.getLength() && b.getRawValue() >= 0) {
            return a.get(b.getRawValue());
        }
        if (!ValueHelpers.correspondsTo(a.getValueType(), variables.getVariables()[2].getType())) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("valuetype.integrateddynamics.error.invalid_list_value_type", new Object[]{a.getValueType(), new TranslationTextComponent(variables.getVariables()[2].getType().getTranslationKey())}));
        }
        return variables.getValue(2);
    }).conditionalOutputTypeDeriver((operator, input) -> input[2].getType()).build());
    public static final IOperator LIST_CONTAINS = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.PREFIX_2_LONG).output(ValueTypes.BOOLEAN).symbolOperator("contains").function(variables -> {
        ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy list = valueList.getRawValue();
        IValue input = variables.getValue(1);
        for (IValue value : list) {
            if (!value.equals(input)) continue;
            return ValueTypeBoolean.ValueBoolean.of(true);
        }
        return ValueTypeBoolean.ValueBoolean.of(false);
    }).build());
    public static final IOperator LIST_CONTAINS_PREDICATE = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.OPERATOR).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.BOOLEAN).symbolOperator("contains_p").function(variables -> {
        ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy list = valueList.getRawValue();
        IOperator operator = OperatorBuilders.getSafePredictate(variables.getValue(1, ValueTypes.OPERATOR));
        for (IValue value : list) {
            IValue result = ValueHelpers.evaluateOperator(operator, value);
            ValueHelpers.validatePredicateOutput(operator, result);
            if (!((ValueTypeBoolean.ValueBoolean)result).getRawValue()) continue;
            return ValueTypeBoolean.ValueBoolean.of(true);
        }
        return ValueTypeBoolean.ValueBoolean.of(false);
    }).build());
    public static final IOperator LIST_COUNT = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.INTEGER).symbolOperator("count").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
            IValueTypeListProxy list = valueList.getRawValue();
            if (list.isInfinite()) {
                throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.infinite_list.illegal", new Object[]{LIST_COUNT.getLocalizedNameFull()}));
            }
            IValue value = variables.getValue(1);
            int count = 0;
            for (IValue listValue : list) {
                if (!listValue.equals(value)) continue;
                ++count;
            }
            return ValueTypeInteger.ValueInteger.of(count);
        }
    }).build());
    public static final IOperator LIST_COUNT_PREDICATE = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.OPERATOR).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.INTEGER).symbolOperator("count_p").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
            IValueTypeListProxy list = valueList.getRawValue();
            if (list.isInfinite()) {
                throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.infinite_list.illegal", new Object[]{LIST_COUNT_PREDICATE.getLocalizedNameFull()}));
            }
            IOperator operator = OperatorBuilders.getSafePredictate(variables.getValue(1, ValueTypes.OPERATOR));
            int count = 0;
            for (IValue listValue : list) {
                IValue result = ValueHelpers.evaluateOperator(operator, listValue);
                ValueHelpers.validatePredicateOutput(operator, result);
                if (!((ValueTypeBoolean.ValueBoolean)result).getRawValue()) continue;
                ++count;
            }
            return ValueTypeInteger.ValueInteger.of(count);
        }
    }).build());
    public static final IOperator LIST_APPEND = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.LIST).symbolOperator("append").function(variables -> {
        ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy a = valueList.getRawValue();
        IValue value = variables.getValue(1);
        if (!ValueHelpers.correspondsTo(a.getValueType(), value.getType())) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("valuetype.integrateddynamics.error.invalid_list_value_type", new Object[]{new TranslationTextComponent(a.getValueType().getTranslationKey()), new TranslationTextComponent(value.getType().getTranslationKey())}));
        }
        return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyAppend(a, value));
    }).build());
    public static final IOperator LIST_CONCAT = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.LIST).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.LIST).symbolOperator("concat").function(variables -> {
        ValueTypeList.ValueList valueList0 = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy a = valueList0.getRawValue();
        ValueTypeList.ValueList valueList1 = variables.getValue(1, ValueTypes.LIST);
        IValueTypeListProxy b = valueList1.getRawValue();
        if (!ValueHelpers.correspondsTo(a.getValueType(), b.getValueType())) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("valuetype.integrateddynamics.error.invalid_list_value_type", new Object[]{new TranslationTextComponent(a.getValueType().getTranslationKey()), new TranslationTextComponent(b.getValueType().getTranslationKey())}));
        }
        return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyConcat(a, b));
    }).build());
    public static final IOperator LIST_LAZYBUILT = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.CATEGORY_ANY, ValueTypes.OPERATOR).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.LIST).symbolOperator("lazybuilt").function(variables -> {
        IValue a = variables.getValue(0);
        IOperator operator = OperatorBuilders.getSafeOperator(variables.getValue(1, ValueTypes.OPERATOR), a.getType());
        return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyLazyBuilt(a, operator));
    }).build());
    public static final IOperator LIST_HEAD = REGISTRY.register(OperatorBuilders.LIST_1_PREFIX.inputTypes(ValueTypes.LIST).output(ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.PREFIX_1_LONG).symbolOperator("head").function(variables -> {
        ValueTypeList.ValueList list = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy a = list.getRawValue();
        if (a.getLength() > 0) {
            return a.get(0);
        }
        throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.index_out_of_bounds", new Object[]{0, a.getLength()}));
    }).conditionalOutputTypeDeriver((operator, input) -> {
        try {
            IValueTypeListProxy a = ((ValueTypeList.ValueList)input[0].getValue()).getRawValue();
            return a.getValueType();
        }
        catch (EvaluationException e) {
            return operator.getOutputType();
        }
    }).build());
    public static final IOperator LIST_TAIL = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST).renderPattern(IConfigRenderPattern.PREFIX_1_LONG).output(ValueTypes.LIST).symbolOperator("tail").function(variables -> {
        ValueTypeList.ValueList list = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy a = list.getRawValue();
        return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyTail(a));
    }).build());
    public static final IOperator LIST_UNIQ_PREDICATE = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.OPERATOR).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.LIST).symbolOperator("uniq_p").function(variables -> {
        ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy list = valueList.getRawValue();
        IOperator operator = OperatorBuilders.getSafePredictate(variables.getValue(1, ValueTypes.OPERATOR));
        ArrayList<IValue> values = new ArrayList<IValue>();
        block2: for (IValue value : list) {
            for (IValue existing : values) {
                IValue result = ValueHelpers.evaluateOperator(operator, value, existing);
                ValueHelpers.validatePredicateOutput(operator, result);
                if (!((ValueTypeBoolean.ValueBoolean)result).getRawValue()) continue;
                continue block2;
            }
            values.add(value);
        }
        return ValueTypeList.ValueList.ofList(list.getValueType(), values);
    }).build());
    public static final IOperator LIST_UNIQ = REGISTRY.register(OperatorBuilders.LIST.inputType(ValueTypes.LIST).renderPattern(IConfigRenderPattern.PREFIX_1_LONG).output(ValueTypes.LIST).symbolOperator("uniq").function(variables -> {
        ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy list = valueList.getRawValue();
        return ValueTypeList.ValueList.ofList(list.getValueType(), new ArrayList(Sets.newLinkedHashSet(list)));
    }).build());
    public static final IOperator LIST_SLICE = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.INTEGER, ValueTypes.INTEGER).renderPattern(IConfigRenderPattern.PREFIX_3).output(ValueTypes.LIST).symbolOperator("slice").function(variables -> {
        ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy list = valueList.getRawValue();
        ValueTypeInteger.ValueInteger from = variables.getValue(1, ValueTypes.INTEGER);
        ValueTypeInteger.ValueInteger to = variables.getValue(2, ValueTypes.INTEGER);
        if (from.getRawValue() >= to.getRawValue()) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.slice.to_greater_than_from"));
        }
        if (from.getRawValue() < 0 || to.getRawValue() < 0) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.slice.index_negative"));
        }
        return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxySlice(list, from.getRawValue(), to.getRawValue()));
    }).build());
    public static final IOperator OBJECT_BLOCK_OPAQUE = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("opaque").function(variables -> {
        ValueObjectTypeBlock.ValueBlock a = variables.getValue(0, ValueTypes.OBJECT_BLOCK);
        return ValueTypeBoolean.ValueBoolean.of(a.getRawValue().isPresent() && ((BlockState)a.getRawValue().get()).func_200015_d(null, null));
    }).build());
    public static final IOperator OBJECT_BLOCK_ITEMSTACK = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ITEMSTACK).symbolOperator("itemstack").function(variables -> {
        ValueObjectTypeBlock.ValueBlock a = variables.getValue(0, ValueTypes.OBJECT_BLOCK);
        return ValueObjectTypeItemStack.ValueItemStack.of(a.getRawValue().isPresent() ? BlockHelpers.getItemStackFromBlockState((BlockState)((BlockState)a.getRawValue().get())) : ItemStack.field_190927_a);
    }).build());
    public static final IOperator OBJECT_BLOCK_MODNAME = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("mod").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{variables -> {
        ValueObjectTypeBlock.ValueBlock a = variables.getValue(0, ValueTypes.OBJECT_BLOCK);
        return a.getRawValue().isPresent() ? ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)((BlockState)a.getRawValue().get()).func_177230_c()) : new ResourceLocation("");
    }, OperatorBuilders.PROPAGATOR_RESOURCELOCATION_MODNAME}))).build());
    public static final IOperator OBJECT_BLOCK_BREAKSOUND = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbol("break_sound").operatorName("breaksound").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{OperatorBuilders.BLOCK_SOUND, sound -> sound.isPresent() ? ((SoundType)sound.get()).func_185845_c().field_187506_b.toString() : "", OperatorBuilders.PROPAGATOR_STRING_VALUE}))).build());
    public static final IOperator OBJECT_BLOCK_PLACESOUND = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbol("place_sound").operatorName("placesound").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{OperatorBuilders.BLOCK_SOUND, sound -> sound.isPresent() ? ((SoundType)sound.get()).func_185841_e().field_187506_b.toString() : "", OperatorBuilders.PROPAGATOR_STRING_VALUE}))).build());
    public static final IOperator OBJECT_BLOCK_STEPSOUND = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbol("step_sound").operatorName("stepsound").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{OperatorBuilders.BLOCK_SOUND, sound -> sound.isPresent() ? ((SoundType)sound.get()).func_185844_d().field_187506_b.toString() : "", OperatorBuilders.PROPAGATOR_STRING_VALUE}))).build());
    public static final IOperator OBJECT_BLOCK_ISSHEARABLE = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_shearable").operatorName("isshearable").function(variables -> {
        ValueObjectTypeBlock.ValueBlock a = variables.getValue(0, ValueTypes.OBJECT_BLOCK);
        return ValueTypeBoolean.ValueBoolean.of(a.getRawValue().isPresent() && ((BlockState)a.getRawValue().get()).func_177230_c() instanceof IForgeShearable && ((IForgeShearable)((BlockState)a.getRawValue().get()).func_177230_c()).isShearable(ItemStack.field_190927_a, null, null));
    }).build());
    public static final IOperator OBJECT_BLOCK_ISPLANTABLE = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_plantable").operatorName("isplantable").function(variables -> {
        ValueObjectTypeBlock.ValueBlock a = variables.getValue(0, ValueTypes.OBJECT_BLOCK);
        return ValueTypeBoolean.ValueBoolean.of(a.getRawValue().isPresent() && ((BlockState)a.getRawValue().get()).func_177230_c() instanceof IPlantable);
    }).build());
    public static final IOperator OBJECT_BLOCK_PLANTTYPE = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbol("plant_type").operatorName("planttype").function(variables -> {
        ValueObjectTypeBlock.ValueBlock a = variables.getValue(0, ValueTypes.OBJECT_BLOCK);
        String type = "None";
        if (a.getRawValue().isPresent() && ((BlockState)a.getRawValue().get()).func_177230_c() instanceof IPlantable) {
            type = ((IPlantable)((BlockState)a.getRawValue().get()).func_177230_c()).getPlantType(null, null).getName();
        }
        return ValueTypeString.ValueString.of(type);
    }).build());
    public static final IOperator OBJECT_BLOCK_PLANT = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_BLOCK).symbolOperator("plant").function(variables -> {
        ValueObjectTypeBlock.ValueBlock a = variables.getValue(0, ValueTypes.OBJECT_BLOCK);
        BlockState plant = null;
        if (a.getRawValue().isPresent() && ((BlockState)a.getRawValue().get()).func_177230_c() instanceof IPlantable) {
            plant = ((IPlantable)((BlockState)a.getRawValue().get()).func_177230_c()).getPlant(null, null);
        }
        return ValueObjectTypeBlock.ValueBlock.of(plant);
    }).build());
    public static final IOperator OBJECT_BLOCK_PLANTAGE = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("plant_age").operatorName("plantage").function(variables -> {
        ValueObjectTypeBlock.ValueBlock a = variables.getValue(0, ValueTypes.OBJECT_BLOCK);
        int age = 0;
        if (a.getRawValue().isPresent()) {
            for (Property prop : ((BlockState)a.getRawValue().get()).func_235904_r_()) {
                if (!prop.func_177701_a().equals("age") || prop.func_177699_b() != Integer.class) continue;
                age = (Integer)((BlockState)a.getRawValue().get()).func_177229_b(prop);
            }
        }
        return ValueTypeInteger.ValueInteger.of(age);
    }).build());
    public static final IOperator OBJECT_BLOCK_BY_NAME = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.inputType(ValueTypes.STRING).output(ValueTypes.OBJECT_BLOCK).symbol("block_by_name").operatorName("blockbyname").function(OperatorBuilders.FUNCTION_STRING_TO_RESOURCE_LOCATION.build(input -> {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(input);
        return ValueObjectTypeBlock.ValueBlock.of(block.func_176223_P());
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_SIZE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("size").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(itemStack -> !itemStack.func_190926_b() ? itemStack.func_190916_E() : 0)).build());
    public static final IOperator OBJECT_ITEMSTACK_MAXSIZE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("maxsize").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(itemStack -> !itemStack.func_190926_b() ? itemStack.func_77976_d() : 0)).build());
    public static final IOperator OBJECT_ITEMSTACK_ISSTACKABLE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("stackable").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(itemStack -> !itemStack.func_190926_b() && itemStack.func_77985_e())).build());
    public static final IOperator OBJECT_ITEMSTACK_ISDAMAGEABLE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("damageable").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(itemStack -> !itemStack.func_190926_b() && itemStack.func_77984_f())).build());
    public static final IOperator OBJECT_ITEMSTACK_DAMAGE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("damage").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(itemStack -> !itemStack.func_190926_b() ? itemStack.func_77952_i() : 0)).build());
    public static final IOperator OBJECT_ITEMSTACK_MAXDAMAGE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("max_damage").operatorName("maxdamage").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(itemStack -> !itemStack.func_190926_b() ? itemStack.func_77958_k() : 0)).build());
    public static final IOperator OBJECT_ITEMSTACK_ISENCHANTED = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("enchanted").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(itemStack -> !itemStack.func_190926_b() && itemStack.func_77948_v())).build());
    public static final IOperator OBJECT_ITEMSTACK_ISENCHANTABLE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("enchantable").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(itemStack -> !itemStack.func_190926_b() && itemStack.func_77956_u())).build());
    public static final IOperator OBJECT_ITEMSTACK_REPAIRCOST = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("repair_cost").operatorName("repaircost").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(itemStack -> !itemStack.func_190926_b() ? itemStack.func_82838_A() : 0)).build());
    public static final IOperator OBJECT_ITEMSTACK_RARITY = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("rarity").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        return ValueTypeString.ValueString.of(!a.getRawValue().func_190926_b() ? a.getRawValue().func_77953_t().name() : "");
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_STRENGTH_VS_BLOCK = REGISTRY.register(OperatorBuilders.ITEMSTACK_2.inputTypes(ValueTypes.OBJECT_ITEMSTACK, ValueTypes.OBJECT_BLOCK).output(ValueTypes.DOUBLE).symbolOperator("strength").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        ValueObjectTypeBlock.ValueBlock b = variables.getValue(1, ValueTypes.OBJECT_BLOCK);
        return ValueTypeDouble.ValueDouble.of(!a.getRawValue().func_190926_b() && b.getRawValue().isPresent() ? (double)a.getRawValue().func_150997_a((BlockState)b.getRawValue().get()) : 0.0);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_CAN_HARVEST_BLOCK = REGISTRY.register(OperatorBuilders.ITEMSTACK_2_LONG.inputTypes(ValueTypes.OBJECT_ITEMSTACK, ValueTypes.OBJECT_BLOCK).output(ValueTypes.BOOLEAN).symbol("can_harvest").operatorName("canharvest").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        ValueObjectTypeBlock.ValueBlock b = variables.getValue(1, ValueTypes.OBJECT_BLOCK);
        return ValueTypeBoolean.ValueBoolean.of(!a.getRawValue().func_190926_b() && b.getRawValue().isPresent() && a.getRawValue().func_150998_b((BlockState)b.getRawValue().get()));
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_BLOCK = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_BLOCK).symbolOperator("block").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        return ValueObjectTypeBlock.ValueBlock.of(!a.getRawValue().func_190926_b() && a.getRawValue().func_77973_b() instanceof BlockItem ? BlockHelpers.getBlockStateFromItemStack((ItemStack)a.getRawValue()) : null);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_ISFLUIDSTACK = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_fluidstack").operatorName("isfluidstack").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(itemStack -> !itemStack.func_190926_b() && !Helpers.getFluidStack(itemStack).isEmpty())).build());
    public static final IOperator OBJECT_ITEMSTACK_FLUIDSTACK = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_FLUIDSTACK).symbolOperator("fluidstack").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        return ValueObjectTypeFluidStack.ValueFluidStack.of(!a.getRawValue().func_190926_b() ? Helpers.getFluidStack(a.getRawValue()) : null);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_FLUIDSTACKCAPACITY = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("fluidstack_capacity").operatorName("fluidstackcapacity").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(itemStack -> !itemStack.func_190926_b() ? Helpers.getFluidStackCapacity(itemStack) : 0)).build());
    public static final IOperator OBJECT_ITEMSTACK_ISNBTEQUAL = REGISTRY.register(OperatorBuilders.ITEMSTACK_2.output(ValueTypes.BOOLEAN).symbol("=NBT=").operatorName("isnbtequal").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack valueStack0 = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        ValueObjectTypeItemStack.ValueItemStack valueStack1 = variables.getValue(1, ValueTypes.OBJECT_ITEMSTACK);
        ItemStack a = valueStack0.getRawValue();
        ItemStack b = valueStack1.getRawValue();
        boolean equal = false;
        if (!a.func_190926_b() && !b.func_190926_b()) {
            equal = a.func_77969_a(b) && ItemMatch.areItemStacksEqual((ItemStack)a, (ItemStack)b, (int)4);
        } else if (a.func_190926_b() && b.func_190926_b()) {
            equal = true;
        }
        return ValueTypeBoolean.ValueBoolean.of(equal);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_ISITEMEQUALNONBT = REGISTRY.register(OperatorBuilders.ITEMSTACK_2.output(ValueTypes.BOOLEAN).symbol("=NoNBT=").operatorName("isitemequalnonbt").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack valueStack0 = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        ValueObjectTypeItemStack.ValueItemStack valueStack1 = variables.getValue(1, ValueTypes.OBJECT_ITEMSTACK);
        ItemStack a = valueStack0.getRawValue();
        ItemStack b = valueStack1.getRawValue();
        boolean equal = false;
        if (!a.func_190926_b() && !b.func_190926_b()) {
            equal = ItemMatch.areItemStacksEqual((ItemStack)a, (ItemStack)b, (int)1);
        } else if (a.func_190926_b() && b.func_190926_b()) {
            equal = true;
        }
        return ValueTypeBoolean.ValueBoolean.of(equal);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_ISRAWITEMEQUAL = REGISTRY.register(OperatorBuilders.ITEMSTACK_2.output(ValueTypes.BOOLEAN).symbol("=Raw=").operatorName("israwitemequal").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack valueStack0 = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        ValueObjectTypeItemStack.ValueItemStack valueStack1 = variables.getValue(1, ValueTypes.OBJECT_ITEMSTACK);
        ItemStack a = valueStack0.getRawValue();
        ItemStack b = valueStack1.getRawValue();
        boolean equal = false;
        if (!a.func_190926_b() && !b.func_190926_b()) {
            equal = ItemMatch.areItemStacksEqual((ItemStack)a, (ItemStack)b, (int)1);
        } else if (a.func_190926_b() && b.func_190926_b()) {
            equal = true;
        }
        return ValueTypeBoolean.ValueBoolean.of(equal);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_MODNAME = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("mod").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        return !a.getRawValue().func_190926_b() ? ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)a.getRawValue().func_77973_b()) : new ResourceLocation("");
    }, OperatorBuilders.PROPAGATOR_RESOURCELOCATION_MODNAME}))).build());
    public static final IOperator OBJECT_ITEMSTACK_FUELBURNTIME = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("burn_time").operatorName("burntime").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(itemStack -> {
        if (!itemStack.func_190926_b()) {
            int burnTime = itemStack.getBurnTime();
            return ForgeEventFactory.getItemBurnTime((ItemStack)itemStack, (int)(burnTime == -1 ? ForgeHooks.getBurnTime((ItemStack)itemStack) : burnTime));
        }
        return 0;
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_CANBURN = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("can_burn").operatorName("canburn").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(AbstractFurnaceTileEntity::func_213991_b)).build());
    public static final IOperator OBJECT_ITEMSTACK_TAG = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.LIST).symbol("tag_names").operatorName("tag").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!a.getRawValue().func_190926_b()) {
            for (ResourceLocation owningTag : ItemTags.func_199903_a().func_199913_a((Object)a.getRawValue().func_77973_b())) {
                builder.add((Object)ValueTypeString.ValueString.of(owningTag.toString()));
            }
        }
        return ValueTypeList.ValueList.ofList(ValueTypes.STRING, builder.build());
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_TAG_STACKS = REGISTRY.register(OperatorBuilders.STRING_1_PREFIX.output(ValueTypes.LIST).symbol("tag_values").operatorName("tag").inputType(ValueTypes.STRING).renderPattern(IConfigRenderPattern.SUFFIX_1_LONG).function(variables -> {
        ValueTypeString.ValueString a = variables.getValue(0, ValueTypes.STRING);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!StringUtils.func_151246_b((String)a.getRawValue())) {
            try {
                Helpers.getTagValues(a.getRawValue()).map(ValueObjectTypeItemStack.ValueItemStack::of).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            }
            catch (ResourceLocationException e) {
                throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent(e.getMessage()));
            }
        }
        return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, builder.build());
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_WITHSIZE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_INTEGER_1.output(ValueTypes.OBJECT_ITEMSTACK).symbol("with_size").operatorName("withsize").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        ValueTypeInteger.ValueInteger b = variables.getValue(1, ValueTypes.INTEGER);
        if (!a.getRawValue().func_190926_b()) {
            ItemStack itemStack = a.getRawValue().func_77946_l();
            itemStack.func_190920_e(b.getRawValue());
            return ValueObjectTypeItemStack.ValueItemStack.of(itemStack);
        }
        return a;
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_ISFECONTAINER = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_fe_container").operatorName("isfecontainer").function(OperatorBuilders.FUNCTION_CONTAINERITEM_TO_BOOLEAN.build(Objects::nonNull)).build());
    public static final IOperator OBJECT_ITEMSTACK_STOREDFE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("stored_fe").operatorName("storedfe").function(OperatorBuilders.FUNCTION_CONTAINERITEM_TO_INT.build(input -> input != null ? input.getEnergyStored() : 0)).build());
    public static final IOperator OBJECT_ITEMSTACK_FECAPACITY = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("capacity_fe").operatorName("fecapacity").function(OperatorBuilders.FUNCTION_CONTAINERITEM_TO_INT.build(input -> input != null ? input.getMaxEnergyStored() : 0)).build());
    public static final IOperator OBJECT_ITEMSTACK_HASINVENTORY = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("has_inventory").operatorName("hasinventory").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        return ValueTypeBoolean.ValueBoolean.of(!a.getRawValue().func_190926_b() && a.getRawValue().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent());
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_ISPLANTABLE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_plantable").operatorName("isplantable").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        return ValueTypeBoolean.ValueBoolean.of(!a.getRawValue().func_190926_b() && a.getRawValue().func_77973_b() instanceof BlockItem && ((BlockItem)a.getRawValue().func_77973_b()).func_179223_d() instanceof IPlantable);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_INVENTORYSIZE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("inventory_size").operatorName("inventorysize").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(IItemHandler::getSlots).orElse(0));
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_PLANTTYPE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbol("plant_type").operatorName("planttype").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        String type = "None";
        if (!a.getRawValue().func_190926_b() && a.getRawValue().func_77973_b() instanceof BlockItem && ((BlockItem)a.getRawValue().func_77973_b()).func_179223_d() instanceof IPlantable) {
            type = ((IPlantable)((BlockItem)a.getRawValue().func_77973_b()).func_179223_d()).getPlantType(null, null).getName();
        }
        return ValueTypeString.ValueString.of(type);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_INVENTORY = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.LIST).symbolOperator("inventory").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        return a.getRawValue().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(itemHandler -> {
            ArrayList values = Lists.newArrayListWithCapacity((int)itemHandler.getSlots());
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                values.add(ValueObjectTypeItemStack.ValueItemStack.of(itemHandler.getStackInSlot(i)));
            }
            return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, values);
        }).orElseGet(() -> ValueTypes.LIST.getDefault());
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_PLANT = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_BLOCK).symbolOperator("plant").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        BlockState plant = null;
        if (!a.getRawValue().func_190926_b() && a.getRawValue().func_77973_b() instanceof BlockItem && ((BlockItem)a.getRawValue().func_77973_b()).func_179223_d() instanceof IPlantable) {
            plant = ((BlockItem)a.getRawValue().func_77973_b()).func_179223_d().func_176223_P();
        }
        return ValueObjectTypeBlock.ValueBlock.of(plant);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_BY_NAME = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_PREFIX_LONG.inputType(ValueTypes.STRING).output(ValueTypes.OBJECT_ITEMSTACK).symbol("item_by_name").operatorName("itembyname").function(OperatorBuilders.FUNCTION_STRING_TO_RESOURCE_LOCATION.build(input -> {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(input);
        ItemStack itemStack = ItemStack.field_190927_a;
        if (item != null) {
            itemStack = new ItemStack((IItemProvider)item);
        }
        return ValueObjectTypeItemStack.ValueItemStack.of(itemStack);
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_LIST_COUNT = REGISTRY.register(OperatorBuilders.ITEMSTACK_2_LONG.inputTypes(ValueTypes.LIST, ValueTypes.OBJECT_ITEMSTACK).output(ValueTypes.INTEGER).symbol("item_list_count").operatorName("itemlistcount").function(variables -> {
        ValueTypeList.ValueList a = variables.getValue(0, ValueTypes.LIST);
        ValueObjectTypeItemStack.ValueItemStack b = variables.getValue(1, ValueTypes.OBJECT_ITEMSTACK);
        if (!ValueHelpers.correspondsTo(a.getRawValue().getValueType(), ValueTypes.OBJECT_ITEMSTACK)) {
            TranslationTextComponent error = new TranslationTextComponent("valuetype.integrateddynamics.error.invalid_list_value_type", new Object[]{new TranslationTextComponent(a.getRawValue().getValueType().getTranslationKey()), ValueTypes.OBJECT_ITEMSTACK});
            throw new EvaluationException((IFormattableTextComponent)error);
        }
        ItemStack itemStack = b.getRawValue();
        int count = 0;
        for (ValueObjectTypeItemStack.ValueItemStack listValue : a.getRawValue()) {
            if (listValue.getRawValue().func_190926_b()) continue;
            ItemStack listItem = listValue.getRawValue();
            if (!itemStack.func_190926_b()) {
                if (!itemStack.func_77969_a(listItem) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)listItem)) continue;
                count += listItem.func_190916_E();
                continue;
            }
            count += listItem.func_190916_E();
        }
        return ValueTypeInteger.ValueInteger.of(count);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_NBT = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.NBT).symbol("NBT()").operatorName("nbt").function(input -> {
        ValueObjectTypeItemStack.ValueItemStack itemStack = input.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        return ValueTypeNbt.ValueNbt.of((INBT)itemStack.getRawValue().func_77978_p());
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_HASNBT = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_PREFIX_LONG.output(ValueTypes.BOOLEAN).symbol("has_nbt").operatorName("hasnbt").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(itemStack -> !itemStack.func_190926_b() && itemStack.func_77942_o())).build());
    public static final IOperator OBJECT_ENTITY_ISMOB = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_mob").operatorName("ismob").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(entity -> entity instanceof IMob)).build());
    public static final IOperator OBJECT_ENTITY_ISANIMAL = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_animal").operatorName("isanimal").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(entity -> entity instanceof AnimalEntity && !(entity instanceof IMob))).build());
    public static final IOperator OBJECT_ENTITY_ISITEM = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_item").operatorName("isitem").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(entity -> entity instanceof ItemEntity)).build());
    public static final IOperator OBJECT_ENTITY_ISPLAYER = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_player").operatorName("isplayer").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(entity -> entity instanceof PlayerEntity)).build());
    public static final IOperator OBJECT_ENTITY_ISMINECART = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_minecart").operatorName("isminecart").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(entity -> entity instanceof AbstractMinecartEntity)).build());
    public static final IOperator OBJECT_ENTITY_ITEMSTACK = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX.output(ValueTypes.OBJECT_ITEMSTACK).symbolOperator("item").function(variables -> {
        ValueObjectTypeEntity.ValueEntity valueEntity = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        Optional<Entity> a = valueEntity.getRawValue();
        return ValueObjectTypeItemStack.ValueItemStack.of(a.isPresent() && a.get() instanceof ItemEntity ? ((ItemEntity)a.get()).func_92059_d() : ItemStack.field_190927_a);
    }).build());
    public static final IOperator OBJECT_ENTITY_HEALTH = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.DOUBLE).symbolOperator("health").function(OperatorBuilders.FUNCTION_ENTITY_TO_DOUBLE.build(entity -> entity instanceof LivingEntity ? (double)((LivingEntity)entity).func_110143_aJ() : 0.0)).build());
    public static final IOperator OBJECT_ENTITY_WIDTH = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.DOUBLE).symbolOperator("width").function(OperatorBuilders.FUNCTION_ENTITY_TO_DOUBLE.build(entity -> entity != null ? (double)entity.func_213311_cf() : 0.0)).build());
    public static final IOperator OBJECT_ENTITY_HEIGHT = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.DOUBLE).symbolOperator("height").function(OperatorBuilders.FUNCTION_ENTITY_TO_DOUBLE.build(entity -> entity != null ? (double)entity.func_213302_cg() : 0.0)).build());
    public static final IOperator OBJECT_ENTITY_ISBURNING = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_burning").operatorName("isburning").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(entity -> entity != null && entity.func_70027_ad())).build());
    public static final IOperator OBJECT_ENTITY_ISWET = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_wet").operatorName("iswet").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(entity -> entity != null && entity.func_70026_G())).build());
    public static final IOperator OBJECT_ENTITY_ISCROUCHING = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_crouching").operatorName("iscrouching").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(entity -> entity != null && entity.func_213453_ef())).build());
    public static final IOperator OBJECT_ENTITY_ISEATING = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_eating").operatorName("iseating").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(entity -> entity instanceof LivingEntity && ((LivingEntity)entity).func_184605_cv() > 0)).build());
    public static final IOperator OBJECT_ENTITY_ARMORINVENTORY = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.LIST).symbol("armor_inventory").operatorName("armorinventory").function(variables -> {
        ValueObjectTypeEntity.ValueEntity valueEntity = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        Optional<Entity> a = valueEntity.getRawValue();
        if (a.isPresent()) {
            Entity entity = a.get();
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyEntityArmorInventory(entity.field_70170_p, entity));
        }
        return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, Collections.emptyList());
    }).build());
    public static final IOperator OBJECT_ENTITY_INVENTORY = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.LIST).symbolOperator("inventory").function(variables -> {
        ValueObjectTypeEntity.ValueEntity valueEntity = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        Optional<Entity> a = valueEntity.getRawValue();
        if (a.isPresent()) {
            Entity entity = a.get();
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyEntityInventory(entity.field_70170_p, entity));
        }
        return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, Collections.emptyList());
    }).build());
    public static final IOperator OBJECT_ENTITY_MODNAME = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("mod").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        if (a.getRawValue().isPresent()) {
            Entity entity = a.getRawValue().get();
            return entity.func_200600_R().getRegistryName();
        }
        return new ResourceLocation("");
    }, OperatorBuilders.PROPAGATOR_RESOURCELOCATION_MODNAME}))).build());
    public static final IOperator OBJECT_PLAYER_TARGETBLOCK = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_BLOCK).symbol("target_block").operatorName("targetblock").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        BlockState blockState = null;
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof LivingEntity) {
            Vector3d direction;
            LivingEntity entity = (LivingEntity)a.getRawValue().get();
            ModifiableAttributeInstance reachDistanceAttribute = entity.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get());
            double reachDistance = reachDistanceAttribute == null ? 5.0 : reachDistanceAttribute.func_111126_e();
            double eyeHeight = entity.func_70047_e();
            Vector3d lookVec = entity.func_70040_Z();
            Vector3d origin = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + eyeHeight, entity.func_226281_cx_());
            RayTraceContext rayTraceContext = new RayTraceContext(origin, direction = origin.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)entity);
            BlockRayTraceResult mop = entity.field_70170_p.func_217299_a(rayTraceContext);
            if (mop != null && mop.func_216346_c() == RayTraceResult.Type.BLOCK) {
                blockState = entity.field_70170_p.func_180495_p(mop.func_216350_a());
            }
        }
        return ValueObjectTypeBlock.ValueBlock.of(blockState);
    }).build());
    public static final IOperator OBJECT_PLAYER_TARGETENTITY = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ENTITY).symbol("target_entity").operatorName("targetentity").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        Entity entityOut = null;
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof LivingEntity) {
            AxisAlignedBB boundingBox;
            LivingEntity entity = (LivingEntity)a.getRawValue().get();
            ModifiableAttributeInstance reachDistanceAttribute = entity.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get());
            double reachDistance = reachDistanceAttribute == null ? 5.0 : reachDistanceAttribute.func_111126_e();
            Vector3d origin = entity.func_174824_e(1.0f);
            double reachDistanceSquared = reachDistance * reachDistance;
            Vector3d lookVec = entity.func_70676_i(1.0f);
            Vector3d direction = origin.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
            EntityRayTraceResult entityraytraceresult = ProjectileHelper.func_221273_a((Entity)entity, (Vector3d)origin, (Vector3d)direction, (AxisAlignedBB)(boundingBox = entity.func_174813_aQ().func_216361_a(lookVec.func_186678_a(reachDistance)).func_72314_b(1.0, 1.0, 1.0)), e -> !e.func_175149_v() && e.func_70067_L(), (double)reachDistanceSquared);
            if (entityraytraceresult != null) {
                Entity entity1 = entityraytraceresult.func_216348_a();
                Vector3d vec3d3 = entityraytraceresult.func_216347_e();
                double distanceSquared = origin.func_72436_e(vec3d3);
                if (distanceSquared < reachDistanceSquared && (entity1 instanceof LivingEntity || entity1 instanceof ItemFrameEntity)) {
                    entityOut = entity1;
                }
            }
        }
        return ValueObjectTypeEntity.ValueEntity.of(entityOut);
    }).build());
    public static final IOperator OBJECT_PLAYER_HASGUIOPEN = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("has_gui_open").operatorName("hasguiopen").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof PlayerEntity) {
            PlayerEntity entity = (PlayerEntity)a.getRawValue().get();
            return ValueTypeBoolean.ValueBoolean.of(entity.field_71070_bA != entity.field_71069_bz);
        }
        return ValueTypeBoolean.ValueBoolean.of(false);
    }).build());
    public static final IOperator OBJECT_ENTITY_HELDITEM_MAIN = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ITEMSTACK).symbol("held_item_1").operatorName("helditem").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        ItemStack itemStack = ItemStack.field_190927_a;
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof LivingEntity) {
            itemStack = ((LivingEntity)a.getRawValue().get()).func_184614_ca();
        }
        return ValueObjectTypeItemStack.ValueItemStack.of(itemStack);
    }).build());
    public static final IOperator OBJECT_ENTITY_HELDITEM_OFF = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ITEMSTACK).symbol("held_item_2").operatorName("helditemoffhand").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        ItemStack itemStack = ItemStack.field_190927_a;
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof LivingEntity) {
            itemStack = ((LivingEntity)a.getRawValue().get()).func_184592_cb();
        }
        return ValueObjectTypeItemStack.ValueItemStack.of(itemStack);
    }).build());
    public static final IOperator OBJECT_ENTITY_MOUNTED = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.LIST).symbolOperator("mounted").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        ArrayList passengers = Lists.newArrayList();
        if (a.getRawValue().isPresent()) {
            for (Entity passenger : a.getRawValue().get().func_184188_bt()) {
                passengers.add(ValueObjectTypeEntity.ValueEntity.of(passenger));
            }
        }
        return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ENTITY, passengers);
    }).build());
    public static final IOperator OBJECT_ITEMFRAME_CONTENTS = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ITEMSTACK).symbol("itemframe_contents").operatorName("itemframecontents").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        ItemStack itemStack = ItemStack.field_190927_a;
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof ItemFrameEntity) {
            itemStack = ((ItemFrameEntity)a.getRawValue().get()).func_82335_i();
        }
        return ValueObjectTypeItemStack.ValueItemStack.of(itemStack);
    }).build());
    public static final IOperator OBJECT_ITEMFRAME_ROTATION = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("itemframe_rotation").operatorName("itemframerotation").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        Integer rotation = 0;
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof ItemFrameEntity) {
            rotation = ((ItemFrameEntity)a.getRawValue().get()).func_82333_j();
        }
        return ValueTypeInteger.ValueInteger.of(rotation);
    }).build());
    public static final IOperator OBJECT_ENTITY_HURTSOUND = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("hurtsound").function(variables -> {
        String sound;
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        String hurtSound = "";
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof LivingEntity && (sound = ((LivingEntity)a.getRawValue().get()).func_184601_bQ((DamageSource)DamageSource.field_76377_j).field_187506_b.toString()) != null) {
            hurtSound = sound;
        }
        return ValueTypeString.ValueString.of(hurtSound);
    }).build());
    public static final IOperator OBJECT_ENTITY_DEATHSOUND = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("deathsound").function(variables -> {
        String sound;
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        String hurtSound = "";
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof LivingEntity && (sound = ((LivingEntity)a.getRawValue().get()).func_184615_bR().field_187506_b.toString()) != null) {
            hurtSound = sound;
        }
        return ValueTypeString.ValueString.of(hurtSound);
    }).build());
    public static final IOperator OBJECT_ENTITY_AGE = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("age").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        int age = 0;
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof LivingEntity) {
            age = ((LivingEntity)a.getRawValue().get()).func_70654_ax();
        }
        return ValueTypeInteger.ValueInteger.of(age);
    }).build());
    public static final IOperator OBJECT_ENTITY_ISCHILD = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_child").operatorName("ischild").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        boolean child = false;
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof LivingEntity) {
            child = ((LivingEntity)a.getRawValue().get()).func_70631_g_();
        }
        return ValueTypeBoolean.ValueBoolean.of(child);
    }).build());
    public static final IOperator OBJECT_ENTITY_CANBREED = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("canbreed").operatorName("canbreed").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        boolean canBreed = false;
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof AgeableEntity) {
            canBreed = ((AgeableEntity)a.getRawValue().get()).func_70874_b() == 0;
        }
        return ValueTypeBoolean.ValueBoolean.of(canBreed);
    }).build());
    public static final IOperator OBJECT_ENTITY_ISINLOVE = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_in_love").operatorName("isinlove").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        boolean inLove = false;
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof AnimalEntity) {
            inLove = ((AnimalEntity)a.getRawValue().get()).func_70880_s();
        }
        return ValueTypeBoolean.ValueBoolean.of(inLove);
    }).build());
    public static final IOperator OBJECT_ENTITY_CANBREEDWITH = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.inputTypes(ValueTypes.OBJECT_ENTITY, ValueTypes.OBJECT_ITEMSTACK).output(ValueTypes.BOOLEAN).symbol("can_breed_with").operatorName("canbreedwith").renderPattern(IConfigRenderPattern.INFIX_LONG).function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        ValueObjectTypeItemStack.ValueItemStack b = variables.getValue(1, ValueTypes.OBJECT_ITEMSTACK);
        boolean canBreedWith = false;
        if (a.getRawValue().isPresent() && !b.getRawValue().func_190926_b() && a.getRawValue().get() instanceof AnimalEntity) {
            canBreedWith = ((AnimalEntity)a.getRawValue().get()).func_70877_b(b.getRawValue());
        }
        return ValueTypeBoolean.ValueBoolean.of(canBreedWith);
    }).build());
    public static final IOperator OBJECT_ENTITY_ISSHEARABLE = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_shearable").operatorName("isshearable").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        return ValueTypeBoolean.ValueBoolean.of(a.getRawValue().isPresent() && a.getRawValue().get() instanceof IForgeShearable && ((IForgeShearable)a.getRawValue().get()).isShearable(ItemStack.field_190927_a, null, null));
    }).build());
    public static final IOperator OBJECT_ENTITY_NBT = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.NBT).symbol("NBT()").operatorName("nbt").function(input -> {
        ValueObjectTypeEntity.ValueEntity entity = input.getValue(0, ValueTypes.OBJECT_ENTITY);
        try {
            if (entity.getRawValue().isPresent()) {
                return ValueTypeNbt.ValueNbt.of((INBT)entity.getRawValue().get().serializeNBT());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ValueTypes.NBT.getDefault();
    }).build());
    public static final IOperator OBJECT_ENTITY_TYPE = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.STRING).symbol("entity_type").operatorName("entitytype").function(input -> {
        ValueObjectTypeEntity.ValueEntity entity = input.getValue(0, ValueTypes.OBJECT_ENTITY);
        String entityType = "";
        if (entity.getRawValue().isPresent()) {
            Entity e = entity.getRawValue().get();
            entityType = e.func_200600_R().getRegistryName().toString();
        }
        return ValueTypeString.ValueString.of(entityType);
    }).build());
    public static final IOperator OBJECT_ENTITY_ITEMS = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.LIST).symbol("entity_items").operatorName("entityitems").function(input -> {
        ValueObjectTypeEntity.ValueEntity valueEntity = input.getValue(0, ValueTypes.OBJECT_ENTITY);
        Optional<Entity> a = valueEntity.getRawValue();
        if (a.isPresent()) {
            Entity entity = a.get();
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyEntityItems(entity.field_70170_p, entity, null));
        }
        return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, Collections.emptyList());
    }).build());
    public static final IOperator OBJECT_ENTITY_FLUIDS = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.LIST).symbol("entity_fluids").operatorName("entityfluids").function(input -> {
        ValueObjectTypeEntity.ValueEntity valueEntity = input.getValue(0, ValueTypes.OBJECT_ENTITY);
        Optional<Entity> a = valueEntity.getRawValue();
        if (a.isPresent()) {
            Entity entity = a.get();
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyEntityFluids(entity.field_70170_p, entity, null));
        }
        return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_FLUIDSTACK, Collections.emptyList());
    }).build());
    public static final IOperator OBJECT_ENTITY_ENERGY_STORED = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("entity_stored_fe").operatorName("entityenergystored").function(input -> {
        ValueObjectTypeEntity.ValueEntity valueEntity = input.getValue(0, ValueTypes.OBJECT_ENTITY);
        Optional<Entity> a = valueEntity.getRawValue();
        if (a.isPresent()) {
            Entity entity = a.get();
            return ValueTypeInteger.ValueInteger.of(entity.getCapability(CapabilityEnergy.ENERGY, null).map(IEnergyStorage::getEnergyStored).orElse(0));
        }
        return ValueTypeInteger.ValueInteger.of(0);
    }).build());
    public static final IOperator OBJECT_ENTITY_ENERGY_CAPACITY = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("entity_capacity_fe").operatorName("entityenergycapacity").function(input -> {
        ValueObjectTypeEntity.ValueEntity valueEntity = input.getValue(0, ValueTypes.OBJECT_ENTITY);
        Optional<Entity> a = valueEntity.getRawValue();
        if (a.isPresent()) {
            Entity entity = a.get();
            return ValueTypeInteger.ValueInteger.of(entity.getCapability(CapabilityEnergy.ENERGY, null).map(IEnergyStorage::getMaxEnergyStored).orElse(0));
        }
        return ValueTypeInteger.ValueInteger.of(0);
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_AMOUNT = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("amount").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_INT.build(FluidStack::getAmount)).build());
    public static final IOperator OBJECT_FLUIDSTACK_BLOCK = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_BLOCK).symbolOperator("block").function(variables -> {
        ValueObjectTypeFluidStack.ValueFluidStack valueFluidStack = variables.getValue(0, ValueTypes.OBJECT_FLUIDSTACK);
        FluidStack a = valueFluidStack.getRawValue();
        return ValueObjectTypeBlock.ValueBlock.of(!a.isEmpty() ? a.getFluid().getAttributes().getStateForPlacement(null, null, a).func_206883_i() : null);
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_LUMINOSITY = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("luminosity").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_INT.build(fluidStack -> fluidStack.getFluid().getAttributes().getLuminosity(fluidStack))).build());
    public static final IOperator OBJECT_FLUIDSTACK_DENSITY = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("density").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_INT.build(fluidStack -> fluidStack.getFluid().getAttributes().getDensity(fluidStack))).build());
    public static final IOperator OBJECT_FLUIDSTACK_VISCOSITY = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("viscosity").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_INT.build(fluidStack -> fluidStack.getFluid().getAttributes().getViscosity(fluidStack))).build());
    public static final IOperator OBJECT_FLUIDSTACK_ISGASEOUS = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_gaseous").operatorName("isgaseous").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_BOOLEAN.build(fluidStack -> fluidStack.getFluid().getAttributes().isGaseous(fluidStack))).build());
    public static final IOperator OBJECT_FLUIDSTACK_RARITY = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("rarity").function(variables -> {
        ValueObjectTypeFluidStack.ValueFluidStack valueFluidStack = variables.getValue(0, ValueTypes.OBJECT_FLUIDSTACK);
        FluidStack a = valueFluidStack.getRawValue();
        return ValueTypeString.ValueString.of(a.getFluid().getAttributes().getRarity(a).name());
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_ISRAWFLUIDEQUAL = REGISTRY.register(OperatorBuilders.FLUIDSTACK_2.output(ValueTypes.BOOLEAN).symbol("=Raw=").operatorName("israwfluidequal").function(variables -> {
        ValueObjectTypeFluidStack.ValueFluidStack valueFluidStack0 = variables.getValue(0, ValueTypes.OBJECT_FLUIDSTACK);
        ValueObjectTypeFluidStack.ValueFluidStack valueFluidStack1 = variables.getValue(1, ValueTypes.OBJECT_FLUIDSTACK);
        return ValueTypeBoolean.ValueBoolean.of(valueFluidStack0.getRawValue().isFluidEqual(valueFluidStack1.getRawValue()));
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_MODNAME = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("mod").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{variables -> {
        ValueObjectTypeFluidStack.ValueFluidStack a = variables.getValue(0, ValueTypes.OBJECT_FLUIDSTACK);
        return a.getRawValue().getFluid().getRegistryName();
    }, OperatorBuilders.PROPAGATOR_RESOURCELOCATION_MODNAME}))).build());
    public static final IOperator OBJECT_FLUIDSTACK_NBT = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.NBT).symbol("NBT()").operatorName("nbt").function(input -> {
        ValueObjectTypeFluidStack.ValueFluidStack fluidStack = input.getValue(0, ValueTypes.OBJECT_FLUIDSTACK);
        return ValueTypeNbt.ValueNbt.of((INBT)fluidStack.getRawValue().getTag());
    }).build());
    public static final IOperator OPERATOR_APPLY = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.conditionalOutputTypeDeriver(OperatorBuilders.OPERATOR_CONDITIONAL_OUTPUT_DERIVER).output(ValueTypes.CATEGORY_ANY).symbolOperator("apply").typeValidator(OperatorBuilders.createOperatorTypeValidator(ValueTypes.CATEGORY_ANY)).function(OperatorBuilders.FUNCTION_OPERATOR_TAKE_OPERATOR.build(input -> {
        IOperator innerOperator = (IOperator)input.getLeft();
        OperatorBase.SafeVariablesGetter variables = (OperatorBase.SafeVariablesGetter)input.getRight();
        IVariable variable = variables.getVariables()[0];
        return ValueHelpers.evaluateOperator(innerOperator, variable);
    })).build());
    public static final IOperator OPERATOR_APPLY_2;
    public static final IOperator OPERATOR_APPLY_3;
    public static final IOperator OPERATOR_MAP;
    public static final IOperator OPERATOR_FILTER;
    public static final IOperator OPERATOR_CONJUNCTION;
    public static final IOperator OPERATOR_DISJUNCTION;
    public static final IOperator OPERATOR_NEGATION;
    public static final IOperator OPERATOR_PIPE;
    public static final IOperator OPERATOR_PIPE2;
    public static final IOperator OPERATOR_FLIP;
    public static final IOperator OPERATOR_REDUCE;
    public static final IOperator OPERATOR_REDUCE1;
    public static final IOperator OPERATOR_BY_NAME;
    public static final IOperator NBT_COMPOUND_SIZE;
    public static final IOperator NBT_COMPOUND_KEYS;
    public static final IOperator NBT_COMPOUND_HASKEY;
    public static final IOperator NBT_COMPOUND_VALUE_TYPE;
    public static final IOperator NBT_COMPOUND_VALUE_TAG;
    public static final IOperator NBT_COMPOUND_VALUE_BOOLEAN;
    public static final IOperator NBT_COMPOUND_VALUE_INTEGER;
    public static final IOperator NBT_COMPOUND_VALUE_LONG;
    public static final IOperator NBT_COMPOUND_VALUE_DOUBLE;
    public static final IOperator NBT_COMPOUND_VALUE_STRING;
    public static final IOperator NBT_COMPOUND_VALUE_COMPOUND;
    public static final IOperator NBT_COMPOUND_VALUE_LIST_TAG;
    public static final IOperator NBT_COMPOUND_VALUE_LIST_BYTE;
    public static final IOperator NBT_COMPOUND_VALUE_LIST_INT;
    public static final IOperator NBT_COMPOUND_VALUE_LIST_LONG;
    public static final IOperator NBT_COMPOUND_WITHOUT;
    public static final IOperator NBT_COMPOUND_WITH_BOOLEAN;
    public static final IOperator NBT_COMPOUND_WITH_SHORT;
    public static final IOperator NBT_COMPOUND_WITH_INTEGER;
    public static final IOperator NBT_COMPOUND_WITH_LONG;
    public static final IOperator NBT_COMPOUND_WITH_DOUBLE;
    public static final IOperator NBT_COMPOUND_WITH_FLOAT;
    public static final IOperator NBT_COMPOUND_WITH_STRING;
    public static final IOperator NBT_COMPOUND_WITH_COMPOUND;
    public static final IOperator NBT_COMPOUND_WITH_LIST_TAG;
    public static final IOperator NBT_COMPOUND_WITH_LIST_BYTE;
    public static final IOperator NBT_COMPOUND_WITH_LIST_INT;
    public static final IOperator NBT_COMPOUND_WITH_LIST_LONG;
    public static final IOperator NBT_COMPOUND_SUBSET;
    public static final IOperator NBT_COMPOUND_UNION;
    public static final IOperator NBT_COMPOUND_INTERSECTION;
    public static final IOperator NBT_COMPOUND_MINUS;
    public static final IOperator NBT_AS_BOOLEAN;
    public static final IOperator NBT_AS_BYTE;
    public static final IOperator NBT_AS_SHORT;
    public static final IOperator NBT_AS_INT;
    public static final IOperator NBT_AS_LONG;
    public static final IOperator NBT_AS_DOUBLE;
    public static final IOperator NBT_AS_FLOAT;
    public static final IOperator NBT_AS_STRING;
    public static final IOperator NBT_AS_TAG_LIST;
    public static final IOperator NBT_AS_BYTE_LIST;
    public static final IOperator NBT_AS_INT_LIST;
    public static final IOperator NBT_AS_LONG_LIST;
    public static final IOperator NBT_FROM_BOOLEAN;
    public static final IOperator NBT_FROM_SHORT;
    public static final IOperator NBT_FROM_BYTE;
    public static final IOperator NBT_FROM_INT;
    public static final IOperator NBT_FROM_LONG;
    public static final IOperator NBT_FROM_DOUBLE;
    public static final IOperator NBT_FROM_FLOAT;
    public static final IOperator NBT_FROM_STRING;
    public static final IOperator NBT_FROM_TAG_LIST;
    public static final IOperator NBT_FROM_BYTE_LIST;
    public static final IOperator NBT_FROM_INT_LIST;
    public static final IOperator NBT_FROM_LONG_LIST;
    public static final IOperator NBT_PATH_MATCH_FIRST;
    public static final IOperator NBT_PATH_MATCH_ALL;
    public static final IOperator NBT_PATH_TEST;
    public static final IOperator INGREDIENTS_ITEMS;
    public static final IOperator INGREDIENTS_FLUIDS;
    public static final IOperator INGREDIENTS_ENERGIES;
    public static final IOperator INGREDIENTS_WITH_ITEM;
    public static final IOperator INGREDIENTS_WITH_FLUID;
    public static final IOperator INGREDIENTS_WITH_ENERGY;
    public static final IOperator INGREDIENTS_WITH_ITEMS;
    public static final IOperator INGREDIENTS_WITH_FLUIDS;
    public static final IOperator INGREDIENTS_WITH_ENERGIES;
    public static final IOperator RECIPE_INPUT;
    public static final IOperator RECIPE_OUTPUT;
    public static final IOperator RECIPE_WITH_INPUT;
    public static final IOperator RECIPE_WITH_OUTPUT;
    public static final IOperator RECIPE_WITH_INPUT_OUTPUT;
    public static final IOperator PARSE_BOOLEAN;
    public static final IOperator PARSE_DOUBLE;
    public static final IOperator PARSE_INTEGER;
    public static final IOperator PARSE_LONG;
    public static final IOperator PARSE_NBT;
    public static final GeneralOperator GENERAL_CHOICE;
    public static final GeneralOperator GENERAL_IDENTITY;
    public static final GeneralOperator GENERAL_CONSTANT;

    private static IOperatorRegistry constructRegistry() {
        if (MinecraftHelpers.isModdedEnvironment()) {
            return (IOperatorRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IOperatorRegistry.class);
        }
        return OperatorRegistry.getInstance();
    }

    public static void load() {
    }

    static {
        REGISTRY.registerSerializer(new CurriedOperator.Serializer());
        OPERATOR_APPLY_2 = REGISTRY.register(OperatorBuilders.OPERATOR.renderPattern(IConfigRenderPattern.INFIX_2).conditionalOutputTypeDeriver(OperatorBuilders.OPERATOR_CONDITIONAL_OUTPUT_DERIVER).inputTypes(ValueTypes.OPERATOR, ValueTypes.CATEGORY_ANY, ValueTypes.CATEGORY_ANY).output(ValueTypes.CATEGORY_ANY).symbolOperator("apply2").typeValidator(OperatorBuilders.createOperatorTypeValidator(ValueTypes.CATEGORY_ANY, ValueTypes.CATEGORY_ANY)).function(OperatorBuilders.FUNCTION_OPERATOR_TAKE_OPERATOR.build(input -> {
            IOperator innerOperator = (IOperator)input.getLeft();
            OperatorBase.SafeVariablesGetter variables = (OperatorBase.SafeVariablesGetter)input.getRight();
            IVariable variable0 = variables.getVariables()[0];
            IVariable variable1 = variables.getVariables()[1];
            return ValueHelpers.evaluateOperator(innerOperator, variable0, variable1);
        })).build());
        OPERATOR_APPLY_3 = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.renderPattern(IConfigRenderPattern.INFIX_3).conditionalOutputTypeDeriver(OperatorBuilders.OPERATOR_CONDITIONAL_OUTPUT_DERIVER).inputTypes(ValueTypes.OPERATOR, ValueTypes.CATEGORY_ANY, ValueTypes.CATEGORY_ANY, ValueTypes.CATEGORY_ANY).output(ValueTypes.CATEGORY_ANY).symbolOperator("apply3").typeValidator(OperatorBuilders.createOperatorTypeValidator(ValueTypes.CATEGORY_ANY, ValueTypes.CATEGORY_ANY, ValueTypes.CATEGORY_ANY)).function(OperatorBuilders.FUNCTION_OPERATOR_TAKE_OPERATOR.build(input -> {
            IOperator innerOperator = (IOperator)input.getLeft();
            OperatorBase.SafeVariablesGetter variables = (OperatorBase.SafeVariablesGetter)input.getRight();
            IVariable variable0 = variables.getVariables()[0];
            IVariable variable1 = variables.getVariables()[1];
            IVariable variable2 = variables.getVariables()[2];
            return ValueHelpers.evaluateOperator(innerOperator, variable0, variable1, variable2);
        })).build());
        OPERATOR_MAP = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.inputTypes(ValueTypes.OPERATOR, ValueTypes.LIST).output(ValueTypes.LIST).symbolOperator("map").function(OperatorBuilders.FUNCTION_OPERATOR_TAKE_OPERATOR_LIST.build(input -> {
            IOperator innerOperator = (IOperator)input.getLeft();
            OperatorBase.SafeVariablesGetter variables = (OperatorBase.SafeVariablesGetter)input.getRight();
            ValueTypeList.ValueList inputList = variables.getValue(0, ValueTypes.LIST);
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyOperatorMapped(innerOperator, inputList.getRawValue()));
        })).build());
        OPERATOR_FILTER = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.inputTypes(ValueTypes.OPERATOR, ValueTypes.LIST).output(ValueTypes.LIST).symbolOperator("filter").function(OperatorBuilders.FUNCTION_OPERATOR_TAKE_OPERATOR_LIST.build(new IOperatorValuePropagator<Pair<IOperator, OperatorBase.SafeVariablesGetter>, IValue>(){

            @Override
            public IValue getOutput(Pair<IOperator, OperatorBase.SafeVariablesGetter> input) throws EvaluationException {
                IOperator innerOperator = (IOperator)input.getLeft();
                OperatorBase.SafeVariablesGetter variables = (OperatorBase.SafeVariablesGetter)input.getRight();
                ValueTypeList.ValueList inputList = variables.getValue(0, ValueTypes.LIST);
                ArrayList filtered = Lists.newArrayList();
                for (IValue value : inputList.getRawValue()) {
                    IValue result = ValueHelpers.evaluateOperator(innerOperator, value);
                    ValueHelpers.validatePredicateOutput(innerOperator, result);
                    if (!((ValueTypeBoolean.ValueBoolean)result).getRawValue()) continue;
                    filtered.add(value);
                }
                Object valueType = inputList.getRawValue().getValueType();
                return ValueTypeList.ValueList.ofList(valueType, filtered);
            }
        })).build());
        OPERATOR_CONJUNCTION = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.inputTypes(ValueTypes.OPERATOR, ValueTypes.OPERATOR).output(ValueTypes.OPERATOR).symbol(".&&.").operatorName("conjunction").function(OperatorBuilders.FUNCTION_TWO_PREDICATES.build(input -> ValueTypeOperator.ValueOperator.of(CombinedOperator.Conjunction.asOperator((IOperator)input.getLeft(), (IOperator)input.getRight())))).build());
        REGISTRY.registerSerializer(new CombinedOperator.Conjunction.Serializer());
        OPERATOR_DISJUNCTION = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.inputTypes(ValueTypes.OPERATOR, ValueTypes.OPERATOR).output(ValueTypes.OPERATOR).symbol(".||.").operatorName("disjunction").function(OperatorBuilders.FUNCTION_TWO_PREDICATES.build(input -> ValueTypeOperator.ValueOperator.of(CombinedOperator.Disjunction.asOperator((IOperator)input.getLeft(), (IOperator)input.getRight())))).build());
        REGISTRY.registerSerializer(new CombinedOperator.Disjunction.Serializer());
        OPERATOR_NEGATION = REGISTRY.register(OperatorBuilders.OPERATOR_1_PREFIX_LONG.renderPattern(IConfigRenderPattern.PREFIX_1).inputTypes(ValueTypes.OPERATOR).output(ValueTypes.OPERATOR).symbol("!.").operatorName("negation").function(OperatorBuilders.FUNCTION_ONE_PREDICATE.build(input -> ValueTypeOperator.ValueOperator.of(CombinedOperator.Negation.asOperator(input)))).build());
        REGISTRY.registerSerializer(new CombinedOperator.Negation.Serializer());
        OPERATOR_PIPE = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.inputTypes(ValueTypes.OPERATOR, ValueTypes.OPERATOR).output(ValueTypes.OPERATOR).symbol(".").operatorName("pipe").function(OperatorBuilders.FUNCTION_TWO_OPERATORS.build(input -> ValueTypeOperator.ValueOperator.of(CombinedOperator.Pipe.asOperator((IOperator)input.getLeft(), (IOperator)input.getRight())))).build());
        REGISTRY.registerSerializer(new CombinedOperator.Pipe.Serializer());
        OPERATOR_PIPE2 = REGISTRY.register(OperatorBuilders.OPERATOR.inputTypes(ValueTypes.OPERATOR, ValueTypes.OPERATOR, ValueTypes.OPERATOR).renderPattern(IConfigRenderPattern.INFIX_2_LATE).output(ValueTypes.OPERATOR).symbol(".2").operatorName("pipe2").function(OperatorBuilders.FUNCTION_THREE_OPERATORS.build(input -> ValueTypeOperator.ValueOperator.of(CombinedOperator.Pipe2.asOperator((IOperator)input.getLeft(), (IOperator)input.getMiddle(), (IOperator)input.getRight())))).build());
        REGISTRY.registerSerializer(new CombinedOperator.Pipe2.Serializer());
        OPERATOR_FLIP = REGISTRY.register(OperatorBuilders.OPERATOR_1_PREFIX_LONG.renderPattern(IConfigRenderPattern.PREFIX_1).inputTypes(ValueTypes.OPERATOR).output(ValueTypes.OPERATOR).symbolOperator("flip").function(OperatorBuilders.FUNCTION_ONE_OPERATOR.build(input -> ValueTypeOperator.ValueOperator.of(CombinedOperator.Flip.asOperator(input)))).build());
        REGISTRY.registerSerializer(new CombinedOperator.Flip.Serializer());
        OPERATOR_REDUCE = REGISTRY.register(OperatorBuilders.OPERATOR.inputTypes(ValueTypes.OPERATOR, ValueTypes.LIST, ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.PREFIX_3_LONG).output(ValueTypes.CATEGORY_ANY).symbolOperator("reduce").conditionalOutputTypeDeriver((operator, input) -> input[2].getType()).function(variables -> {
            IValue accumulator = variables.getValue(2);
            IOperator innerOperator = OperatorBuilders.getSafeOperator(variables.getValue(0, ValueTypes.OPERATOR), accumulator.getType());
            ValueTypeList.ValueList inputList = variables.getValue(1, ValueTypes.LIST);
            for (IValue listValue : inputList.getRawValue()) {
                accumulator = ValueHelpers.evaluateOperator(innerOperator, accumulator, listValue);
            }
            return accumulator;
        }).build());
        OPERATOR_REDUCE1 = REGISTRY.register(OperatorBuilders.OPERATOR.inputTypes(ValueTypes.OPERATOR, ValueTypes.LIST).renderPattern(IConfigRenderPattern.PREFIX_2_LONG).output(ValueTypes.CATEGORY_ANY).symbolOperator("reduce1").conditionalOutputTypeDeriver((operator, input) -> {
            try {
                IValueTypeListProxy a = ((ValueTypeList.ValueList)input[1].getValue()).getRawValue();
                return a.getValueType();
            }
            catch (EvaluationException e) {
                return operator.getOutputType();
            }
        }).function(variables -> {
            ValueTypeList.ValueList valueList = variables.getValue(1, ValueTypes.LIST);
            Iterator iter = valueList.getRawValue().iterator();
            if (!iter.hasNext()) {
                throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.reduce.empty"));
            }
            IValue accumulator = (IValue)iter.next();
            IOperator innerOperator = OperatorBuilders.getSafeOperator(variables.getValue(0, ValueTypes.OPERATOR), accumulator.getType());
            while (iter.hasNext()) {
                IValue listValue = (IValue)iter.next();
                accumulator = ValueHelpers.evaluateOperator(innerOperator, accumulator, listValue);
            }
            return accumulator;
        }).build());
        OPERATOR_BY_NAME = REGISTRY.register(OperatorBuilders.OPERATOR_1_PREFIX_LONG.inputType(ValueTypes.STRING).output(ValueTypes.OPERATOR).symbol("op_by_name").operatorName("by_name").function(input -> {
            ValueTypeString.ValueString name = input.getValue(0, ValueTypes.STRING);
            IOperator operator = REGISTRY.getOperator(ResourceLocation.func_208304_a((String)name.getRawValue()));
            if (operator == null) {
                throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.operator_not_found", new Object[]{name.getRawValue()}));
            }
            return ValueTypeOperator.ValueOperator.of(operator);
        }).build());
        NBT_COMPOUND_SIZE = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.INTEGER).operatorName("compound_size").symbol("NBT{}.size").function(OperatorBuilders.FUNCTION_NBT_COMPOUND_TO_INT.build(opt -> opt.map(CompoundNBT::func_186856_d).orElse(0))).build());
        NBT_COMPOUND_KEYS = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.LIST).operatorName("compound_keys").symbol("NBT{}.keys").function(variables -> {
            ValueTypeNbt.ValueNbt value = variables.getValue(0, ValueTypes.NBT);
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyNbtKeys(value.getRawValue()));
        }).build());
        NBT_COMPOUND_HASKEY = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.BOOLEAN).operatorName("compound_haskey").symbol("NBT{}.has_key").function(OperatorBuilders.FUNCTION_NBT_COMPOUND_ENTRY_TO_BOOLEAN.build(Optional::isPresent)).build());
        NBT_COMPOUND_VALUE_TYPE = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.STRING).operatorName("compound_type").symbol("NBT{}.type").function(OperatorBuilders.FUNCTION_NBT_COMPOUND_ENTRY_TO_STRING.build(tag -> {
            if (tag.isPresent()) {
                try {
                    return NBTTypes.func_229710_a_((int)((INBT)tag.get()).func_74732_a()).func_225648_a_();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return "null";
        })).build());
        NBT_COMPOUND_VALUE_TAG = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.NBT).operatorName("compound_value_tag").symbol("NBT{}.get_tag").function(OperatorBuilders.FUNCTION_NBT_COMPOUND_ENTRY_TO_NBT.build(o -> o)).build());
        NBT_COMPOUND_VALUE_BOOLEAN = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.BOOLEAN).operatorName("compound_value_boolean").symbol("NBT{}.get_boolean").function(OperatorBuilders.FUNCTION_NBT_COMPOUND_ENTRY_TO_BOOLEAN.build(o -> o.map(tag -> tag instanceof NumberNBT && ((NumberNBT)tag).func_150290_f() != 0).orElse(false))).build());
        NBT_COMPOUND_VALUE_INTEGER = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.INTEGER).operatorName("compound_value_integer").symbol("NBT{}.get_integer").function(OperatorBuilders.FUNCTION_NBT_COMPOUND_ENTRY_TO_INT.build(o -> o.map(tag -> tag instanceof NumberNBT ? ((NumberNBT)tag).func_150287_d() : 0).orElse(0))).build());
        NBT_COMPOUND_VALUE_LONG = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.LONG).operatorName("compound_value_long").symbol("NBT{}.get_long").function(OperatorBuilders.FUNCTION_NBT_COMPOUND_ENTRY_TO_LONG.build(o -> o.map(tag -> tag instanceof NumberNBT ? ((NumberNBT)tag).func_150291_c() : 0L).orElse(0L))).build());
        NBT_COMPOUND_VALUE_DOUBLE = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.DOUBLE).operatorName("compound_value_double").symbol("NBT{}.get_double").function(OperatorBuilders.FUNCTION_NBT_COMPOUND_ENTRY_TO_DOUBLE.build(o -> o.map(tag -> tag instanceof NumberNBT ? ((NumberNBT)tag).func_150286_g() : 0.0).orElse(0.0))).build());
        NBT_COMPOUND_VALUE_STRING = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.STRING).operatorName("compound_value_string").symbol("NBT{}.get_string").function(OperatorBuilders.FUNCTION_NBT_COMPOUND_ENTRY_TO_STRING.build(o -> o.map(tag -> tag instanceof StringNBT ? tag.func_150285_a_() : "").orElse(""))).build());
        NBT_COMPOUND_VALUE_COMPOUND = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.NBT).operatorName("compound_value_compound").symbol("NBT{}.get_compound").function(OperatorBuilders.FUNCTION_NBT_COMPOUND_ENTRY_TO_NBT.build(o -> o.map(tag -> tag instanceof CompoundNBT ? (CompoundNBT)tag : new CompoundNBT()))).build());
        NBT_COMPOUND_VALUE_LIST_TAG = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.LIST).operatorName("compound_value_list_tag").symbol("NBT{}.get_list_tag").function(variables -> {
            ValueTypeNbt.ValueNbt value = variables.getValue(0, ValueTypes.NBT);
            ValueTypeString.ValueString key = variables.getValue(1, ValueTypes.STRING);
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyNbtValueListTag(key.getRawValue(), value.getRawValue()));
        }).build());
        NBT_COMPOUND_VALUE_LIST_BYTE = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.LIST).operatorName("compound_value_list_byte").symbol("NBT{}.get_list_byte").function(variables -> {
            ValueTypeNbt.ValueNbt value = variables.getValue(0, ValueTypes.NBT);
            ValueTypeString.ValueString key = variables.getValue(1, ValueTypes.STRING);
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyNbtValueListByte(key.getRawValue(), value.getRawValue()));
        }).build());
        NBT_COMPOUND_VALUE_LIST_INT = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.LIST).operatorName("compound_value_list_int").symbol("NBT{}.get_list_int").function(variables -> {
            ValueTypeNbt.ValueNbt value = variables.getValue(0, ValueTypes.NBT);
            ValueTypeString.ValueString key = variables.getValue(1, ValueTypes.STRING);
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyNbtValueListInt(key.getRawValue(), value.getRawValue()));
        }).build());
        NBT_COMPOUND_VALUE_LIST_LONG = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.LIST).operatorName("compound_value_list_long").symbol("NBT{}.get_list_long").function(variables -> {
            ValueTypeNbt.ValueNbt value = variables.getValue(0, ValueTypes.NBT);
            ValueTypeString.ValueString key = variables.getValue(1, ValueTypes.STRING);
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyNbtValueListLong(key.getRawValue(), value.getRawValue()));
        }).build());
        NBT_COMPOUND_WITHOUT = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.NBT).operatorName("compound_without").symbol("NBT{}.without").function(variables -> {
            ValueTypeNbt.ValueNbt valueNbt = variables.getValue(0, ValueTypes.NBT);
            Optional tag = valueNbt.getRawValue();
            if (tag.isPresent()) {
                if (!(tag.get() instanceof CompoundNBT)) {
                    return ValueTypeNbt.ValueNbt.of();
                }
                ValueTypeString.ValueString valueString = variables.getValue(1, ValueTypes.STRING);
                String key = valueString.getRawValue();
                CompoundNBT tagCompound = (CompoundNBT)tag.get();
                if (tagCompound.func_74764_b(key)) {
                    tagCompound = tagCompound.func_74737_b();
                    tagCompound.func_82580_o(key);
                }
                return ValueTypeNbt.ValueNbt.of((INBT)tagCompound);
            }
            return valueNbt;
        }).build());
        NBT_COMPOUND_WITH_BOOLEAN = REGISTRY.register(OperatorBuilders.NBT_3.renderPattern(IConfigRenderPattern.INFIX_2_VERYLONG).inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.BOOLEAN).operatorName("compound_with_boolean").symbol("NBT{}.with_boolean").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(input -> {
            ValueTypeBoolean.ValueBoolean value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.BOOLEAN);
            ((Optional)input.getLeft()).ifPresent(tag -> tag.func_74757_a((String)input.getMiddle(), value.getRawValue()));
            return (Optional)input.getLeft();
        })).build());
        NBT_COMPOUND_WITH_SHORT = REGISTRY.register(OperatorBuilders.NBT_3.inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.INTEGER).operatorName("compound_with_short").symbol("NBT{}.with_short").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(input -> {
            ValueTypeInteger.ValueInteger value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.INTEGER);
            ((Optional)input.getLeft()).ifPresent(tag -> tag.func_74777_a((String)input.getMiddle(), (short)value.getRawValue()));
            return (Optional)input.getLeft();
        })).build());
        NBT_COMPOUND_WITH_INTEGER = REGISTRY.register(OperatorBuilders.NBT_3.inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.INTEGER).operatorName("compound_with_integer").symbol("NBT{}.with_integer").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(input -> {
            ValueTypeInteger.ValueInteger value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.INTEGER);
            ((Optional)input.getLeft()).ifPresent(tag -> tag.func_74768_a((String)input.getMiddle(), value.getRawValue()));
            return (Optional)input.getLeft();
        })).build());
        NBT_COMPOUND_WITH_LONG = REGISTRY.register(OperatorBuilders.NBT_3.inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.LONG).operatorName("compound_with_long").symbol("NBT{}.with_long").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(input -> {
            ValueTypeLong.ValueLong value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.LONG);
            ((Optional)input.getLeft()).ifPresent(tag -> tag.func_74772_a((String)input.getMiddle(), value.getRawValue()));
            return (Optional)input.getLeft();
        })).build());
        NBT_COMPOUND_WITH_DOUBLE = REGISTRY.register(OperatorBuilders.NBT_3.inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.DOUBLE).operatorName("compound_with_double").symbol("NBT{}.with_double").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(input -> {
            ValueTypeDouble.ValueDouble value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.DOUBLE);
            ((Optional)input.getLeft()).ifPresent(tag -> tag.func_74780_a((String)input.getMiddle(), value.getRawValue()));
            return (Optional)input.getLeft();
        })).build());
        NBT_COMPOUND_WITH_FLOAT = REGISTRY.register(OperatorBuilders.NBT_3.inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.DOUBLE).operatorName("compound_with_float").symbol("NBT{}.with_float").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(input -> {
            ValueTypeDouble.ValueDouble value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.DOUBLE);
            ((Optional)input.getLeft()).ifPresent(tag -> tag.func_74776_a((String)input.getMiddle(), (float)value.getRawValue()));
            return (Optional)input.getLeft();
        })).build());
        NBT_COMPOUND_WITH_STRING = REGISTRY.register(OperatorBuilders.NBT_3.inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.STRING).operatorName("compound_with_string").symbol("NBT{}.with_string").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(input -> {
            ValueTypeString.ValueString value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.STRING);
            ((Optional)input.getLeft()).ifPresent(tag -> tag.func_74778_a((String)input.getMiddle(), value.getRawValue()));
            return (Optional)input.getLeft();
        })).build());
        NBT_COMPOUND_WITH_COMPOUND = REGISTRY.register(OperatorBuilders.NBT_3.inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.NBT).operatorName("compound_with_tag").symbol("NBT{}.with_tag").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(input -> {
            ValueTypeNbt.ValueNbt value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.NBT);
            ((Optional)input.getLeft()).ifPresent(tag -> value.getRawValue().ifPresent(v -> tag.func_218657_a((String)input.getMiddle(), v)));
            return (Optional)input.getLeft();
        })).build());
        NBT_COMPOUND_WITH_LIST_TAG = REGISTRY.register(OperatorBuilders.NBT_3.renderPattern(IConfigRenderPattern.INFIX_2_VERYLONG).inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.LIST).operatorName("compound_with_list_tag").symbol("NBT{}.with_tag_list").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(new IOperatorValuePropagator<Triple<Optional<CompoundNBT>, String, OperatorBase.SafeVariablesGetter>, Optional<CompoundNBT>>(){

            @Override
            public Optional<CompoundNBT> getOutput(Triple<Optional<CompoundNBT>, String, OperatorBase.SafeVariablesGetter> input) throws EvaluationException {
                ValueTypeList.ValueList value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.LIST);
                ((Optional)input.getLeft()).ifPresent(tag -> tag.func_218657_a((String)input.getMiddle(), (INBT)NbtHelpers.getListNbtTag(value, (ITextComponent)NBT_COMPOUND_WITH_LIST_TAG.getLocalizedNameFull())));
                return (Optional)input.getLeft();
            }
        })).build());
        NBT_COMPOUND_WITH_LIST_BYTE = REGISTRY.register(OperatorBuilders.NBT_3.renderPattern(IConfigRenderPattern.INFIX_2_VERYLONG).inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.LIST).operatorName("compound_with_list_byte").symbol("NBT{}.with_byte_list").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(new IOperatorValuePropagator<Triple<Optional<CompoundNBT>, String, OperatorBase.SafeVariablesGetter>, Optional<CompoundNBT>>(){

            @Override
            public Optional<CompoundNBT> getOutput(Triple<Optional<CompoundNBT>, String, OperatorBase.SafeVariablesGetter> input) throws EvaluationException {
                ValueTypeList.ValueList value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.LIST);
                ((Optional)input.getLeft()).ifPresent(tag -> tag.func_218657_a((String)input.getMiddle(), (INBT)NbtHelpers.getListNbtByte(value, (ITextComponent)NBT_COMPOUND_WITH_LIST_BYTE.getLocalizedNameFull())));
                return (Optional)input.getLeft();
            }
        })).build());
        NBT_COMPOUND_WITH_LIST_INT = REGISTRY.register(OperatorBuilders.NBT_3.renderPattern(IConfigRenderPattern.INFIX_2_VERYLONG).inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.LIST).operatorName("compound_with_list_int").symbol("NBT{}.with_int_list").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(new IOperatorValuePropagator<Triple<Optional<CompoundNBT>, String, OperatorBase.SafeVariablesGetter>, Optional<CompoundNBT>>(){

            @Override
            public Optional<CompoundNBT> getOutput(Triple<Optional<CompoundNBT>, String, OperatorBase.SafeVariablesGetter> input) throws EvaluationException {
                ValueTypeList.ValueList value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.LIST);
                ((Optional)input.getLeft()).ifPresent(tag -> tag.func_218657_a((String)input.getMiddle(), (INBT)NbtHelpers.getListNbtInt(value, (ITextComponent)NBT_COMPOUND_WITH_LIST_INT.getLocalizedNameFull())));
                return (Optional)input.getLeft();
            }
        })).build());
        NBT_COMPOUND_WITH_LIST_LONG = REGISTRY.register(OperatorBuilders.NBT_3.renderPattern(IConfigRenderPattern.INFIX_2_VERYLONG).inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.LIST).operatorName("compound_with_list_long").symbol("NBT{}.with_list_long").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(new IOperatorValuePropagator<Triple<Optional<CompoundNBT>, String, OperatorBase.SafeVariablesGetter>, Optional<CompoundNBT>>(){

            @Override
            public Optional<CompoundNBT> getOutput(Triple<Optional<CompoundNBT>, String, OperatorBase.SafeVariablesGetter> input) throws EvaluationException {
                ValueTypeList.ValueList value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.LIST);
                ((Optional)input.getLeft()).ifPresent(tag -> tag.func_218657_a((String)input.getMiddle(), (INBT)NbtHelpers.getListNbtLong(value, (ITextComponent)NBT_COMPOUND_WITH_LIST_LONG.getLocalizedNameFull())));
                return (Optional)input.getLeft();
            }
        })).build());
        NBT_COMPOUND_SUBSET = REGISTRY.register(OperatorBuilders.NBT_2_NBT.output(ValueTypes.BOOLEAN).operatorName("compound_subset").symbol("NBT{}.\u2286").function(variables -> {
            ValueTypeNbt.ValueNbt valueNbt0 = variables.getValue(0, ValueTypes.NBT);
            ValueTypeNbt.ValueNbt valueNbt1 = variables.getValue(1, ValueTypes.NBT);
            if (valueNbt0.getRawValue().isPresent() && valueNbt1.getRawValue().isPresent() && valueNbt0.getRawValue().get() instanceof CompoundNBT && valueNbt1.getRawValue().get() instanceof CompoundNBT) {
                return ValueTypeBoolean.ValueBoolean.of(NbtHelpers.nbtMatchesSubset((CompoundNBT)valueNbt0.getRawValue().get(), (CompoundNBT)valueNbt1.getRawValue().get(), true));
            }
            return ValueTypeBoolean.ValueBoolean.of(false);
        }).build());
        NBT_COMPOUND_UNION = REGISTRY.register(OperatorBuilders.NBT_2_NBT.output(ValueTypes.NBT).operatorName("compound_union").symbol("NBT{}.\u222a").function(variables -> {
            ValueTypeNbt.ValueNbt valueNbt0 = variables.getValue(0, ValueTypes.NBT);
            ValueTypeNbt.ValueNbt valueNbt1 = variables.getValue(1, ValueTypes.NBT);
            if (valueNbt0.getRawValue().isPresent() && valueNbt1.getRawValue().isPresent() && valueNbt0.getRawValue().get() instanceof CompoundNBT && valueNbt1.getRawValue().get() instanceof CompoundNBT) {
                return ValueTypeNbt.ValueNbt.of((INBT)NbtHelpers.union((CompoundNBT)valueNbt0.getRawValue().get(), (CompoundNBT)valueNbt1.getRawValue().get()));
            }
            return ValueTypeNbt.ValueNbt.of();
        }).build());
        NBT_COMPOUND_INTERSECTION = REGISTRY.register(OperatorBuilders.NBT_2_NBT.output(ValueTypes.NBT).operatorName("compound_intersection").symbol("NBT{}.\u2229").function(variables -> {
            ValueTypeNbt.ValueNbt valueNbt0 = variables.getValue(0, ValueTypes.NBT);
            ValueTypeNbt.ValueNbt valueNbt1 = variables.getValue(1, ValueTypes.NBT);
            if (valueNbt0.getRawValue().isPresent() && valueNbt1.getRawValue().isPresent() && valueNbt0.getRawValue().get() instanceof CompoundNBT && valueNbt1.getRawValue().get() instanceof CompoundNBT) {
                return ValueTypeNbt.ValueNbt.of((INBT)NbtHelpers.intersection((CompoundNBT)valueNbt0.getRawValue().get(), (CompoundNBT)valueNbt1.getRawValue().get()));
            }
            return ValueTypeNbt.ValueNbt.of();
        }).build());
        NBT_COMPOUND_MINUS = REGISTRY.register(OperatorBuilders.NBT_2_NBT.output(ValueTypes.NBT).operatorName("compound_minus").symbol("NBT{}.\u2216").function(variables -> {
            ValueTypeNbt.ValueNbt valueNbt0 = variables.getValue(0, ValueTypes.NBT);
            ValueTypeNbt.ValueNbt valueNbt1 = variables.getValue(1, ValueTypes.NBT);
            if (valueNbt0.getRawValue().isPresent() && valueNbt1.getRawValue().isPresent() && valueNbt0.getRawValue().get() instanceof CompoundNBT && valueNbt1.getRawValue().get() instanceof CompoundNBT) {
                return ValueTypeNbt.ValueNbt.of((INBT)NbtHelpers.minus((CompoundNBT)valueNbt0.getRawValue().get(), (CompoundNBT)valueNbt1.getRawValue().get()));
            }
            return ValueTypeNbt.ValueNbt.of();
        }).build());
        NBT_AS_BOOLEAN = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).operatorName("as_boolean").symbol("NBT.as_boolean").function(OperatorBuilders.FUNCTION_NBT_TO_BOOLEAN.build(o -> o.map(tag -> tag instanceof ByteNBT && ((ByteNBT)tag).func_150290_f() != 0).orElse(false))).build());
        NBT_AS_BYTE = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.INTEGER).operatorName("as_byte").symbol("NBT.as_byte").function(OperatorBuilders.FUNCTION_NBT_TO_INT.build(o -> o.map(tag -> tag instanceof NumberNBT ? ((NumberNBT)tag).func_150287_d() : 0).orElse(0))).build());
        NBT_AS_SHORT = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.INTEGER).operatorName("as_short").symbol("NBT.as_short").function(OperatorBuilders.FUNCTION_NBT_TO_INT.build(o -> o.map(tag -> tag instanceof NumberNBT ? ((NumberNBT)tag).func_150287_d() : 0).orElse(0))).build());
        NBT_AS_INT = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.INTEGER).operatorName("as_int").symbol("NBT.as_int").function(OperatorBuilders.FUNCTION_NBT_TO_INT.build(o -> o.map(tag -> tag instanceof NumberNBT ? ((NumberNBT)tag).func_150287_d() : 0).orElse(0))).build());
        NBT_AS_LONG = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.LONG).operatorName("as_long").symbol("NBT.as_long").function(OperatorBuilders.FUNCTION_NBT_TO_LONG.build(o -> o.map(tag -> tag instanceof NumberNBT ? ((NumberNBT)tag).func_150291_c() : 0L).orElse(0L))).build());
        NBT_AS_DOUBLE = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.DOUBLE).operatorName("as_double").symbol("NBT.as_double").function(OperatorBuilders.FUNCTION_NBT_TO_DOUBLE.build(o -> o.map(tag -> tag instanceof NumberNBT ? ((NumberNBT)tag).func_150286_g() : 0.0).orElse(0.0))).build());
        NBT_AS_FLOAT = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.DOUBLE).operatorName("as_float").symbol("NBT.as_float").function(OperatorBuilders.FUNCTION_NBT_TO_DOUBLE.build(o -> o.map(tag -> tag instanceof NumberNBT ? (double)((NumberNBT)tag).func_150288_h() : 0.0).orElse(0.0))).build());
        NBT_AS_STRING = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.STRING).operatorName("as_string").symbol("NBT.as_string").function(OperatorBuilders.FUNCTION_NBT_TO_STRING.build(o -> o.map(tag -> tag instanceof StringNBT ? ((StringNBT)tag).func_150285_a_() : "").orElse(""))).build());
        NBT_AS_TAG_LIST = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.LIST).operatorName("as_tag_list").symbol("NBT.as_tag_list").function(variables -> {
            ValueTypeNbt.ValueNbt value = variables.getValue(0, ValueTypes.NBT);
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyNbtAsListTag(value.getRawValue()));
        }).build());
        NBT_AS_BYTE_LIST = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.LIST).operatorName("as_byte_list").symbol("NBT.as_byte_list").function(variables -> {
            ValueTypeNbt.ValueNbt value = variables.getValue(0, ValueTypes.NBT);
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyNbtAsListByte(value.getRawValue()));
        }).build());
        NBT_AS_INT_LIST = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.LIST).operatorName("as_int_list").symbol("NBT.as_int_list").function(variables -> {
            ValueTypeNbt.ValueNbt value = variables.getValue(0, ValueTypes.NBT);
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyNbtAsListInt(value.getRawValue()));
        }).build());
        NBT_AS_LONG_LIST = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.LIST).operatorName("as_long_list").symbol("NBT.as_long_list").function(variables -> {
            ValueTypeNbt.ValueNbt value = variables.getValue(0, ValueTypes.NBT);
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyNbtAsListLong(value.getRawValue()));
        }).build());
        NBT_FROM_BOOLEAN = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.BOOLEAN).output(ValueTypes.NBT).operatorName("from_boolean").symbol("NBT.from_boolean").function(variables -> {
            ValueTypeBoolean.ValueBoolean value = variables.getValue(0, ValueTypes.BOOLEAN);
            return ValueTypeNbt.ValueNbt.of((INBT)ByteNBT.func_229672_a_((boolean)value.getRawValue()));
        }).build());
        NBT_FROM_SHORT = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.INTEGER).output(ValueTypes.NBT).operatorName("from_short").symbol("NBT.from_short").function(variables -> {
            ValueTypeInteger.ValueInteger value = variables.getValue(0, ValueTypes.INTEGER);
            return ValueTypeNbt.ValueNbt.of((INBT)ShortNBT.func_229701_a_((short)((short)value.getRawValue())));
        }).build());
        NBT_FROM_BYTE = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.INTEGER).output(ValueTypes.NBT).operatorName("from_byte").symbol("NBT.from_byte").function(variables -> {
            ValueTypeInteger.ValueInteger value = variables.getValue(0, ValueTypes.INTEGER);
            return ValueTypeNbt.ValueNbt.of((INBT)ByteNBT.func_229671_a_((byte)((byte)value.getRawValue())));
        }).build());
        NBT_FROM_INT = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.INTEGER).output(ValueTypes.NBT).operatorName("from_int").symbol("NBT.from_int").function(variables -> {
            ValueTypeInteger.ValueInteger value = variables.getValue(0, ValueTypes.INTEGER);
            return ValueTypeNbt.ValueNbt.of((INBT)IntNBT.func_229692_a_((int)value.getRawValue()));
        }).build());
        NBT_FROM_LONG = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.LONG).output(ValueTypes.NBT).operatorName("from_long").symbol("NBT.from_long").function(variables -> {
            ValueTypeLong.ValueLong value = variables.getValue(0, ValueTypes.LONG);
            return ValueTypeNbt.ValueNbt.of((INBT)LongNBT.func_229698_a_((long)value.getRawValue()));
        }).build());
        NBT_FROM_DOUBLE = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.DOUBLE).output(ValueTypes.NBT).operatorName("from_double").symbol("NBT.from_double").function(variables -> {
            ValueTypeDouble.ValueDouble value = variables.getValue(0, ValueTypes.DOUBLE);
            return ValueTypeNbt.ValueNbt.of((INBT)DoubleNBT.func_229684_a_((double)value.getRawValue()));
        }).build());
        NBT_FROM_FLOAT = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.DOUBLE).output(ValueTypes.NBT).operatorName("from_float").symbol("NBT.from_float").function(variables -> {
            ValueTypeDouble.ValueDouble value = variables.getValue(0, ValueTypes.DOUBLE);
            return ValueTypeNbt.ValueNbt.of((INBT)FloatNBT.func_229689_a_((float)((float)value.getRawValue())));
        }).build());
        NBT_FROM_STRING = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.STRING).output(ValueTypes.NBT).operatorName("from_string").symbol("NBT.from_string").function(variables -> {
            ValueTypeString.ValueString value = variables.getValue(0, ValueTypes.STRING);
            return ValueTypeNbt.ValueNbt.of((INBT)StringNBT.func_229705_a_((String)value.getRawValue()));
        }).build());
        NBT_FROM_TAG_LIST = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.LIST).output(ValueTypes.NBT).operatorName("from_tag_list").symbol("NBT.from_tag_list").function(new OperatorBase.IFunction(){

            @Override
            public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
                ValueTypeList.ValueList value = variables.getValue(0, ValueTypes.LIST);
                return ValueTypeNbt.ValueNbt.of((INBT)NbtHelpers.getListNbtTag(value, (ITextComponent)NBT_FROM_TAG_LIST.getLocalizedNameFull()));
            }
        }).build());
        NBT_FROM_BYTE_LIST = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.LIST).output(ValueTypes.NBT).operatorName("from_byte_list").symbol("NBT.from_byte_list").function(new OperatorBase.IFunction(){

            @Override
            public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
                ValueTypeList.ValueList value = variables.getValue(0, ValueTypes.LIST);
                return ValueTypeNbt.ValueNbt.of((INBT)NbtHelpers.getListNbtByte(value, (ITextComponent)NBT_FROM_BYTE_LIST.getLocalizedNameFull()));
            }
        }).build());
        NBT_FROM_INT_LIST = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.LIST).output(ValueTypes.NBT).operatorName("from_int_list").symbol("NBT.from_int_list").function(new OperatorBase.IFunction(){

            @Override
            public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
                ValueTypeList.ValueList value = variables.getValue(0, ValueTypes.LIST);
                return ValueTypeNbt.ValueNbt.of((INBT)NbtHelpers.getListNbtInt(value, (ITextComponent)NBT_FROM_INT_LIST.getLocalizedNameFull()));
            }
        }).build());
        NBT_FROM_LONG_LIST = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.LIST).output(ValueTypes.NBT).operatorName("from_long_list").symbol("NBT.from_long_list").function(new OperatorBase.IFunction(){

            @Override
            public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
                ValueTypeList.ValueList value = variables.getValue(0, ValueTypes.LIST);
                return ValueTypeNbt.ValueNbt.of((INBT)NbtHelpers.getListNbtLong(value, (ITextComponent)NBT_FROM_LONG_LIST.getLocalizedNameFull()));
            }
        }).build());
        NBT_PATH_MATCH_FIRST = REGISTRY.register(OperatorBuilders.NBT_2.inputTypes(ValueTypes.STRING, ValueTypes.NBT).output(ValueTypes.NBT).operatorName("path_match_first").symbol("NBT.path_match_first").function(variables -> {
            ValueTypeString.ValueString string = variables.getValue(0, ValueTypes.STRING);
            ValueTypeNbt.ValueNbt nbt = variables.getValue(1, ValueTypes.NBT);
            INbtPathExpression expression = null;
            try {
                expression = NbtPath.parse((String)string.getRawValue());
            }
            catch (NbtParseException e) {
                throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.operator_nbt_path_expression", new Object[]{string.getRawValue(), e.getMessage()}));
            }
            if (!nbt.getRawValue().isPresent()) {
                return ValueTypeNbt.ValueNbt.of();
            }
            return ValueTypeNbt.ValueNbt.of(expression.match((INBT)nbt.getRawValue().get()).getMatches().findAny());
        }).build());
        NBT_PATH_MATCH_ALL = REGISTRY.register(OperatorBuilders.NBT_2.inputTypes(ValueTypes.STRING, ValueTypes.NBT).output(ValueTypes.LIST).operatorName("path_match_all").symbol("NBT.path_match_all").function(variables -> {
            ValueTypeString.ValueString string = variables.getValue(0, ValueTypes.STRING);
            ValueTypeNbt.ValueNbt nbt = variables.getValue(1, ValueTypes.NBT);
            INbtPathExpression expression = null;
            try {
                expression = NbtPath.parse((String)string.getRawValue());
            }
            catch (NbtParseException e) {
                throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.operator_nbt_path_expression", new Object[]{string.getRawValue(), e.getMessage()}));
            }
            if (!nbt.getRawValue().isPresent()) {
                return ValueTypeList.ValueList.ofAll((IValueType)ValueTypes.NBT, (IValue[])new IValue[0]);
            }
            List matches = expression.match((INBT)nbt.getRawValue().get()).getMatches().map(ValueTypeNbt.ValueNbt::of).collect(Collectors.toList());
            return ValueTypeList.ValueList.ofList(ValueTypes.NBT, matches);
        }).build());
        NBT_PATH_TEST = REGISTRY.register(OperatorBuilders.NBT_2.inputTypes(ValueTypes.STRING, ValueTypes.NBT).output(ValueTypes.BOOLEAN).operatorName("path_test").symbol("NBT.path_test").function(variables -> {
            ValueTypeString.ValueString string = variables.getValue(0, ValueTypes.STRING);
            ValueTypeNbt.ValueNbt nbt = variables.getValue(1, ValueTypes.NBT);
            INbtPathExpression expression = null;
            try {
                expression = NbtPath.parse((String)string.getRawValue());
            }
            catch (NbtParseException e) {
                throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.operator_nbt_path_expression", new Object[]{string.getRawValue(), e.getMessage()}));
            }
            if (!nbt.getRawValue().isPresent()) {
                return ValueTypeBoolean.ValueBoolean.of(false);
            }
            return ValueTypeBoolean.ValueBoolean.of(expression.test((INBT)nbt.getRawValue().get()));
        }).build());
        INGREDIENTS_ITEMS = REGISTRY.register(OperatorBuilders.INGREDIENTS_1_PREFIX_LONG.output(ValueTypes.LIST).operatorName("items").symbol("Ingr.items").function(OperatorBuilders.createFunctionIngredientsList(() -> IngredientComponent.ITEMSTACK)).build());
        INGREDIENTS_FLUIDS = REGISTRY.register(OperatorBuilders.INGREDIENTS_1_PREFIX_LONG.output(ValueTypes.LIST).operatorName("fluids").symbol("Ingr.fluids").function(OperatorBuilders.createFunctionIngredientsList(() -> IngredientComponent.FLUIDSTACK)).build());
        INGREDIENTS_ENERGIES = REGISTRY.register(OperatorBuilders.INGREDIENTS_1_PREFIX_LONG.output(ValueTypes.LIST).operatorName("energies").symbol("Ingr.energies").function(OperatorBuilders.createFunctionIngredientsList(() -> IngredientComponent.ENERGY)).build());
        INGREDIENTS_WITH_ITEM = REGISTRY.register(OperatorBuilders.INGREDIENTS_3_ITEMSTACK.operatorName("with_item").symbol("Ingr.with_item").function(variables -> {
            ValueObjectTypeIngredients.ValueIngredients value = variables.getValue(0, ValueTypes.OBJECT_INGREDIENTS);
            ValueTypeInteger.ValueInteger index = variables.getValue(1, ValueTypes.INTEGER);
            ValueObjectTypeItemStack.ValueItemStack itemStack = variables.getValue(2, ValueTypes.OBJECT_ITEMSTACK);
            if (!value.getRawValue().isPresent()) {
                return value;
            }
            IMixedIngredients baseIngredients = (IMixedIngredients)value.getRawValue().get();
            return ValueObjectTypeIngredients.ValueIngredients.of(new ExtendedIngredientsSingle(baseIngredients, index.getRawValue(), IngredientComponent.ITEMSTACK, itemStack.getRawValue()));
        }).build());
        INGREDIENTS_WITH_FLUID = REGISTRY.register(OperatorBuilders.INGREDIENTS_3_FLUIDSTACK.operatorName("with_fluid").symbol("Ingr.with_fluid").function(variables -> {
            ValueObjectTypeIngredients.ValueIngredients value = variables.getValue(0, ValueTypes.OBJECT_INGREDIENTS);
            ValueTypeInteger.ValueInteger index = variables.getValue(1, ValueTypes.INTEGER);
            ValueObjectTypeFluidStack.ValueFluidStack fluidStack = variables.getValue(2, ValueTypes.OBJECT_FLUIDSTACK);
            if (!value.getRawValue().isPresent()) {
                return value;
            }
            IMixedIngredients baseIngredients = (IMixedIngredients)value.getRawValue().get();
            return ValueObjectTypeIngredients.ValueIngredients.of(new ExtendedIngredientsSingle(baseIngredients, index.getRawValue(), IngredientComponent.FLUIDSTACK, fluidStack.getRawValue()));
        }).build());
        INGREDIENTS_WITH_ENERGY = REGISTRY.register(OperatorBuilders.INGREDIENTS_3_INTEGER.operatorName("with_energy").symbol("Ingr.with_energy").function(variables -> {
            ValueObjectTypeIngredients.ValueIngredients value = variables.getValue(0, ValueTypes.OBJECT_INGREDIENTS);
            ValueTypeInteger.ValueInteger index = variables.getValue(1, ValueTypes.INTEGER);
            ValueTypeInteger.ValueInteger energy = variables.getValue(2, ValueTypes.INTEGER);
            if (!value.getRawValue().isPresent()) {
                return value;
            }
            IMixedIngredients baseIngredients = (IMixedIngredients)value.getRawValue().get();
            return ValueObjectTypeIngredients.ValueIngredients.of(new ExtendedIngredientsSingle(baseIngredients, index.getRawValue(), IngredientComponent.ENERGY, energy.getRawValue()));
        }).build());
        INGREDIENTS_WITH_ITEMS = REGISTRY.register(OperatorBuilders.INGREDIENTS_2_LIST.operatorName("with_items").symbol("Ingr.with_items").function(variables -> {
            ValueObjectTypeIngredients.ValueIngredients valueIngredients = variables.getValue(0, ValueTypes.OBJECT_INGREDIENTS);
            ValueTypeList.ValueList list = variables.getValue(1, ValueTypes.LIST);
            if (!valueIngredients.getRawValue().isPresent()) {
                return valueIngredients;
            }
            IMixedIngredients baseIngredients = (IMixedIngredients)valueIngredients.getRawValue().get();
            return ValueObjectTypeIngredients.ValueIngredients.of(new ExtendedIngredientsList(baseIngredients, IngredientComponent.ITEMSTACK, OperatorBuilders.unwrapIngredientComponentList(IngredientComponent.ITEMSTACK, list)));
        }).build());
        INGREDIENTS_WITH_FLUIDS = REGISTRY.register(OperatorBuilders.INGREDIENTS_2_LIST.operatorName("with_fluids").symbol("Ingr.with_fluids").function(variables -> {
            ValueObjectTypeIngredients.ValueIngredients valueIngredients = variables.getValue(0, ValueTypes.OBJECT_INGREDIENTS);
            ValueTypeList.ValueList list = variables.getValue(1, ValueTypes.LIST);
            if (!valueIngredients.getRawValue().isPresent()) {
                return valueIngredients;
            }
            IMixedIngredients baseIngredients = (IMixedIngredients)valueIngredients.getRawValue().get();
            return ValueObjectTypeIngredients.ValueIngredients.of(new ExtendedIngredientsList(baseIngredients, IngredientComponent.FLUIDSTACK, OperatorBuilders.unwrapIngredientComponentList(IngredientComponent.FLUIDSTACK, list)));
        }).build());
        INGREDIENTS_WITH_ENERGIES = REGISTRY.register(OperatorBuilders.INGREDIENTS_2_LIST.renderPattern(IConfigRenderPattern.INFIX_VERYLONG).operatorName("with_energies").symbol("Ingr.with_energies").function(variables -> {
            ValueObjectTypeIngredients.ValueIngredients valueIngredients = variables.getValue(0, ValueTypes.OBJECT_INGREDIENTS);
            ValueTypeList.ValueList list = variables.getValue(1, ValueTypes.LIST);
            if (!valueIngredients.getRawValue().isPresent()) {
                return valueIngredients;
            }
            IMixedIngredients baseIngredients = (IMixedIngredients)valueIngredients.getRawValue().get();
            return ValueObjectTypeIngredients.ValueIngredients.of(new ExtendedIngredientsList(baseIngredients, IngredientComponent.ENERGY, OperatorBuilders.unwrapIngredientComponentList(IngredientComponent.ENERGY, list)));
        }).build());
        RECIPE_INPUT = REGISTRY.register(OperatorBuilders.RECIPE_1_SUFFIX_LONG.output(ValueTypes.OBJECT_INGREDIENTS).operatorName("input").symbol("recipe_in").function(variables -> {
            ValueObjectTypeRecipe.ValueRecipe value = variables.getValue(0, ValueTypes.OBJECT_RECIPE);
            if (value.getRawValue().isPresent()) {
                return ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)MixedIngredients.fromRecipeInput((IRecipeDefinition)((IRecipeDefinition)value.getRawValue().get())));
            }
            return ValueObjectTypeIngredients.ValueIngredients.of(null);
        }).build());
        RECIPE_OUTPUT = REGISTRY.register(OperatorBuilders.RECIPE_1_SUFFIX_LONG.output(ValueTypes.OBJECT_INGREDIENTS).operatorName("output").symbol("recipe_out").function(variables -> {
            ValueObjectTypeRecipe.ValueRecipe value = variables.getValue(0, ValueTypes.OBJECT_RECIPE);
            if (value.getRawValue().isPresent()) {
                return ValueObjectTypeIngredients.ValueIngredients.of(((IRecipeDefinition)value.getRawValue().get()).getOutput());
            }
            return ValueObjectTypeIngredients.ValueIngredients.of(null);
        }).build());
        RECIPE_WITH_INPUT = REGISTRY.register(OperatorBuilders.RECIPE_2_INFIX.output(ValueTypes.OBJECT_RECIPE).operatorName("with_input").symbol("Recipe.with_in").function(variables -> {
            ValueObjectTypeRecipe.ValueRecipe valueRecipe = variables.getValue(0, ValueTypes.OBJECT_RECIPE);
            ValueObjectTypeIngredients.ValueIngredients valueIngredients = variables.getValue(1, ValueTypes.OBJECT_INGREDIENTS);
            if (valueRecipe.getRawValue().isPresent() && valueIngredients.getRawValue().isPresent()) {
                IMixedIngredients ingredients = (IMixedIngredients)valueIngredients.getRawValue().get();
                IdentityHashMap inputs = Maps.newIdentityHashMap();
                for (IngredientComponent component : ingredients.getComponents()) {
                    IIngredientMatcher matcher = component.getMatcher();
                    inputs.put(component, ingredients.getInstances(component).stream().map(instance -> new PrototypedIngredientAlternativesList(Collections.singletonList(new PrototypedIngredient(component, instance, matcher.getExactMatchCondition())))).collect(Collectors.toList()));
                }
                return ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)new RecipeDefinition((Map)inputs, ((IRecipeDefinition)valueRecipe.getRawValue().get()).getOutput()));
            }
            return ValueObjectTypeRecipe.ValueRecipe.of(null);
        }).build());
        RECIPE_WITH_OUTPUT = REGISTRY.register(OperatorBuilders.RECIPE_2_INFIX.output(ValueTypes.OBJECT_RECIPE).operatorName("with_output").symbol("Recipe.with_out").function(variables -> {
            ValueObjectTypeRecipe.ValueRecipe valueRecipe = variables.getValue(0, ValueTypes.OBJECT_RECIPE);
            ValueObjectTypeIngredients.ValueIngredients valueIngredients = variables.getValue(1, ValueTypes.OBJECT_INGREDIENTS);
            if (valueRecipe.getRawValue().isPresent() && valueIngredients.getRawValue().isPresent()) {
                IRecipeDefinition recipe = (IRecipeDefinition)valueRecipe.getRawValue().get();
                IdentityHashMap inputs = Maps.newIdentityHashMap();
                for (IngredientComponent component : recipe.getInputComponents()) {
                    inputs.put(component, recipe.getInputs(component));
                }
                return ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)new RecipeDefinition((Map)inputs, (IMixedIngredients)valueIngredients.getRawValue().get()));
            }
            return ValueObjectTypeRecipe.ValueRecipe.of(null);
        }).build());
        RECIPE_WITH_INPUT_OUTPUT = REGISTRY.register(OperatorBuilders.RECIPE_2_PREFIX.output(ValueTypes.OBJECT_RECIPE).operatorName("with_input_output").symbol("Recipe.with_io").function(variables -> {
            ValueObjectTypeIngredients.ValueIngredients valueIn = variables.getValue(0, ValueTypes.OBJECT_INGREDIENTS);
            ValueObjectTypeIngredients.ValueIngredients valueOut = variables.getValue(1, ValueTypes.OBJECT_INGREDIENTS);
            if (valueIn.getRawValue().isPresent() && valueOut.getRawValue().isPresent()) {
                IMixedIngredients ingredients = (IMixedIngredients)valueIn.getRawValue().get();
                IdentityHashMap inputs = Maps.newIdentityHashMap();
                for (IngredientComponent component : ingredients.getComponents()) {
                    IIngredientMatcher matcher = component.getMatcher();
                    inputs.put(component, ingredients.getInstances(component).stream().map(instance -> new PrototypedIngredientAlternativesList(Collections.singletonList(new PrototypedIngredient(component, instance, matcher.getExactMatchCondition())))).collect(Collectors.toList()));
                }
                return ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)new RecipeDefinition((Map)inputs, (IMixedIngredients)valueOut.getRawValue().get()));
            }
            return ValueObjectTypeRecipe.ValueRecipe.of(null);
        }).build());
        PARSE_BOOLEAN = REGISTRY.register(new ParseOperator(ValueTypes.BOOLEAN, v -> {
            ValueTypeString.ValueString value = v.getValue(0, ValueTypes.STRING);
            Pattern p = Pattern.compile("\\A(F(alse)?|[+-]?(0x|#)?0+|)\\z", 1);
            return ValueTypeBoolean.ValueBoolean.of(!p.matcher(value.getRawValue().trim()).matches());
        }));
        PARSE_DOUBLE = REGISTRY.register(new ParseOperator(ValueTypes.DOUBLE, v -> {
            ValueTypeString.ValueString value = v.getValue(0, ValueTypes.STRING);
            try {
                return ValueTypeDouble.ValueDouble.of(Double.parseDouble(value.getRawValue()));
            }
            catch (NumberFormatException e) {
                try {
                    Pattern p = Pattern.compile("\\A([+-]?)(Inf(inity)?|\u221e)\\z", 1);
                    vendors.com.google.re2j.Matcher m = p.matcher(value.getRawValue().trim());
                    if (m.matches()) {
                        if (m.group(1).equals("-")) {
                            return ValueTypeDouble.ValueDouble.of(Double.NEGATIVE_INFINITY);
                        }
                        return ValueTypeDouble.ValueDouble.of(Double.POSITIVE_INFINITY);
                    }
                    return ValueTypeDouble.ValueDouble.of(Long.decode(value.getRawValue()).longValue());
                }
                catch (NumberFormatException e2) {
                    throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.parse", new Object[]{value.getRawValue(), new TranslationTextComponent(ValueTypes.DOUBLE.getTranslationKey())}));
                }
            }
        }));
        PARSE_INTEGER = REGISTRY.register(new ParseOperator(ValueTypes.INTEGER, v -> {
            ValueTypeString.ValueString value = v.getValue(0, ValueTypes.STRING);
            try {
                return ValueTypeInteger.ValueInteger.of(Integer.decode(value.getRawValue()));
            }
            catch (NumberFormatException e) {
                throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.parse", new Object[]{value.getRawValue(), new TranslationTextComponent(ValueTypes.INTEGER.getTranslationKey())}));
            }
        }));
        PARSE_LONG = REGISTRY.register(new ParseOperator(ValueTypes.LONG, v -> {
            ValueTypeString.ValueString value = v.getValue(0, ValueTypes.STRING);
            try {
                return ValueTypeLong.ValueLong.of(Long.decode(value.getRawValue()));
            }
            catch (NumberFormatException e) {
                throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.parse", new Object[]{value.getRawValue(), new TranslationTextComponent(ValueTypes.LONG.getTranslationKey())}));
            }
        }));
        PARSE_NBT = REGISTRY.register(new ParseOperator(ValueTypes.NBT, v -> {
            ValueTypeString.ValueString value = v.getValue(0, ValueTypes.STRING);
            try {
                return ValueTypeNbt.ValueNbt.of((INBT)JsonToNBT.func_180713_a((String)value.getRawValue()));
            }
            catch (CommandSyntaxException e) {
                throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.parse", new Object[]{value.getRawValue(), new TranslationTextComponent(ValueTypes.NBT.getTranslationKey())}));
            }
        }));
        GENERAL_CHOICE = REGISTRY.register(new GeneralChoiceOperator("?", "choice"));
        GENERAL_IDENTITY = REGISTRY.register(new GeneralIdentityOperator("id", "identity"));
        GENERAL_CONSTANT = REGISTRY.register(new GeneralConstantOperator("K", "constant"));
    }
}

