/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentHandler;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueOptionalBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.ingredient.IngredientComponentHandlers;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElement;

public class ValueObjectTypeRecipe
extends ValueObjectTypeBase<ValueRecipe>
implements IValueTypeNamed<ValueRecipe>,
IValueTypeNullable<ValueRecipe> {
    public ValueObjectTypeRecipe() {
        super("recipe", ValueRecipe.class);
    }

    @Override
    public ValueRecipe getDefault() {
        return ValueRecipe.of(null);
    }

    @Override
    public IFormattableTextComponent toCompactString(ValueRecipe value) {
        if (value.getRawValue().isPresent()) {
            IRecipeDefinition recipe = (IRecipeDefinition)value.getRawValue().get();
            StringTextComponent sb = new StringTextComponent("");
            sb.func_230529_a_((ITextComponent)ValueObjectTypeIngredients.ingredientsToTextComponent(recipe.getOutput()));
            sb.func_230529_a_((ITextComponent)new StringTextComponent(" <- "));
            boolean first = true;
            for (IngredientComponent component : recipe.getInputComponents()) {
                IIngredientComponentHandler handler = IngredientComponentHandlers.REGISTRY.getComponentHandler(component);
                for (IPrototypedIngredientAlternatives instances : recipe.getInputs(component)) {
                    IPrototypedIngredient prototypedIngredient = (IPrototypedIngredient)Iterables.getFirst((Iterable)instances.getAlternatives(), null);
                    Object v = prototypedIngredient == null ? handler.getValueType().getDefault() : handler.toValue(prototypedIngredient.getPrototype());
                    if (!first) {
                        sb.func_230529_a_((ITextComponent)new StringTextComponent(", "));
                    } else {
                        first = false;
                    }
                    sb.func_230529_a_(handler.toCompactString(v));
                }
            }
            return sb;
        }
        return new StringTextComponent("");
    }

    @Override
    public INBT serialize(ValueRecipe value) {
        if (!value.getRawValue().isPresent()) {
            return new CompoundNBT();
        }
        return IRecipeDefinition.serialize((IRecipeDefinition)((IRecipeDefinition)value.getRawValue().get()));
    }

    @Override
    public ValueRecipe deserialize(INBT value) {
        if (value.func_74732_a() == 0 || value.func_74732_a() == 10 && ((CompoundNBT)value).isEmpty()) {
            return ValueRecipe.of(null);
        }
        try {
            return ValueRecipe.of((IRecipeDefinition)IRecipeDefinition.deserialize((CompoundNBT)((CompoundNBT)value)));
        }
        catch (IllegalArgumentException e) {
            return ValueRecipe.of(null);
        }
    }

    @Override
    public String getName(ValueRecipe a) {
        return this.toCompactString(a).getString();
    }

    @Override
    public boolean isNull(ValueRecipe a) {
        return !a.getRawValue().isPresent();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeRecipeLPElement();
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public IBakedModel getVariableItemOverrideModel(ValueRecipe value, IBakedModel model, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity livingEntity) {
        if (!MinecraftHelpers.isShifted()) {
            return null;
        }
        return value.getRawValue().map(recipe -> {
            List itemStacks = recipe.getOutput().getInstances(IngredientComponent.ITEMSTACK);
            if (!itemStacks.isEmpty()) {
                return Minecraft.func_71410_x().func_175599_af().func_184393_a((ItemStack)itemStacks.get(0), (World)world, livingEntity);
            }
            return null;
        }).orElse(null);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderISTER(ValueRecipe value, ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (MinecraftHelpers.isShifted()) {
            value.getRawValue().ifPresent(recipe -> {
                List itemStacks = recipe.getOutput().getInstances(IngredientComponent.ITEMSTACK);
                if (!itemStacks.isEmpty()) {
                    ItemStack actualStack = (ItemStack)itemStacks.get(0);
                    actualStack.func_77973_b().getItemStackTileEntityRenderer().func_239207_a_(actualStack, transformType, matrixStack, buffer, combinedLight, combinedOverlay);
                }
            });
        }
    }

    public static class ValueRecipe
    extends ValueOptionalBase<IRecipeDefinition> {
        private ValueRecipe(IRecipeDefinition recipe) {
            super(ValueTypes.OBJECT_RECIPE, recipe);
        }

        public static ValueRecipe of(IRecipeDefinition recipe) {
            return new ValueRecipe(recipe);
        }

        @Override
        protected boolean isEqual(IRecipeDefinition a, IRecipeDefinition b) {
            return a.equals(b);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeRecipe.ValueRecipe()";
        }
    }
}

