/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeUniquelyNamed;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeOperatorLPElement;

public class ValueTypeOperator
extends ValueTypeBase<ValueOperator>
implements IValueTypeNamed<ValueOperator>,
IValueTypeUniquelyNamed<ValueOperator> {
    private static final String SIGNATURE_LINK = "->";

    public ValueTypeOperator() {
        super("operator", Helpers.RGBToInt((int)43, (int)231, (int)47), TextFormatting.DARK_GREEN, ValueOperator.class);
    }

    @Override
    public ValueOperator getDefault() {
        return ValueOperator.of(Operators.GENERAL_IDENTITY);
    }

    @Override
    public IFormattableTextComponent toCompactString(ValueOperator value) {
        return value.getRawValue().getLocalizedNameFull();
    }

    @Override
    public INBT serialize(ValueOperator value) {
        return Operators.REGISTRY.serialize(value.getRawValue());
    }

    @Override
    public ValueOperator deserialize(INBT value) {
        IOperator operator;
        try {
            operator = Operators.REGISTRY.deserialize(value);
        }
        catch (EvaluationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (operator != null) {
            return ValueOperator.of(operator);
        }
        throw new IllegalArgumentException(String.format("Value \"%s\" could not be parsed to an operator.", value));
    }

    @Override
    public void loadTooltip(List<ITextComponent> lines, boolean appendOptionalInfo, @Nullable ValueOperator value) {
        super.loadTooltip(lines, appendOptionalInfo, value);
        if (value != null) {
            lines.add((ITextComponent)new TranslationTextComponent("valuetype.integrateddynamics.operator.tooltip.signature").func_230529_a_((ITextComponent)ValueTypeOperator.getSignature(value.getRawValue())));
        }
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeOperatorLPElement();
    }

    @Override
    public ValuePredicate<ValueOperator> deserializeValuePredicate(JsonObject element, @Nullable IValue value) {
        JsonElement jsonElement = element.get("operator");
        String operatorName = jsonElement != null && !jsonElement.isJsonNull() ? jsonElement.getAsString() : null;
        IOperator operator = null;
        if (operatorName != null) {
            try {
                operator = Operators.REGISTRY.getOperator(new ResourceLocation(operatorName));
            }
            catch (ResourceLocationException e) {
                throw new JsonSyntaxException("Invalid operator name '" + operator + "'");
            }
            if (operator == null) {
                throw new JsonSyntaxException("Could not find the operator '" + operator + "'");
            }
        }
        return new ValueOperatorPredicate(this, value, operator);
    }

    @Override
    public ValueOperator materialize(ValueOperator value) throws EvaluationException {
        return ValueOperator.of(value.getRawValue().materialize());
    }

    public static IFormattableTextComponent getSignature(IOperator operator) {
        return (IFormattableTextComponent)ValueTypeOperator.getSignatureLines(operator, false).stream().reduce(new StringTextComponent(""), (a, b) -> a.func_240702_b_(" ").func_230529_a_((ITextComponent)b));
    }

    public static ITextComponent getSignature(IValueType[] inputTypes, IValueType outputType) {
        return (ITextComponent)ValueTypeOperator.getSignatureLines(inputTypes, outputType, false).stream().reduce((prev, next) -> prev.func_240702_b_(" ").func_230529_a_((ITextComponent)next)).orElseGet(() -> new StringTextComponent(""));
    }

    protected static IFormattableTextComponent switchSignatureLineContext(List<IFormattableTextComponent> lines, IFormattableTextComponent sb) {
        lines.add(sb);
        return new StringTextComponent("");
    }

    public static List<IFormattableTextComponent> getSignatureLines(IValueType[] inputTypes, IValueType outputType, boolean indent) {
        ArrayList lines = Lists.newArrayList();
        StringTextComponent sb = new StringTextComponent("");
        boolean first = true;
        for (IValueType inputType : inputTypes) {
            if (first) {
                first = false;
            } else {
                sb = ValueTypeOperator.switchSignatureLineContext(lines, (IFormattableTextComponent)sb);
                sb.func_240702_b_((indent ? "  " : "") + SIGNATURE_LINK + " ");
            }
            sb.func_240699_a_(inputType.getDisplayColorFormat()).func_230529_a_((ITextComponent)new TranslationTextComponent(inputType.getTranslationKey())).func_240699_a_(TextFormatting.RESET);
        }
        sb = ValueTypeOperator.switchSignatureLineContext(lines, (IFormattableTextComponent)sb);
        sb.func_240702_b_((indent ? "  " : "") + SIGNATURE_LINK + " ").func_240699_a_(outputType.getDisplayColorFormat()).func_230529_a_((ITextComponent)new TranslationTextComponent(outputType.getTranslationKey())).func_240699_a_(TextFormatting.RESET);
        ValueTypeOperator.switchSignatureLineContext(lines, (IFormattableTextComponent)sb);
        return lines;
    }

    public static List<IFormattableTextComponent> getSignatureLines(IOperator operator, boolean indent) {
        return ValueTypeOperator.getSignatureLines(operator.getInputTypes(), operator.getOutputType(), indent);
    }

    @Override
    public String getName(ValueOperator a) {
        return a.getRawValue().getLocalizedNameFull().getString();
    }

    @Override
    public String getUniqueName(ValueOperator a) {
        return a.getRawValue().getUniqueName().toString();
    }

    public static class ValueOperatorPredicate
    extends ValuePredicate<ValueOperator> {
        private final IOperator operator;

        public ValueOperatorPredicate(@Nullable IValueType valueType, @Nullable IValue value, @Nullable IOperator operator) {
            super(valueType, value);
            this.operator = operator;
        }

        @Override
        protected boolean testTyped(ValueOperator value) {
            return super.testTyped(value) && (this.operator == null || value.getRawValue() == this.operator);
        }
    }

    public static class ValueOperator
    extends ValueBase {
        private final IOperator value;

        private ValueOperator(IOperator value) {
            super(ValueTypes.OPERATOR);
            this.value = value;
        }

        public static ValueOperator of(IOperator value) {
            return new ValueOperator(value);
        }

        public IOperator getRawValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof ValueOperator && this.value.equals(((ValueOperator)o).value);
        }

        public int hashCode() {
            return 37 + this.value.hashCode();
        }

        @Override
        public String toString() {
            return "ValueTypeOperator.ValueOperator(value=" + this.value + ")";
        }
    }
}

