/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class WrenchHelpers {
    public static final ResourceLocation TAG_WRENCH = new ResourceLocation("forge", "wrench");

    public static boolean isWrench(PlayerEntity player, ItemStack heldItem, World world, BlockPos pos, @Nullable Direction side) {
        return heldItem.func_77973_b().getTags().contains(TAG_WRENCH);
    }

    public static <P> void wrench(PlayerEntity player, ItemStack heldItem, World world, BlockPos pos, Direction side, IWrenchAction<P> action, P parameter) {
        if (WrenchHelpers.isWrench(player, heldItem, world, pos, side)) {
            action.onWrench(player, pos, parameter);
        }
    }

    public static void wrench(PlayerEntity player, ItemStack heldItem, World world, BlockPos pos, Direction side, IWrenchAction<Void> action) {
        WrenchHelpers.wrench(player, heldItem, world, pos, side, action, null);
    }

    public static abstract class SimpleWrenchAction
    implements IWrenchAction<Void> {
        @Override
        public void onWrench(PlayerEntity player, BlockPos pos, Void parameter) {
            this.onWrench(player, pos);
        }

        public abstract void onWrench(PlayerEntity var1, BlockPos var2);
    }

    public static interface IWrenchAction<P> {
        public void onWrench(PlayerEntity var1, BlockPos var2, P var3);
    }
}

