/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.cyclopscore.item.ItemBlockNBT;
import org.cyclops.cyclopscore.modcompat.capabilities.DefaultCapabilityProvider;
import org.cyclops.integrateddynamics.block.IEnergyContainerBlock;
import org.cyclops.integrateddynamics.capability.energystorage.EnergyStorageItemBlockEnergyContainer;
import org.cyclops.integrateddynamics.tileentity.TileEnergyBattery;

public class ItemBlockEnergyContainer
extends ItemBlockNBT {
    private IEnergyContainerBlock block;

    public ItemBlockEnergyContainer(Block block, Item.Properties builder) {
        super(block, builder);
        this.block = (IEnergyContainerBlock)block;
    }

    public IEnergyContainerBlock get() {
        return this.block;
    }

    public LazyOptional<IEnergyStorage> getEnergyBattery(ItemStack itemStack) {
        if (CapabilityEnergy.ENERGY == null) {
            return LazyOptional.of(() -> this.createCapability(itemStack));
        }
        return itemStack.getCapability(CapabilityEnergy.ENERGY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        this.getEnergyBattery(itemStack).ifPresent(energyStorage -> {
            int amount = energyStorage.getEnergyStored();
            int capacity = energyStorage.getMaxEnergyStored();
            String line = String.format("%,d", amount) + " / " + String.format("%,d", capacity) + " " + L10NHelpers.localize((String)"general.integrateddynamics.energy_unit", (Object[])new Object[0]);
            list.add((ITextComponent)new StringTextComponent(IInformationProvider.ITEM_PREFIX + line));
        });
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return this.getEnergyBattery(itemStack).map(energyStorage -> {
            double amount = energyStorage.getEnergyStored();
            double capacity = energyStorage.getMaxEnergyStored();
            return (capacity - amount) / capacity;
        }).orElse(0.0);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, 1.0f - (float)this.getDurabilityForDisplay(stack)) / 3.0f), (float)1.0f, (float)1.0f);
    }

    protected EnergyStorageItemBlockEnergyContainer createCapability(ItemStack itemStack) {
        return new EnergyStorageItemBlockEnergyContainer(this, itemStack){

            @Override
            public int getRate() {
                return TileEnergyBattery.getEnergyPerTick(this.getMaxEnergyStored());
            }
        };
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new DefaultCapabilityProvider(() -> CapabilityEnergy.ENERGY, LazyOptional.of(() -> this.createCapability(stack)));
    }
}

