/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.ingredient.ItemMatchProperties;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElementMasterSubGui;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElementRecipeSubGui;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerValueTypeRecipeSlotPropertiesChangedPacket;

public class ValueTypeRecipeLPElement
extends ValueTypeLPElementBase {
    public static final int SLOT_OFFSET = 4;
    public static final int TICK_DELAY = 30;
    @OnlyIn(value=Dist.CLIENT)
    public ValueTypeRecipeLPElementMasterSubGui lastGui;
    private NonNullList<ItemMatchProperties> inputStacks;
    private ItemStack inputFluid;
    private String inputFluidAmount = "0";
    private String inputEnergy = "0";
    private NonNullList<ItemStack> outputStacks;
    private ItemStack outputFluid;
    private String outputFluidAmount = "0";
    private String outputEnergy = "0";

    public ValueTypeRecipeLPElement() {
        super(ValueTypes.OBJECT_RECIPE);
    }

    @Override
    public ILogicProgrammerElementType getType() {
        return LogicProgrammerElementTypes.VALUETYPE;
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return IConfigRenderPattern.RECIPE;
    }

    @Override
    public void onInputSlotUpdated(int slotId, ItemStack itemStack) {
        ItemStack itemStackOld;
        if (this.inputStacks == null) {
            return;
        }
        if (slotId >= 0 && slotId < 9 && (itemStackOld = ((ItemMatchProperties)this.inputStacks.get(slotId)).getItemStack()).func_77973_b() != itemStack.func_77973_b()) {
            this.inputStacks.set(slotId, (Object)new ItemMatchProperties(itemStack.func_77946_l()));
            if (MinecraftHelpers.isClientSideThread()) {
                this.refreshPropertiesGui(slotId);
            }
        }
        if (slotId == 9) {
            this.inputFluid = itemStack.func_77946_l();
            if (this.inputFluidAmount.equalsIgnoreCase("0")) {
                int amount = FluidHelpers.getAmount((FluidStack)Helpers.getFluidStack(this.inputFluid));
                this.inputFluidAmount = Integer.toString(amount);
                if (MinecraftHelpers.isClientSideThread() && this.lastGui != null) {
                    this.refreshInputFluidAmountBox();
                }
            }
        }
        if (slotId > 9 && slotId < 13) {
            this.outputStacks.set(slotId - 10, (Object)itemStack.func_77946_l());
        }
        if (slotId == 13) {
            this.outputFluid = itemStack.func_77946_l();
            if (this.outputFluidAmount.equalsIgnoreCase("0")) {
                int amount = FluidHelpers.getAmount((FluidStack)Helpers.getFluidStack(this.outputFluid));
                this.outputFluidAmount = Integer.toString(amount);
                if (MinecraftHelpers.isClientSideThread() && this.lastGui != null) {
                    this.refreshOutputFluidAmountBox();
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void refreshPropertiesGui(int slot) {
        if (this.lastGui != null && this.lastGui.isPropertySubGuiActive(slot)) {
            this.lastGui.propertiesSubGuis.get(slot).loadStateToGui();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void refreshInputFluidAmountBox() {
        if (this.lastGui != null && this.lastGui.subGuiRecipe.getInputFluidAmountBox() != null) {
            this.lastGui.subGuiRecipe.getInputFluidAmountBox().func_146180_a(this.inputFluidAmount);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void refreshOutputFluidAmountBox() {
        if (this.lastGui != null && this.lastGui.subGuiRecipe.getOutputFluidAmountBox() != null) {
            this.lastGui.subGuiRecipe.getOutputFluidAmountBox().func_146180_a(this.outputFluidAmount);
        }
    }

    public void sendSlotPropertiesToServer(int slotId, ItemMatchProperties props) {
        IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeSlotPropertiesChangedPacket(slotId, props.isNbt(), props.getItemTag() == null ? "" : props.getItemTag(), props.getTagQuantity()));
    }

    public boolean isValidForRecipeGrid(List<ItemMatchProperties> itemInputs, List<FluidStack> fluidInputs, List<ItemStack> itemOutputs, List<FluidStack> fluidOutputs) {
        return itemInputs.size() <= 9 && itemOutputs.size() <= 3 && fluidInputs.size() <= 1 && fluidOutputs.size() <= 1;
    }

    protected void putItemPropertiesInContainer(ContainerLogicProgrammerBase container, int slot, ItemMatchProperties props) {
        this.putStackInContainer(container, slot, props.getItemStack());
        this.getInputStacks().set(slot, (Object)props);
    }

    protected void putStackInContainer(ContainerLogicProgrammerBase container, int slot, ItemStack itemStack) {
        container.func_75141_a(container.field_75151_b.size() - 50 + slot, itemStack);
    }

    /*
     * WARNING - void declaration
     */
    public void setRecipeGrid(ContainerLogicProgrammerBase container, List<ItemMatchProperties> itemInputs, List<FluidStack> fluidInputs, List<ItemStack> itemOutputs, List<FluidStack> fluidOutputs) {
        void var8_12;
        int slot = 0;
        for (ItemMatchProperties itemMatchProperties : itemInputs) {
            this.putItemPropertiesInContainer(container, slot, itemMatchProperties);
            ++slot;
        }
        while (slot < 9) {
            this.putItemPropertiesInContainer(container, slot, new ItemMatchProperties(ItemStack.field_190927_a));
            ++slot;
        }
        slot = 9;
        FluidStack fluidStackInput = FluidStack.EMPTY;
        if (fluidInputs.size() > 0) {
            fluidStackInput = fluidInputs.get(0);
        }
        this.putStackInContainer(container, slot, fluidStackInput.isEmpty() ? ItemStack.field_190927_a : this.getFluidBucket(fluidStackInput));
        this.inputFluidAmount = String.valueOf(FluidHelpers.getAmount((FluidStack)fluidStackInput));
        if (MinecraftHelpers.isClientSideThread()) {
            this.refreshInputFluidAmountBox();
        }
        slot = 10;
        for (ItemStack itemOutput : itemOutputs) {
            this.putStackInContainer(container, slot, itemOutput);
            ++slot;
        }
        while (slot < 13) {
            this.putStackInContainer(container, slot, ItemStack.field_190927_a);
            ++slot;
        }
        slot = 13;
        FluidStack fluidStack = FluidStack.EMPTY;
        if (fluidOutputs.size() > 0) {
            FluidStack fluidStack2 = fluidOutputs.get(0);
        }
        this.putStackInContainer(container, slot, var8_12.isEmpty() ? ItemStack.field_190927_a : this.getFluidBucket((FluidStack)var8_12));
        this.outputFluidAmount = String.valueOf(FluidHelpers.getAmount((FluidStack)var8_12));
        if (MinecraftHelpers.isClientSideThread()) {
            this.refreshOutputFluidAmountBox();
        }
    }

    protected ItemStack getFluidBucket(FluidStack fluidStack) {
        ItemStack itemStack = new ItemStack((IItemProvider)Items.field_151133_ar);
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
        fluidHandler.fill(new FluidStack(fluidStack, 1000), IFluidHandler.FluidAction.EXECUTE);
        return fluidHandler.getContainer();
    }

    protected boolean isInputValid() {
        return this.inputStacks.stream().anyMatch(ItemMatchProperties::isValid) || !this.inputFluid.func_190926_b() || !this.inputFluidAmount.equalsIgnoreCase("0") || !this.inputEnergy.equalsIgnoreCase("0");
    }

    protected boolean isOutputValid() {
        return this.outputStacks.stream().anyMatch(stack -> !stack.func_190926_b()) || !this.outputFluid.func_190926_b() || !this.outputFluidAmount.equalsIgnoreCase("0") || !this.outputEnergy.equalsIgnoreCase("0");
    }

    @Override
    public boolean canWriteElementPre() {
        return this.isInputValid() == this.isOutputValid();
    }

    @Override
    public void activate() {
        this.inputStacks = NonNullList.func_191197_a((int)9, (Object)new ItemMatchProperties(ItemStack.field_190927_a));
        for (int i = 0; i < 9; ++i) {
            this.inputStacks.set(i, (Object)new ItemMatchProperties(ItemStack.field_190927_a));
        }
        this.inputFluid = ItemStack.field_190927_a;
        this.inputFluidAmount = "0";
        this.inputEnergy = "0";
        this.outputStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
        this.outputFluid = ItemStack.field_190927_a;
        this.outputFluidAmount = "0";
        this.outputEnergy = "0";
    }

    @Override
    public void deactivate() {
    }

    @Override
    public ITextComponent validate() {
        if (!this.inputFluid.func_190926_b() && Helpers.getFluidStack(this.inputFluid).isEmpty()) {
            return new TranslationTextComponent("valuetype.integrateddynamics.error.fluid.no_fluid");
        }
        if (!this.outputFluid.func_190926_b() && Helpers.getFluidStack(this.outputFluid).isEmpty()) {
            return new TranslationTextComponent("valuetype.integrateddynamics.error.fluid.no_fluid");
        }
        try {
            Integer.parseInt(this.inputFluidAmount);
        }
        catch (NumberFormatException e) {
            return new TranslationTextComponent("valuetype.integrateddynamics.error.invalid_input", new Object[]{this.inputFluidAmount});
        }
        try {
            Integer.parseInt(this.outputFluidAmount);
        }
        catch (NumberFormatException e) {
            return new TranslationTextComponent("valuetype.integrateddynamics.error.invalid_input", new Object[]{this.outputFluidAmount});
        }
        try {
            Integer.parseInt(this.inputEnergy);
        }
        catch (NumberFormatException e) {
            return new TranslationTextComponent("valuetype.integrateddynamics.error.invalid_input", new Object[]{this.inputEnergy});
        }
        try {
            Integer.parseInt(this.outputEnergy);
        }
        catch (NumberFormatException e) {
            return new TranslationTextComponent("valuetype.integrateddynamics.error.invalid_input", new Object[]{this.outputEnergy});
        }
        return null;
    }

    @Override
    public boolean isItemValidForSlot(int slotId, ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean slotClick(int slotId, Slot slot, int mouseButton, ClickType clickType, PlayerEntity player) {
        if (slotId >= 4 && slotId < 13) {
            int quantityNew;
            if (clickType == ClickType.QUICK_MOVE && mouseButton == 0) {
                if (player.field_70170_p.func_201670_d()) {
                    int id = slotId - 4;
                    this.lastGui.setPropertySubGui(id);
                }
                return true;
            }
            ItemMatchProperties props = (ItemMatchProperties)this.getInputStacks().get(slotId - 4);
            int quantityCurrent = props.getTagQuantity();
            if (clickType == ClickType.QUICK_MOVE) {
                quantityNew = mouseButton == 0 ? (quantityCurrent + 1) / 2 : quantityCurrent * 2;
            } else {
                int n = quantityNew = mouseButton == 0 ? quantityCurrent - 1 : quantityCurrent + 1;
            }
            if (quantityNew > slot.func_75219_a()) {
                quantityNew = slot.func_75219_a();
            }
            props.setTagQuantity(quantityNew);
            if (quantityNew <= 0) {
                props.setItemTag(null);
                props.setTagQuantity(1);
                if (MinecraftHelpers.isClientSideThread()) {
                    this.refreshPropertiesGui(slotId - 4);
                }
            }
        }
        return super.slotClick(slotId, slot, mouseButton, clickType, player);
    }

    @Override
    public Slot createSlot(IInventory temporaryInputSlots, final int slotId, int x, int y) {
        SlotExtended slot = new SlotExtended(temporaryInputSlots, slotId, x, y){

            public boolean func_75214_a(ItemStack itemStack) {
                return ValueTypeRecipeLPElement.this.isItemValidForSlot(slotId, itemStack);
            }

            public ItemStack func_75211_c() {
                ITag tag;
                ItemMatchProperties props;
                String tagName;
                if (MinecraftHelpers.isClientSideThread() && slotId < 9 && (tagName = (props = (ItemMatchProperties)ValueTypeRecipeLPElement.this.getInputStacks().get(slotId)).getItemTag()) != null && (tag = ItemTags.func_199903_a().func_199910_a(new ResourceLocation(tagName))) != null) {
                    List items = tag.func_230236_b_();
                    int tick = (int)Minecraft.func_71410_x().field_71441_e.func_82737_E() / 30;
                    Item item = (Item)items.get(tick % items.size());
                    return new ItemStack((IItemProvider)item, props.getTagQuantity());
                }
                return super.func_75211_c();
            }
        };
        slot.setPhantom(true);
        return slot;
    }

    @Override
    public int getItemStackSizeLimit() {
        return 64;
    }

    protected Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> getInputs(List<ItemMatchProperties> itemStacks, ItemStack fluid, int fluidAmount, int energy) {
        List energies;
        int lastNonEmpty = 0;
        for (int i = 0; i < itemStacks.size(); ++i) {
            if (!itemStacks.get(i).isValid()) continue;
            lastNonEmpty = i + 1;
        }
        itemStacks = itemStacks.subList(0, lastNonEmpty);
        FluidStack fluidStack = Helpers.getFluidStack(fluid);
        if (!fluidStack.isEmpty()) {
            fluidStack.setAmount(fluidAmount);
        }
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        List items = itemStacks.stream().map(ItemMatchProperties::createPrototypedIngredient).collect(Collectors.toList());
        List fluids = !fluidStack.isEmpty() ? Collections.singletonList(new PrototypedIngredientAlternativesList(Collections.singletonList(new PrototypedIngredient(IngredientComponent.FLUIDSTACK, (Object)fluidStack, (Object)3)))) : Collections.emptyList();
        List<Object> list = energies = energy > 0 ? Collections.singletonList(new PrototypedIngredientAlternativesList(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ENERGY, (Object)energy, (Object)false)))) : Collections.emptyList();
        if (!items.isEmpty()) {
            inputs.put(IngredientComponent.ITEMSTACK, items);
        }
        if (!fluids.isEmpty()) {
            inputs.put(IngredientComponent.FLUIDSTACK, fluids);
        }
        if (!energies.isEmpty()) {
            inputs.put(IngredientComponent.ENERGY, energies);
        }
        return inputs;
    }

    protected Map<IngredientComponent<?, ?>, List<?>> getOutputs(List<ItemStack> itemStacksIn, ItemStack fluid, int fluidAmount, int energy) {
        ArrayList itemStacks = Lists.newArrayList();
        for (int i = 0; i < itemStacksIn.size(); ++i) {
            if (itemStacksIn.get(i).func_190926_b()) continue;
            itemStacks.add(itemStacksIn.get(i));
        }
        FluidStack fluidStack = Helpers.getFluidStack(fluid);
        if (!fluidStack.isEmpty()) {
            fluidStack.setAmount(fluidAmount);
        }
        IdentityHashMap outputs = Maps.newIdentityHashMap();
        if (!itemStacks.isEmpty()) {
            outputs.put(IngredientComponent.ITEMSTACK, itemStacks);
        }
        if (!fluidStack.isEmpty()) {
            outputs.put(IngredientComponent.FLUIDSTACK, Collections.singletonList(fluidStack));
        }
        if (energy > 0) {
            outputs.put(IngredientComponent.ENERGY, Collections.singletonList(energy));
        }
        return outputs;
    }

    @Override
    public IValue getValue() {
        if (!this.isInputValid() && !this.isOutputValid()) {
            return ValueObjectTypeRecipe.ValueRecipe.of(null);
        }
        return ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)new RecipeDefinition(this.getInputs((List<ItemMatchProperties>)this.inputStacks, this.inputFluid, Integer.parseInt(this.inputFluidAmount), Integer.parseInt(this.inputEnergy)), (IMixedIngredients)new MixedIngredients(this.getOutputs((List<ItemStack>)this.outputStacks, this.outputFluid, Integer.parseInt(this.outputFluidAmount), Integer.parseInt(this.outputEnergy)))));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ISubGuiBox createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
        this.lastGui = new ValueTypeRecipeLPElementMasterSubGui(this, baseX, baseY, maxWidth, maxHeight, gui, container);
        return this.lastGui;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setValueInGui(ISubGuiBox subGui) {
        int i;
        ValueTypeRecipeLPElementRecipeSubGui gui = (ValueTypeRecipeLPElementRecipeSubGui)subGui;
        IInventory slots = ((ContainerLogicProgrammerBase)gui.container).getTemporaryInputSlots();
        for (i = 0; i < this.inputStacks.size(); ++i) {
            ItemMatchProperties entry = (ItemMatchProperties)this.inputStacks.get(i);
            slots.func_70299_a(i, entry.getItemStack());
        }
        slots.func_70299_a(9, this.inputFluid);
        if (gui.getInputFluidAmountBox() != null) {
            gui.getInputFluidAmountBox().func_146180_a(this.inputFluidAmount);
            gui.getInputEnergyBox().func_146180_a(this.inputEnergy);
            for (i = 0; i < this.outputStacks.size(); ++i) {
                slots.func_70299_a(10 + i, (ItemStack)this.outputStacks.get(i));
            }
            slots.func_70299_a(13, this.outputFluid);
            gui.getOutputFluidAmountBox().func_146180_a(this.outputFluidAmount);
            gui.getOutputEnergyBox().func_146180_a(this.outputEnergy);
        }
    }

    public NonNullList<ItemMatchProperties> getInputStacks() {
        return this.inputStacks;
    }

    public String getInputFluidAmount() {
        return this.inputFluidAmount;
    }

    public void setInputFluidAmount(String inputFluidAmount) {
        this.inputFluidAmount = inputFluidAmount;
    }

    public String getInputEnergy() {
        return this.inputEnergy;
    }

    public void setInputEnergy(String inputEnergy) {
        this.inputEnergy = inputEnergy;
    }

    public String getOutputFluidAmount() {
        return this.outputFluidAmount;
    }

    public void setOutputFluidAmount(String outputFluidAmount) {
        this.outputFluidAmount = outputFluidAmount;
    }

    public String getOutputEnergy() {
        return this.outputEnergy;
    }

    public void setOutputEnergy(String outputEnergy) {
        this.outputEnergy = outputEnergy;
    }
}

