/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.cyclops.commoncapabilities.api.capability.inventorystate.IInventoryState;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.ingredient.collection.diff.IngredientCollectionDiff;
import org.cyclops.cyclopscore.ingredient.collection.diff.IngredientCollectionDiffManager;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentStorageObservable;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.PrioritizedPartPos;
import org.cyclops.integrateddynamics.core.network.diagnostics.NetworkDiagnostics;

public class IngredientObserver<T, M> {
    private static final ExecutorService WORKER_POOL = Executors.newFixedThreadPool(GeneralConfig.ingredientNetworkObserverThreads);
    private final IPositionedAddonsNetworkIngredients<T, M> network;
    private final Set<IIngredientComponentStorageObservable.IIndexChangeObserver<T, M>> changeObservers;
    private final Int2ObjectMap<Map<PartPos, Integer>> observeTargetTickIntervals;
    private final Int2ObjectMap<Map<PartPos, Integer>> observeTargetTicks;
    private final Int2ObjectMap<Map<PrioritizedPartPos, IngredientCollectionDiffManager<T, M>>> channeledDiffManagers;
    private final Int2ObjectMap<List<PrioritizedPartPos>> lastRemoved;
    private final Map<PartPos, Integer> lastInventoryStates;
    private Future<?> lastObserverBarrier;

    public IngredientObserver(IPositionedAddonsNetworkIngredients<T, M> network) {
        this.network = network;
        this.changeObservers = Sets.newIdentityHashSet();
        this.observeTargetTickIntervals = new Int2ObjectOpenHashMap();
        this.observeTargetTicks = new Int2ObjectOpenHashMap();
        this.channeledDiffManagers = new Int2ObjectOpenHashMap();
        this.lastRemoved = new Int2ObjectOpenHashMap();
        this.lastInventoryStates = Maps.newHashMap();
        this.lastObserverBarrier = null;
    }

    public IPositionedAddonsNetworkIngredients<T, M> getNetwork() {
        return this.network;
    }

    @Nullable
    public List<PrioritizedPartPos> getLastRemoved(int channel) {
        return (List)this.lastRemoved.get(channel);
    }

    public void onPositionRemoved(int channel, PrioritizedPartPos pos) {
        List positions = (List)this.lastRemoved.get(channel);
        if (positions == null) {
            positions = Lists.newLinkedList();
            this.lastRemoved.put(channel, (Object)positions);
        }
        positions.add(pos);
        this.lastInventoryStates.remove(pos.getPartPos());
    }

    public synchronized void addChangeObserver(IIngredientComponentStorageObservable.IIndexChangeObserver<T, M> observer) {
        this.changeObservers.add(observer);
    }

    public synchronized void removeChangeObserver(IIngredientComponentStorageObservable.IIndexChangeObserver<T, M> observer) {
        this.changeObservers.remove(observer);
    }

    protected int getCurrentTick() {
        return ServerLifecycleHooks.getCurrentServer().func_71259_af();
    }

    protected void emitEvent(IIngredientComponentStorageObservable.StorageChangeEvent<T, M> event) {
        if (GeneralConfig.ingredientNetworkObserverEnableMultithreading) {
            ServerLifecycleHooks.getCurrentServer().func_213165_a(() -> {
                for (IIngredientComponentStorageObservable.IIndexChangeObserver<T, M> observer : this.getObserversCopy()) {
                    observer.onChange(event);
                }
            });
        } else {
            for (IIngredientComponentStorageObservable.IIndexChangeObserver<T, M> observer : this.getObserversCopy()) {
                observer.onChange(event);
            }
        }
    }

    protected synchronized List<IIngredientComponentStorageObservable.IIndexChangeObserver<T, M>> getObserversCopy() {
        return Lists.newArrayList(this.changeObservers);
    }

    protected int[] getChannels() {
        int[] networkChannels = this.getNetwork().getChannels();
        IntSet lastRemovedChannels = this.lastRemoved.keySet();
        if (lastRemovedChannels.size() == 0) {
            return networkChannels;
        }
        IntLinkedOpenHashSet uniqueChannels = new IntLinkedOpenHashSet();
        IntIterator object = lastRemovedChannels.iterator();
        while (object.hasNext()) {
            int lastRemovedChannel = (Integer)object.next();
            uniqueChannels.add(lastRemovedChannel);
        }
        for (int networkChannel : networkChannels) {
            uniqueChannels.add(networkChannel);
        }
        return uniqueChannels.toIntArray();
    }

    protected boolean observe() {
        if (!this.changeObservers.isEmpty()) {
            if (GeneralConfig.ingredientNetworkObserverEnableMultithreading) {
                if (this.lastObserverBarrier != null && !this.lastObserverBarrier.isDone()) {
                    return false;
                }
                this.lastObserverBarrier = WORKER_POOL.submit(() -> {
                    for (int channel : this.getChannels()) {
                        this.observe(channel);
                    }
                });
            } else {
                for (int channel : this.getChannels()) {
                    this.observe(channel);
                }
            }
        }
        return true;
    }

    protected synchronized Set<PrioritizedPartPos> getPositionsCopy(int channel) {
        return Sets.newHashSet(this.getNetwork().getPrioritizedPositions(channel));
    }

    protected void observe(int channel) {
        Map diffManagers;
        Map channelIntervals;
        int currentTick = this.getCurrentTick();
        Map channelTargetTicks = (Map)this.observeTargetTicks.get(channel);
        if (channelTargetTicks == null) {
            channelTargetTicks = Maps.newHashMap();
        }
        if ((channelIntervals = (Map)this.observeTargetTickIntervals.get(channel)) == null) {
            channelIntervals = Maps.newHashMap();
        }
        if ((diffManagers = (Map)this.channeledDiffManagers.get(channel)) == null) {
            diffManagers = Maps.newHashMap();
            this.channeledDiffManagers.put(channel, (Object)diffManagers);
        }
        boolean isBeingDiagnozed = NetworkDiagnostics.getInstance().isBeingDiagnozed();
        Map<PartPos, Long> lastSecondDurations = this.network.getLastSecondDurationIndex();
        if (!isBeingDiagnozed && !lastSecondDurations.isEmpty()) {
            lastSecondDurations.clear();
        }
        Set<PrioritizedPartPos> positions = this.getPositionsCopy(channel);
        for (PrioritizedPartPos partPos : positions) {
            int lastTick;
            long startTime = 0L;
            if (isBeingDiagnozed) {
                startTime = System.nanoTime();
            }
            if ((lastTick = channelTargetTicks.getOrDefault(partPos.getPartPos(), currentTick).intValue()) <= currentTick) {
                IInventoryState inventoryState;
                boolean skipPosition = false;
                if (!partPos.getPartPos().getPos().isLoaded()) {
                    skipPosition = true;
                }
                if (!skipPosition && (inventoryState = (IInventoryState)TileHelpers.getCapability((DimPos)partPos.getPartPos().getPos(), (Direction)partPos.getPartPos().getSide(), Capabilities.INVENTORY_STATE).orElse(null)) != null) {
                    Integer lastState = this.lastInventoryStates.get(partPos.getPartPos());
                    int newState = inventoryState.getState();
                    if (lastState != null && lastState == newState) {
                        skipPosition = true;
                    } else {
                        this.lastInventoryStates.put(partPos.getPartPos(), newState);
                    }
                }
                if (!skipPosition) {
                    IngredientCollectionDiffManager diffManager = (IngredientCollectionDiffManager)diffManagers.get(partPos);
                    if (diffManager == null) {
                        diffManager = new IngredientCollectionDiffManager(this.network.getComponent());
                        diffManagers.put(partPos, diffManager);
                    }
                    IngredientCollectionDiff diff = diffManager.onChange(this.getNetwork().getRawInstances(partPos.getPartPos()));
                    boolean hasChanges = false;
                    if (diff.hasAdditions()) {
                        hasChanges = true;
                        this.emitEvent(new IIngredientComponentStorageObservable.StorageChangeEvent(channel, partPos, IIngredientComponentStorageObservable.Change.ADDITION, false, diff.getAdditions()));
                    }
                    if (diff.hasDeletions()) {
                        hasChanges = true;
                        this.emitEvent(new IIngredientComponentStorageObservable.StorageChangeEvent(channel, partPos, IIngredientComponentStorageObservable.Change.DELETION, diff.isCompletelyEmpty(), diff.getDeletions()));
                    }
                    int tickInterval = channelIntervals.getOrDefault(partPos.getPartPos(), GeneralConfig.ingredientNetworkObserverFrequencyMax);
                    boolean tickIntervalChanged = false;
                    if (hasChanges) {
                        if (tickInterval > GeneralConfig.ingredientNetworkObserverFrequencyMin) {
                            tickIntervalChanged = true;
                            tickInterval = Math.max(GeneralConfig.ingredientNetworkObserverFrequencyMin, tickInterval - GeneralConfig.ingredientNetworkObserverFrequencyDecreaseFactor);
                        }
                    } else if (tickInterval < GeneralConfig.ingredientNetworkObserverFrequencyMax) {
                        tickIntervalChanged = true;
                        tickInterval = Math.min(GeneralConfig.ingredientNetworkObserverFrequencyMax, tickInterval + GeneralConfig.ingredientNetworkObserverFrequencyIncreaseFactor);
                    }
                    if (tickInterval != 1) {
                        channelTargetTicks.put(partPos.getPartPos(), currentTick + tickInterval);
                    }
                    if (tickIntervalChanged) {
                        if (tickInterval != GeneralConfig.ingredientNetworkObserverFrequencyMax) {
                            channelIntervals.put(partPos.getPartPos(), tickInterval);
                        } else {
                            channelIntervals.remove(partPos.getPartPos());
                        }
                    }
                }
            }
            if (!isBeingDiagnozed) continue;
            long duration = System.nanoTime() - startTime;
            PartPos interfacePos = PartTarget.fromCenter(partPos.getPartPos()).getTarget();
            Long lastDuration = lastSecondDurations.get(interfacePos);
            if (lastDuration != null) {
                duration += lastDuration.longValue();
            }
            lastSecondDurations.put(interfacePos, duration);
        }
        List lastRemovedPositions = (List)this.lastRemoved.get(channel);
        if (lastRemovedPositions != null) {
            for (PrioritizedPartPos partPos : lastRemovedPositions) {
                IngredientCollectionDiff diff;
                IngredientCollectionDiffManager diffManager = (IngredientCollectionDiffManager)diffManagers.get(partPos);
                if (diffManager == null || !(diff = diffManager.onChange((Iterator)Iterators.forArray((Object[])new Object[0]))).hasDeletions()) continue;
                this.emitEvent(new IIngredientComponentStorageObservable.StorageChangeEvent(channel, partPos, IIngredientComponentStorageObservable.Change.DELETION, diff.isCompletelyEmpty(), diff.getDeletions()));
            }
            this.lastRemoved.remove(channel);
        }
        if (!channelTargetTicks.isEmpty()) {
            this.observeTargetTicks.put(channel, (Object)channelTargetTicks);
        }
        if (!channelIntervals.isEmpty()) {
            this.observeTargetTickIntervals.put(channel, (Object)channelIntervals);
        }
    }

    public void resetTickInterval(int channel, PartPos targetPos) {
        Map channelTicks = (Map)this.observeTargetTicks.get(channel);
        if (channelTicks == null) {
            channelTicks = Maps.newHashMap();
            this.observeTargetTicks.put(channel, (Object)channelTicks);
        }
        channelTicks.put(targetPos, this.getCurrentTick() + GeneralConfig.ingredientNetworkObserverFrequencyForced);
    }
}

