/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part.panel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartTypeActiveVariable;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.block.IgnoredBlock;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;
import org.cyclops.integrateddynamics.core.network.event.NetworkElementAddEvent;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.part.PartStateActiveVariableBase;
import org.cyclops.integrateddynamics.core.part.PartStateBase;
import org.cyclops.integrateddynamics.core.part.PartTypeBase;
import org.cyclops.integrateddynamics.core.part.panel.PartTypePanel;
import org.cyclops.integrateddynamics.inventory.container.ContainerPartPanelVariableDriven;

public abstract class PartTypePanelVariableDriven<P extends PartTypePanelVariableDriven<P, S>, S extends State<P, S>>
extends PartTypePanel<P, S>
implements IPartTypeActiveVariable<P, S> {
    public PartTypePanelVariableDriven(String name) {
        super(name);
    }

    @Override
    protected Block createBlock(BlockConfig blockConfig) {
        return new IgnoredBlockStatus();
    }

    @Override
    protected Map<Class<? extends INetworkEvent>, PartTypeBase.IEventAction> constructNetworkEventActions() {
        Map<Class<? extends INetworkEvent>, PartTypeBase.IEventAction> actions = super.constructNetworkEventActions();
        PartTypeBase.IEventAction updateEventListener = (network, target, state, event) -> NetworkHelpers.getPartNetwork(network).ifPresent(partNetwork -> this.onVariableContentsUpdated((IPartNetwork)partNetwork, target, (S)state));
        actions.put(VariableContentsUpdatedEvent.class, updateEventListener);
        actions.put(NetworkElementAddEvent.Post.class, updateEventListener);
        return actions;
    }

    @Override
    public void addDrops(PartTarget target, S state, List<ItemStack> itemStacks, boolean dropMainElement, boolean saveState) {
        for (int i = 0; i < ((PartStateActiveVariableBase)state).getInventory().func_70302_i_(); ++i) {
            ItemStack itemStack = ((PartStateActiveVariableBase)state).getInventory().func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            itemStacks.add(itemStack);
        }
        ((PartStateActiveVariableBase)state).getInventory().func_174888_l();
        ((PartStateActiveVariableBase)state).onVariableContentsUpdated((PartTypePanelVariableDriven)this, target);
        super.addDrops(target, state, itemStacks, dropMainElement, saveState);
    }

    @Override
    public void beforeNetworkKill(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.beforeNetworkKill(network, partNetwork, target, state);
        ((PartStateActiveVariableBase)state).onVariableContentsUpdated((PartTypePanelVariableDriven)this, target);
    }

    @Override
    public void afterNetworkAlive(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.afterNetworkAlive(network, partNetwork, target, state);
        ((PartStateActiveVariableBase)state).onVariableContentsUpdated((PartTypePanelVariableDriven)this, target);
    }

    @Override
    public boolean isUpdate(S state) {
        return true;
    }

    @Override
    public void update(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.update(network, partNetwork, target, state);
        IValue lastValue = ((State)state).getDisplayValue();
        IValue newValue = null;
        if (((PartStateActiveVariableBase)state).hasVariable()) {
            try {
                IVariable variable = ((PartStateActiveVariableBase)state).getVariable(network, partNetwork);
                if (variable != null) {
                    newValue = (IValue)variable.getValue();
                }
            }
            catch (EvaluationException e) {
                ((PartStateActiveVariableBase)state).addGlobalError((IFormattableTextComponent)new TranslationTextComponent(e.getLocalizedMessage()));
            }
        }
        if (!ValueHelpers.areValuesEqual(lastValue, newValue)) {
            this.onValueChanged(network, partNetwork, target, state, lastValue, newValue);
            ((PartStateBase)state).onDirty();
            BlockHelpers.markForUpdate((World)target.getCenter().getPos().getWorld(true), (BlockPos)target.getCenter().getPos().getBlockPos());
        }
    }

    @Override
    public boolean hasActiveVariable(IPartNetwork network, PartTarget target, S partState) {
        return ((PartStateActiveVariableBase)partState).hasVariable();
    }

    @Override
    public <V extends IValue> IVariable<V> getActiveVariable(INetwork network, IPartNetwork partNetwork, PartTarget target, S partState) {
        return ((PartStateActiveVariableBase)partState).getVariable(network, partNetwork);
    }

    protected void onValueChanged(INetwork network, IPartNetwork partNetwork, PartTarget target, S state, IValue lastValue, IValue newValue) {
        if (newValue == null) {
            ((State)state).setDisplayValue(null);
        } else {
            IValue materializedValue = null;
            try {
                IValueTypeListProxy original;
                if (newValue.getType() == ValueTypes.LIST && (original = ((ValueTypeList.ValueList)newValue).getRawValue()).getLength() > 20) {
                    ArrayList list = Lists.newArrayList();
                    for (int i = 0; i < 20; ++i) {
                        list.add(original.get(i));
                    }
                    newValue = ValueTypeList.ValueList.ofList(original.getValueType(), list);
                }
                materializedValue = newValue.getType().materialize(newValue);
            }
            catch (EvaluationException e) {
                ((PartStateActiveVariableBase)state).addGlobalError((IFormattableTextComponent)new TranslationTextComponent(e.getLocalizedMessage()));
            }
            ((State)state).setDisplayValue(materializedValue);
        }
    }

    @Override
    public Optional<INamedContainerProvider> getContainerProvider(final PartPos pos) {
        return Optional.of(new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent(PartTypePanelVariableDriven.this.getTranslationKey());
            }

            @Nullable
            public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                Triple<IPartContainer, PartTypeBase, PartTarget> data = PartHelpers.getContainerPartConstructionData(pos);
                State partState = (State)((IPartContainer)data.getLeft()).getPartState(((PartTarget)data.getRight()).getCenter().getSide());
                return new ContainerPartPanelVariableDriven(id, playerInventory, (IInventory)partState.getInventory(), Optional.of(data.getRight()), Optional.of(data.getLeft()), (PartTypePanelVariableDriven)data.getMiddle());
            }
        });
    }

    @Override
    public void writeExtraGuiData(PacketBuffer packetBuffer, PartPos pos, ServerPlayerEntity player) {
        IPartContainer partContainer = PartHelpers.getPartContainerChecked(pos);
        State partState = (State)partContainer.getPartState(pos.getSide());
        packetBuffer.writeInt(partState.getInventory().func_70302_i_());
        super.writeExtraGuiData(packetBuffer, pos, player);
    }

    protected IgnoredBlockStatus.Status getStatus(State state) {
        IgnoredBlockStatus.Status status = IgnoredBlockStatus.Status.INACTIVE;
        if (state != null && !state.getInventory().func_191420_l()) {
            status = state.hasVariable() && state.isEnabled() ? IgnoredBlockStatus.Status.ACTIVE : IgnoredBlockStatus.Status.ERROR;
        }
        return status;
    }

    @Override
    public BlockState getBlockState(IPartContainer partContainer, Direction side) {
        IgnoredBlockStatus.Status status = this.getStatus(partContainer != null ? (State)partContainer.getPartState(side) : null);
        return (BlockState)((BlockState)this.getBlock().func_176223_P().func_206870_a((Property)IgnoredBlock.FACING, (Comparable)side)).func_206870_a((Property)IgnoredBlockStatus.STATUS, (Comparable)((Object)status));
    }

    protected void onVariableContentsUpdated(IPartNetwork network, PartTarget target, S state) {
        ((PartStateActiveVariableBase)state).onVariableContentsUpdated((PartTypePanelVariableDriven)this, target);
    }

    @Override
    public ActionResultType onPartActivated(S partState, BlockPos pos, World world, PlayerEntity player, Hand hand, ItemStack heldItem, BlockRayTraceResult hit) {
        if (WrenchHelpers.isWrench(player, heldItem, world, pos, hit.func_216354_b())) {
            WrenchHelpers.wrench(player, heldItem, world, pos, hit.func_216354_b(), (player1, pos1, parameter) -> partState.setFacingRotation(partState.getFacingRotation().func_176746_e()));
            return ActionResultType.SUCCESS;
        }
        return super.onPartActivated(partState, pos, world, player, hand, heldItem, hit);
    }

    @Override
    public void loadTooltip(S state, List<ITextComponent> lines) {
        if (!((PartStateActiveVariableBase)state).getInventory().func_191420_l()) {
            if (((PartStateActiveVariableBase)state).hasVariable() && ((PartStateBase)state).isEnabled()) {
                IValue value = ((State)state).getDisplayValue();
                if (value != null) {
                    IValueType valueType = value.getType();
                    lines.add((ITextComponent)new TranslationTextComponent("parttype.integrateddynamics.tooltip.display.active_value", new Object[]{valueType.toCompactString(value).func_240699_a_(valueType.getDisplayColorFormat()), new TranslationTextComponent(valueType.getTranslationKey())}));
                }
            } else {
                lines.add((ITextComponent)new TranslationTextComponent("parttype.integrateddynamics.tooltip.errors").func_240699_a_(TextFormatting.RED));
                for (IFormattableTextComponent error : ((PartStateActiveVariableBase)state).getGlobalErrors()) {
                    lines.add((ITextComponent)error.func_240699_a_(TextFormatting.RED));
                }
            }
        } else {
            lines.add((ITextComponent)new TranslationTextComponent("parttype.integrateddynamics.tooltip.inactive"));
        }
        super.loadTooltip(state, lines);
    }

    @Override
    public boolean shouldTriggerBlockRenderUpdate(@Nullable S oldPartState, @Nullable S newPartState) {
        return super.shouldTriggerBlockRenderUpdate(oldPartState, newPartState) || this.getStatus((State)oldPartState) != this.getStatus((State)newPartState);
    }

    public static abstract class State<P extends PartTypePanelVariableDriven<P, S>, S extends State<P, S>>
    extends PartStateActiveVariableBase<P> {
        private IValue displayValue;
        private Direction facingRotation = Direction.NORTH;

        public State() {
            super(1);
        }

        @Override
        public void writeToNBT(CompoundNBT tag) {
            super.writeToNBT(tag);
            IValue value = this.getDisplayValue();
            if (value != null) {
                tag.func_74778_a("displayValueType", value.getType().getUniqueName().toString());
                tag.func_218657_a("displayValue", ValueHelpers.serializeRaw(value));
            }
            tag.func_74768_a("facingRotation", this.facingRotation.ordinal());
        }

        @Override
        public void readFromNBT(CompoundNBT tag) {
            super.readFromNBT(tag);
            if (tag.func_150297_b("displayValueType", 8) && tag.func_74764_b("displayValue")) {
                IValueType valueType = ValueTypes.REGISTRY.getValueType(new ResourceLocation(tag.func_74779_i("displayValueType")));
                if (valueType != null) {
                    INBT serializedValue = tag.func_74781_a("displayValue");
                    ITextComponent deserializationError = valueType.canDeserialize(serializedValue);
                    if (deserializationError == null) {
                        this.setDisplayValue((IValue)ValueHelpers.deserializeRaw(valueType, serializedValue));
                    } else {
                        IntegratedDynamics.clog(Level.ERROR, deserializationError.getString());
                    }
                } else {
                    IntegratedDynamics.clog(Level.ERROR, String.format("Tried to deserialize the value \"%s\" for type \"%s\" which could not be found.", tag.func_74779_i("displayValueType"), tag.func_74779_i("value")));
                }
            } else {
                this.setDisplayValue(null);
            }
            this.facingRotation = Direction.values()[Math.max(2, tag.func_74762_e("facingRotation"))];
        }

        public IValue getDisplayValue() {
            return this.displayValue;
        }

        public void setDisplayValue(IValue displayValue) {
            this.displayValue = displayValue;
        }

        public Direction getFacingRotation() {
            return this.facingRotation;
        }

        public void setFacingRotation(Direction facingRotation) {
            this.facingRotation = facingRotation;
        }
    }
}

