/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.path;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.TreeSet;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.persist.nbt.INBTSerializable;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.api.path.ISidedPathElement;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.capability.path.SidedPathElement;

public class Cluster
implements Collection<ISidedPathElement>,
INBTSerializable {
    private final Set<ISidedPathElement> elements;

    public Cluster() {
        this.elements = Sets.newTreeSet();
    }

    public Cluster(TreeSet<ISidedPathElement> elements) {
        this.elements = elements;
    }

    public CompoundNBT toNBT() {
        CompoundNBT tag = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (ISidedPathElement e : this.elements) {
            CompoundNBT elementTag = new CompoundNBT();
            elementTag.func_74778_a("dimension", e.getPathElement().getPosition().getWorld());
            elementTag.func_74772_a("pos", e.getPathElement().getPosition().getBlockPos().func_218275_a());
            if (e.getSide() != null) {
                elementTag.func_74768_a("side", e.getSide().ordinal());
            }
            list.add((Object)elementTag);
        }
        tag.func_218657_a("list", (INBT)list);
        return tag;
    }

    public void fromNBT(CompoundNBT tag) {
        ListNBT list = tag.func_150295_c("list", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT elementTag = list.func_150305_b(i);
            ResourceLocation dimensionId = new ResourceLocation(elementTag.func_74779_i("dimension"));
            RegistryKey dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimensionId);
            ServerWorld world = ServerLifecycleHooks.getCurrentServer().func_71218_a(dimension);
            BlockPos pos = BlockPos.func_218283_e((long)elementTag.func_74763_f("pos"));
            Direction side = null;
            if (elementTag.func_150297_b("side", 3)) {
                side = Direction.values()[elementTag.func_74762_e("side")];
            }
            if (world == null) {
                IntegratedDynamics.clog(Level.WARN, String.format("Skipped loading part from a network at the invalid dimension id %s.", dimensionId));
                continue;
            }
            IPathElement pathElement = (IPathElement)TileHelpers.getCapability((IBlockReader)world, (BlockPos)pos, (Direction)side, PathElementConfig.CAPABILITY).orElse(null);
            if (pathElement == null) {
                IntegratedDynamics.clog(Level.WARN, String.format("Skipped loading part from a network at position %s in world %s because it has no valid path element.", pos, dimensionId));
                continue;
            }
            this.elements.add(SidedPathElement.of(pathElement, side));
        }
    }

    public Set<ISidedPathElement> getElements() {
        return this.elements;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<ISidedPathElement> this$elements = this.getElements();
        Set<ISidedPathElement> other$elements = other.getElements();
        return !(this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Cluster;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<ISidedPathElement> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 0 : ((Object)$elements).hashCode());
        return result;
    }

    public String toString() {
        return "Cluster(elements=" + this.getElements() + ")";
    }

    @Override
    public int size() {
        return this.getElements().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getElements().isEmpty();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.getElements().contains(arg0);
    }

    @Override
    public Iterator<ISidedPathElement> iterator() {
        return this.getElements().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getElements().toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.getElements().toArray(arg0);
    }

    @Override
    public boolean add(ISidedPathElement arg0) {
        return this.getElements().add(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        return this.getElements().remove(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.getElements().containsAll(arg0);
    }

    @Override
    public boolean addAll(Collection<? extends ISidedPathElement> arg0) {
        return this.getElements().addAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.getElements().retainAll(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.getElements().removeAll(arg0);
    }

    @Override
    public void clear() {
        this.getElements().clear();
    }

    @Override
    public Spliterator<ISidedPathElement> spliterator() {
        return this.getElements().spliterator();
    }
}

