/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.inventory.container;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.slot.SlotRemoveOnly;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRead;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectVariable;
import org.cyclops.integrateddynamics.api.part.read.IPartStateReader;
import org.cyclops.integrateddynamics.api.part.read.IPartTypeReader;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipartAspects;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;
import org.cyclops.integrateddynamics.core.part.event.PartReaderAspectEvent;

public class ContainerPartReader<P extends IPartTypeReader<P, S>, S extends IPartStateReader<P>>
extends ContainerMultipartAspects<P, S, IAspectRead> {
    public static final int ASPECT_BOX_HEIGHT = 36;
    private static final int SLOT_IN_X = 96;
    private static final int SLOT_IN_Y = 27;
    private static final int SLOT_OUT_X = 144;
    private static final int SLOT_OUT_Y = 27;
    private final IInventory outputSlots;
    private final BiMap<Integer, IAspectRead> readValueIds = HashBiMap.create();
    private final BiMap<Integer, IAspectRead> readColorIds = HashBiMap.create();

    public ContainerPartReader(int id, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        this(id, playerInventory, (IInventory)new SimpleInventory(0, 1), PartHelpers.readPartTarget(packetBuffer), Optional.empty(), (IPartTypeReader)PartHelpers.readPart(packetBuffer));
    }

    public ContainerPartReader(int id, PlayerInventory playerInventory, IInventory inventory, PartTarget target, Optional<IPartContainer> partContainer, P partType) {
        super(RegistryEntries.CONTAINER_PART_READER, id, playerInventory, inventory, target, partContainer, partType, partType.getReadAspects());
        int i;
        for (i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.func_75146_a((Slot)new SlotVariable(this.inputSlots, i, 96, 27 + this.getAspectBoxHeight() * i));
            this.disableSlot(i);
        }
        this.outputSlots = new SimpleInventory(this.getUnfilteredItemCount(), 1);
        for (i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.func_75146_a((Slot)new SlotRemoveOnly(this.outputSlots, i, 144, 27 + this.getAspectBoxHeight() * i));
            this.disableSlot(i + this.getUnfilteredItemCount());
        }
        this.addPlayerInventory(this.player.field_71071_by, 9, 131);
        for (IAspectRead aspectRead : this.getUnfilteredItems()) {
            this.readValueIds.put((Object)this.getNextValueId(), (Object)aspectRead);
            this.readColorIds.put((Object)this.getNextValueId(), (Object)aspectRead);
        }
    }

    protected boolean isAssertInventorySize() {
        return false;
    }

    protected int getSizeInventory() {
        return ((IPartTypeReader)this.getPartType()).getReadAspects().size() * 2;
    }

    @Override
    public int getAspectBoxHeight() {
        return 36;
    }

    @Override
    protected void enableSlot(int slotIndex, int row) {
        Slot slot = this.func_75139_a(slotIndex);
        ContainerPartReader.setSlotPosX((Slot)slot, (int)96);
        ContainerPartReader.setSlotPosY((Slot)slot, (int)(27 + this.getAspectBoxHeight() * row));
    }

    protected void disableSlotOutput(int slotIndex) {
        Slot slot = this.func_75139_a(slotIndex + this.getUnfilteredItemCount());
        ContainerPartReader.setSlotPosX((Slot)slot, (int)Integer.MIN_VALUE);
        ContainerPartReader.setSlotPosY((Slot)slot, (int)Integer.MIN_VALUE);
    }

    protected void enableSlotOutput(int slotIndex, int row) {
        Slot slot = this.func_75139_a(slotIndex + this.getUnfilteredItemCount());
        ContainerPartReader.setSlotPosX((Slot)slot, (int)144);
        ContainerPartReader.setSlotPosY((Slot)slot, (int)(27 + this.getAspectBoxHeight() * row));
    }

    @Override
    public void onScroll(int firstRow) {
        for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.disableSlotOutput(i);
        }
        super.onScroll(firstRow);
    }

    @Override
    protected void enableElementAt(int row, int elementIndex, IAspectRead element) {
        super.enableElementAt(row, elementIndex, element);
        this.enableSlotOutput(elementIndex, row);
    }

    @Override
    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        if (!player.field_70170_p.func_201670_d()) {
            for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
                ItemStack itemStack = this.inputSlots.func_70304_b(i);
                if (!itemStack.func_190926_b()) {
                    player.func_71019_a(itemStack, false);
                }
                if ((itemStack = this.outputSlots.func_70304_b(i)).func_190926_b()) continue;
                player.func_71019_a(itemStack, false);
            }
        }
    }

    public void onDirty() {
        for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
            ItemStack itemStack = this.inputSlots.func_70301_a(i);
            if (itemStack.func_190926_b() || !this.outputSlots.func_70301_a(i).func_190926_b()) continue;
            ItemStack outputStack = this.writeAspectInfo(!this.player.field_70170_p.func_201670_d(), itemStack.func_77946_l(), (IAspect)this.getUnfilteredItems().get(i));
            this.outputSlots.func_70299_a(i, outputStack);
            this.inputSlots.func_70298_a(i, 1);
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        try {
            if (!this.player.field_70170_p.func_201670_d()) {
                for (IAspectRead aspectRead : this.getUnfilteredItems()) {
                    Pair<IFormattableTextComponent, Integer> readValue;
                    if (((IPartStateReader)this.getPartState()).isEnabled()) {
                        IAspectVariable variable = ((IPartTypeReader)this.getPartType()).getVariable(this.getTarget(), (IPartStateReader)this.getPartState(), aspectRead);
                        readValue = ValueHelpers.getSafeReadableValue(variable);
                    } else {
                        readValue = Pair.of((Object)new StringTextComponent("NO POWER"), (Object)0);
                    }
                    this.setReadValue(aspectRead, readValue);
                }
            }
        }
        catch (PartStateException e) {
            this.player.func_71053_j();
        }
    }

    public void setReadValue(IAspectRead aspectRead, Pair<IFormattableTextComponent, Integer> readValue) {
        int valueId = (Integer)this.readValueIds.inverse().get((Object)aspectRead);
        int colorId = (Integer)this.readColorIds.inverse().get((Object)aspectRead);
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)valueId, (IFormattableTextComponent)((IFormattableTextComponent)readValue.getLeft()));
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)colorId, (int)((Integer)readValue.getRight()));
    }

    public Pair<ITextComponent, Integer> getReadValue(IAspectRead aspect) {
        int valueId = (Integer)this.readValueIds.inverse().get((Object)aspect);
        int colorId = (Integer)this.readColorIds.inverse().get((Object)aspect);
        try {
            return Pair.of((Object)ValueNotifierHelpers.getValueTextComponent((IValueNotifier)this, (int)valueId), (Object)ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)colorId));
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public ItemStack writeAspectInfo(boolean generateId, ItemStack itemStack, IAspect aspect) {
        ItemStack resultStack = super.writeAspectInfo(generateId, itemStack, aspect);
        if (this.player.field_70170_p.func_201670_d()) {
            return resultStack;
        }
        PartTarget target = this.getTarget();
        INetwork network = NetworkHelpers.getNetworkChecked((IBlockReader)target.getCenter().getPos().getWorld(true), target.getCenter().getPos().getBlockPos(), target.getCenter().getSide());
        IPartNetwork partNetwork = NetworkHelpers.getPartNetworkChecked(network);
        PartReaderAspectEvent<IPartTypeReader, IPartStateReader, IAspectRead> event = new PartReaderAspectEvent<IPartTypeReader, IPartStateReader, IAspectRead>(network, partNetwork, target, (IPartTypeReader)this.getPartType(), (IPartStateReader)this.getPartState(), this.player, (IAspectRead)aspect, resultStack);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getItemStack();
    }
}

