/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.inventory.container;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipartAspects;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;
import org.cyclops.integrateddynamics.core.part.aspect.AspectRegistry;

public class ContainerPartWriter<P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>>
extends ContainerMultipartAspects<P, S, IAspectWrite> {
    public static final int ASPECT_BOX_HEIGHT = 18;
    private static final int PAGE_SIZE = 6;
    private static final int SLOT_X = 131;
    private static final int SLOT_Y = 18;
    private final int valueId;
    private final int colorId;
    private final int enabledId;
    private final int activeAspectId;
    private final Map<IAspectWrite, Integer> aspectErrorIds;

    public ContainerPartWriter(int id, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        this(id, playerInventory, (IInventory)new SimpleInventory(packetBuffer.readInt(), 1), PartHelpers.readPartTarget(packetBuffer), Optional.empty(), (IPartTypeWriter)PartHelpers.readPart(packetBuffer));
    }

    public ContainerPartWriter(int id, PlayerInventory playerInventory, IInventory inventory, PartTarget target, Optional<IPartContainer> partContainer, P partType) {
        super(RegistryEntries.CONTAINER_PART_WRITER, id, playerInventory, inventory, target, partContainer, partType, partType.getWriteAspects());
        for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.func_75146_a((Slot)new SlotVariable(this.inputSlots, i, 131, 18 + this.getAspectBoxHeight() * i));
            this.disableSlot(i);
        }
        this.addPlayerInventory(this.player.field_71071_by, 9, 140);
        this.valueId = this.getNextValueId();
        this.colorId = this.getNextValueId();
        this.enabledId = this.getNextValueId();
        this.activeAspectId = this.getNextValueId();
        this.aspectErrorIds = Maps.newIdentityHashMap();
        for (IAspectWrite aspect : partType.getWriteAspects()) {
            this.aspectErrorIds.put(aspect, this.getNextValueId());
        }
    }

    @Override
    public int getAspectBoxHeight() {
        return 18;
    }

    @Override
    public int getPageSize() {
        return 6;
    }

    @Override
    protected void enableSlot(int slotIndex, int row) {
        Slot slot = this.func_75139_a(slotIndex);
        ContainerPartWriter.setSlotPosX((Slot)slot, (int)131);
        ContainerPartWriter.setSlotPosY((Slot)slot, (int)(18 + 18 * row));
    }

    @Override
    protected IInventory constructInputSlotsInventory() {
        if (!this.player.field_70170_p.func_201670_d()) {
            SimpleInventory inventory = ((IPartStateWriter)this.getPartState()).getInventory();
            inventory.addDirtyMarkListener((IDirtyMarkListener)this);
            return inventory;
        }
        return super.constructInputSlotsInventory();
    }

    public void onDirty() {
        if (!this.player.field_70170_p.func_201670_d()) {
            ((IPartTypeWriter)this.getPartType()).updateActivation(this.getTarget(), (IPartStateWriter)this.getPartState(), this.player);
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        try {
            if (!this.player.field_70170_p.func_201670_d()) {
                Pair readValue;
                IPartStateWriter partState = (IPartStateWriter)this.getPartState();
                if (!partState.isEnabled()) {
                    readValue = Pair.of((Object)new StringTextComponent("NO POWER"), (Object)0);
                } else if (partState.hasVariable()) {
                    IPartContainer partContainer = this.getPartContainer();
                    LazyOptional<INetwork> optionalNetwork = NetworkHelpers.getNetwork((IBlockReader)partContainer.getPosition().getWorld(true), partContainer.getPosition().getBlockPos(), this.getTarget().getCenter().getSide());
                    IPartNetwork partNetwork = optionalNetwork.map(NetworkHelpers::getPartNetworkChecked).orElse(null);
                    if (partNetwork != null) {
                        IVariable variable = partState.getVariable((INetwork)optionalNetwork.orElse(null), partNetwork);
                        readValue = ValueHelpers.getSafeReadableValue(variable);
                    } else {
                        readValue = Pair.of((Object)new StringTextComponent("NETWORK CORRUPTED!"), (Object)Helpers.RGBToInt((int)255, (int)100, (int)0));
                    }
                } else {
                    readValue = Pair.of((Object)new StringTextComponent(""), (Object)0);
                }
                this.setWriteValue((IFormattableTextComponent)readValue.getLeft(), (Integer)readValue.getRight());
                for (IAspectWrite aspectWrite : ((IPartTypeWriter)this.getPartType()).getWriteAspects()) {
                    ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.aspectErrorIds.get(aspectWrite), ((IPartStateWriter)this.getPartState()).getErrors(aspectWrite));
                }
                ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.enabledId, (boolean)partState.isEnabled());
                ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.activeAspectId, (String)(partState.getActiveAspect() != null ? partState.getActiveAspect().getUniqueName().toString() : ""));
            }
        }
        catch (PartStateException e) {
            this.player.func_71053_j();
        }
    }

    public void setWriteValue(IFormattableTextComponent writeValue, int writeColor) {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.valueId, (IFormattableTextComponent)writeValue);
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.colorId, (int)writeColor);
    }

    public ITextComponent getWriteValue() {
        IFormattableTextComponent value = ValueNotifierHelpers.getValueTextComponent((IValueNotifier)this, (int)this.valueId);
        if (value == null) {
            value = new StringTextComponent("");
        }
        return value;
    }

    public int getWriteValueColor() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.colorId);
    }

    public List<IFormattableTextComponent> getAspectErrors(IAspectWrite aspectWrite) {
        return ValueNotifierHelpers.getValueTextComponentList((IValueNotifier)this, (int)this.aspectErrorIds.get(aspectWrite));
    }

    public boolean isPartStateEnabled() {
        return ValueNotifierHelpers.getValueBoolean((IValueNotifier)this, (int)this.enabledId);
    }

    @Nullable
    public IAspect getPartStateActiveAspect() {
        return AspectRegistry.getInstance().getAspect(new ResourceLocation(ValueNotifierHelpers.getValueString((IValueNotifier)this, (int)this.activeAspectId)));
    }
}

