/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.logicprogrammer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.gui.TooltipRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.core.ingredient.ItemMatchProperties;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElement;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamicscompat.GeneralConfig;
import org.cyclops.integrateddynamicscompat.IntegratedDynamicsCompat;
import org.cyclops.integrateddynamicscompat.network.packet.CPacketSetSlot;
import org.cyclops.integrateddynamicscompat.network.packet.CPacketValueTypeRecipeLPElementSetRecipe;

public class LogicProgrammerTransferHandler<T extends ContainerLogicProgrammerBase>
implements IRecipeTransferHandler<T> {
    private final Class<T> clazz;

    public LogicProgrammerTransferHandler(Class<T> clazz) {
        this.clazz = clazz;
    }

    public Class<T> getContainerClass() {
        return this.clazz;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T container, IRecipeLayout recipeLayout, PlayerEntity player, boolean maxTransfer, boolean doTransfer) {
        ILogicProgrammerElement element = ((ContainerLogicProgrammerBase)((Object)container)).getActiveElement();
        if (element != null) {
            if (element instanceof ValueTypeRecipeLPElement) {
                return this.handleRecipeElement((ValueTypeRecipeLPElement)element, container, recipeLayout, doTransfer);
            }
            return this.handleDefaultElement(element, container, recipeLayout, doTransfer);
        }
        return null;
    }

    @Nullable
    protected ResourceLocation getHeuristicItemsTag(IGuiIngredient<ItemStack> jeiIngredient) {
        if (!GeneralConfig.jeiHeuristicTags) {
            return null;
        }
        List items = jeiIngredient.getAllIngredients().stream().map(ItemStack::func_77973_b).collect(Collectors.toList());
        if (items.size() > 1) {
            for (Map.Entry entry : ItemTags.func_199903_a().func_241833_a().entrySet()) {
                if (!((ITag)entry.getValue()).func_230236_b_().equals(items)) continue;
                return (ResourceLocation)entry.getKey();
            }
        }
        return null;
    }

    protected IRecipeTransferError handleRecipeElement(ValueTypeRecipeLPElement element, T container, IRecipeLayout recipeLayout, boolean doTransfer) {
        ItemStack stack;
        ArrayList itemInputs = Lists.newArrayList();
        ArrayList fluidInputs = Lists.newArrayList();
        ArrayList itemOutputs = Lists.newArrayList();
        ArrayList fluidOutputs = Lists.newArrayList();
        for (Map.Entry entry : recipeLayout.getItemStacks().getGuiIngredients().entrySet()) {
            stack = (ItemStack)Iterables.getFirst((Iterable)((IGuiIngredient)entry.getValue()).getAllIngredients(), (Object)ItemStack.field_190927_a);
            if (((IGuiIngredient)entry.getValue()).isInput()) {
                ResourceLocation heuristicTag = this.getHeuristicItemsTag((IGuiIngredient<ItemStack>)((IGuiIngredient)entry.getValue()));
                if (heuristicTag != null) {
                    itemInputs.add(new ItemMatchProperties(ItemStack.field_190927_a, false, heuristicTag.toString(), 1));
                    continue;
                }
                itemInputs.add(new ItemMatchProperties(stack));
                continue;
            }
            itemOutputs.add(stack);
        }
        for (Map.Entry entry : recipeLayout.getFluidStacks().getGuiIngredients().entrySet()) {
            stack = (FluidStack)Iterables.getFirst((Iterable)((IGuiIngredient)entry.getValue()).getAllIngredients(), (Object)FluidStack.EMPTY);
            if (((IGuiIngredient)entry.getValue()).isInput()) {
                fluidInputs.add(stack);
                continue;
            }
            fluidOutputs.add(stack);
        }
        if (!element.isValidForRecipeGrid(itemInputs, fluidInputs, itemOutputs, fluidOutputs)) {
            return new IRecipeTransferError(){

                public IRecipeTransferError.Type getType() {
                    return IRecipeTransferError.Type.USER_FACING;
                }

                public void showError(MatrixStack matrixStack, int mouseX, int mouseY, IRecipeLayout recipeLayout, int recipeX, int recipeY) {
                    TooltipRenderer.drawHoveringText(Collections.singletonList(new TranslationTextComponent("error.jei.integrateddynamics.recipetransfer.recipe.toobig.desc")), (int)mouseX, (int)mouseY, (MatrixStack)matrixStack);
                }
            };
        }
        if (doTransfer) {
            element.setRecipeGrid((ContainerLogicProgrammerBase)((Object)container), itemInputs, fluidInputs, itemOutputs, fluidOutputs);
            IntegratedDynamicsCompat._instance.getPacketHandler().sendToServer((PacketBase)new CPacketValueTypeRecipeLPElementSetRecipe(((ContainerLogicProgrammerBase)((Object)container)).field_75152_c, itemInputs, fluidInputs, itemOutputs, fluidOutputs));
        }
        return null;
    }

    protected IRecipeTransferError handleDefaultElement(ILogicProgrammerElement element, T container, IRecipeLayout recipeLayout, boolean doTransfer) {
        ItemStack itemStack = null;
        Object focusElement = recipeLayout.getFocus().getValue();
        if (focusElement instanceof ItemStack) {
            itemStack = (ItemStack)focusElement;
        } else if (focusElement instanceof FluidStack) {
            itemStack = new ItemStack((IItemProvider)Items.field_151133_ar);
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElseThrow(() -> new IllegalStateException("Could not find a fluid handler on the bucket item, some mod must be messing with things."));
            fluidHandler.fill((FluidStack)focusElement, IFluidHandler.FluidAction.EXECUTE);
            itemStack = fluidHandler.getContainer();
        }
        if (itemStack != null) {
            if (element.isItemValidForSlot(0, itemStack)) {
                if (doTransfer) {
                    this.setStackInSlot(container, 0, itemStack);
                }
            } else {
                return new IRecipeTransferError(){

                    public IRecipeTransferError.Type getType() {
                        return IRecipeTransferError.Type.USER_FACING;
                    }

                    public void showError(MatrixStack matrixStack, int mouseX, int mouseY, IRecipeLayout recipeLayout, int recipeX, int recipeY) {
                    }
                };
            }
        }
        return null;
    }

    protected void setStackInSlot(T container, int slot, ItemStack itemStack) {
        int slotId = ((ContainerLogicProgrammerBase)((Object)container)).field_75151_b.size() - 37 + slot;
        container.func_75141_a(slotId, itemStack.func_77946_l());
        IntegratedDynamicsCompat._instance.getPacketHandler().sendToServer((PacketBase)new CPacketSetSlot(((ContainerLogicProgrammerBase)((Object)container)).field_75152_c, slotId, itemStack));
    }
}

