/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.config;

import me.sargunvohra.mcmods.autoconfig1u.AutoConfig;
import me.sargunvohra.mcmods.autoconfig1u.ConfigData;
import me.sargunvohra.mcmods.autoconfig1u.annotation.Config;
import me.sargunvohra.mcmods.autoconfig1u.annotation.ConfigEntry;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.Comment;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class ModConfigs {
    public static Common get() {
        return (Common)AutoConfig.getConfigHolder(Common.class).getConfig();
    }

    @Environment(value=EnvType.CLIENT)
    public static Client getClient() {
        return (Client)AutoConfig.getConfigHolder(Client.class).getConfig();
    }

    @Config(name="iron-jetpacks/common")
    public static class Common
    implements ConfigData {
        @ConfigEntry.Category(value="general")
        @ConfigEntry.Gui.TransitiveObject
        @Comment(value="General configuration options.")
        public General general = new General();
        @ConfigEntry.Category(value="recipe")
        @ConfigEntry.Gui.TransitiveObject
        @Comment(value="Dynamic recipe options.")
        public Recipe recipe = new Recipe();

        public static class Recipe {
            @Comment(value="Enable default recipes for Energy Cells?")
            public boolean enableCellRecipes = true;
            @Comment(value="Enable default recipes for Thrusters?")
            public boolean enableThrusterRecipes = true;
            @Comment(value="Enable default recipes for Capacitors?")
            public boolean enableCapacitorRecipes = true;
            @Comment(value="Enable default recipes for Jetpacks?")
            public boolean enableJetpackRecipes = true;
        }

        public static class General {
            @Comment(value="Should jetpacks be enachantable?")
            public boolean enchantableJetpacks = false;
        }
    }

    @Config(name="iron-jetpacks/client")
    public static class Client
    implements ConfigData {
        @ConfigEntry.Category(value="general")
        @ConfigEntry.Gui.TransitiveObject
        @Comment(value="General configuration options.")
        public General general = new General();
        @ConfigEntry.Category(value="hud")
        @ConfigEntry.Gui.TransitiveObject
        @Comment(value="HUD configuration options.")
        public Hud hud = new Hud();

        public static class Hud {
            @Comment(value="Enable the HUD?")
            public boolean enableHud = true;
            @Comment(value="The position preset for the HUD.\n0=Top Left, 1=Middle Left, 2=Bottom Left, 3=Top Right, 4=Middle Right, 5=Bottom Right")
            @ConfigEntry.Gui.Tooltip(count=2)
            @ConfigEntry.BoundedDiscrete(min=0L, max=5L)
            public int hudPosition = 1;
            @Comment(value="The X offset for the HUD.")
            public int hudOffsetX = 0;
            @Comment(value="The Y offset for the HUD.")
            public int hudOffsetY = 0;
            @Comment(value="Show HUD over the chat?")
            public boolean showHudOverChat = false;
        }

        public static class General {
            @Comment(value="Enable jetpack sounds?")
            public boolean enableJetpackSounds = true;
            @Comment(value="Enable jetpack particles?")
            public boolean enableJetpackParticles = true;
            @Comment(value="Enable jetpack stat tooltips?")
            public boolean enableAdvancedInfoTooltips = true;
        }
    }
}

