/*
 * Decompiled with CFR 0.152.
 */
package jp.tdn.japanese_food_mod.blocks.tileentity;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jp.tdn.japanese_food_mod.blocks.PresserBlock;
import jp.tdn.japanese_food_mod.container.PresserContainer;
import jp.tdn.japanese_food_mod.init.JPBlocks;
import jp.tdn.japanese_food_mod.init.JPItems;
import jp.tdn.japanese_food_mod.init.JPTileEntities;
import jp.tdn.japanese_food_mod.recipes.PresserRecipe;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class PresserTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public static final int INPUT_SLOT = 0;
    public static final int CONTAINER_SLOT = 2;
    public static final int OUTPUT_SLOT = 1;
    private static final String INVENTORY_TAG = "inventory";
    private static final String PRESSED_TIME_LEFT_TAG = "pressedTimeLeft";
    private static final String MAX_PRESSED_TIME_TAG = "maxPressedTime";
    private static final String OIL_REMAINING_TAG = "oilRemaining";
    public ItemStackHandler inventory = new ItemStackHandler(3){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            switch (slot) {
                case 0: {
                    return PresserTileEntity.this.isInput(stack);
                }
                case 1: {
                    return PresserTileEntity.this.isOutput(stack);
                }
                case 2: {
                    return PresserTileEntity.this.isContainerInput(stack);
                }
            }
            return false;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            PresserTileEntity.this.func_70296_d();
        }
    };
    private final LazyOptional<ItemStackHandler> inventoryCapabilityExternal = LazyOptional.of(() -> this.inventory);
    private final LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalUpAndSides = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 1));
    private final LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalDown = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 1, 2));
    public short pressedTimeLeft = (short)-1;
    public short maxPressedTime = (short)-1;
    public short oilRemaining = 0;
    public short maxOilRemaining = (short)500;
    private boolean lastPressing = false;

    public PresserTileEntity() {
        super(JPTileEntities.PRESSER);
    }

    private boolean isInput(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return this.getRecipe(stack).isPresent();
    }

    private boolean isContainerInput(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151069_bo;
    }

    private boolean isOutput(ItemStack stack) {
        return stack.func_77973_b() == JPItems.COOKING_OIL;
    }

    private Optional<PresserRecipe> getRecipe(ItemStack input) {
        return this.getRecipe((IInventory)new Inventory(new ItemStack[]{input}));
    }

    private Optional<PresserRecipe> getRecipe(IInventory inventory) {
        return Objects.requireNonNull(this.field_145850_b).func_199532_z().func_215371_a(PresserRecipe.RECIPE_TYPE, inventory, this.field_145850_b);
    }

    private short getResult(ItemStack input) {
        return this.getRecipe(input).map(PresserRecipe::getResult).orElse(-1).shortValue();
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        boolean isPressing = false;
        ItemStack input = this.inventory.getStackInSlot(0);
        ItemStack container = this.inventory.getStackInSlot(2);
        short result = this.getResult(input);
        if (result != -1 && this.isInput(input)) {
            boolean canInsertResultIntoOilBar;
            isPressing = true;
            boolean bl = canInsertResultIntoOilBar = this.oilRemaining < 500;
            if (canInsertResultIntoOilBar) {
                if (this.pressedTimeLeft == -1) {
                    this.pressedTimeLeft = this.maxPressedTime = this.getPressedTime(input);
                } else {
                    this.pressedTimeLeft = (short)(this.pressedTimeLeft - 1);
                    if (this.pressedTimeLeft == 0) {
                        this.oilRemaining = (short)Math.min(500, this.oilRemaining + result);
                        if (input.hasContainerItem()) {
                            this.insertOrDropContainerItem(input);
                        }
                        input.func_190918_g(1);
                        this.inventory.setStackInSlot(0, input);
                        this.pressedTimeLeft = (short)-1;
                    }
                }
            }
        } else {
            this.maxPressedTime = (short)-1;
            this.pressedTimeLeft = (short)-1;
        }
        if (this.oilRemaining >= 100 && this.isContainerInput(container)) {
            this.inventory.insertItem(1, new ItemStack((IItemProvider)JPItems.COOKING_OIL), false);
            container.func_190918_g(1);
            this.inventory.setStackInSlot(2, container);
            this.oilRemaining = (short)(this.oilRemaining - 100);
        }
        if (this.lastPressing != isPressing) {
            this.func_70296_d();
            BlockState newState = (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)PresserBlock.PRESSING, (Comparable)Boolean.valueOf(isPressing));
            this.field_145850_b.func_180501_a(this.field_174879_c, newState, 2);
            this.lastPressing = isPressing;
        }
        int level = this.oilRemaining == 0 ? 0 : (this.oilRemaining < 160 ? 1 : 2);
        PresserBlock block = (PresserBlock)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        block.setOil(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), level);
    }

    private void insertOrDropContainerItem(ItemStack stack) {
        ItemStack containerItem = stack.getContainerItem();
        boolean canInsertContainerItemIntoSlot = this.inventory.insertItem(0, containerItem, true).func_190926_b();
        if (canInsertContainerItemIntoSlot) {
            this.inventory.insertItem(0, containerItem, false);
        } else {
            InventoryHelper.func_180173_a((World)Objects.requireNonNull(this.field_145850_b), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)containerItem);
        }
    }

    private short getPressedTime(ItemStack input) {
        return this.getRecipe(input).map(PresserRecipe::getCookTime).orElse(200).shortValue();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCapabilityExternal.cast();
        }
        switch (Objects.requireNonNull(side)) {
            case DOWN: {
                return this.inventoryCapabilityExternalDown.cast();
            }
            case UP: 
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                return this.inventoryCapabilityExternalUpAndSides.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l(INVENTORY_TAG));
        this.pressedTimeLeft = compound.func_74765_d(PRESSED_TIME_LEFT_TAG);
        this.maxPressedTime = compound.func_74765_d(MAX_PRESSED_TIME_TAG);
        this.oilRemaining = compound.func_74765_d(OIL_REMAINING_TAG);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a(INVENTORY_TAG, (INBT)this.inventory.serializeNBT());
        compound.func_74777_a(PRESSED_TIME_LEFT_TAG, this.pressedTimeLeft);
        compound.func_74777_a(MAX_PRESSED_TIME_TAG, this.maxPressedTime);
        compound.func_74777_a(OIL_REMAINING_TAG, this.oilRemaining);
        return compound;
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.inventoryCapabilityExternal.invalidate();
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(JPBlocks.PRESSER.func_149739_a(), new Object[0]);
    }

    @Nonnull
    public Container createMenu(int windowId, @Nonnull PlayerInventory inventory, @Nonnull PlayerEntity player) {
        return new PresserContainer(windowId, inventory, this);
    }
}

