/*
 * Decompiled with CFR 0.152.
 */
package jp.tdn.japanese_food_mod.init;

import jp.tdn.japanese_food_mod.entities.AnglerfishEntity;
import jp.tdn.japanese_food_mod.entities.AsariClamEntity;
import jp.tdn.japanese_food_mod.entities.ClamEntity;
import jp.tdn.japanese_food_mod.entities.CrabEntity;
import jp.tdn.japanese_food_mod.entities.EelEntity;
import jp.tdn.japanese_food_mod.entities.ShellfishEntity;
import jp.tdn.japanese_food_mod.entities.TunaEntity;
import jp.tdn.japanese_food_mod.entities.TurbanShellEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="japanese_food_mod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class JPEntities {
    public static EntityType<EelEntity> EEL = JPEntities.createEntity(EelEntity::new, EntityClassification.WATER_CREATURE, "eel", 0.5f, 0.5f);
    public static EntityType<CrabEntity> CRAB = JPEntities.createEntity(CrabEntity::new, EntityClassification.WATER_CREATURE, "crab", 0.5f, 0.3f);
    public static EntityType<TunaEntity> TUNA = JPEntities.createEntity(TunaEntity::new, EntityClassification.WATER_CREATURE, "tuna", 1.0f, 1.0f);
    public static EntityType<ClamEntity> CLAM = JPEntities.createEntity(ClamEntity::new, EntityClassification.WATER_CREATURE, "clam", 0.5f, 0.5f);
    public static EntityType<AsariClamEntity> ASARI_CLAM = JPEntities.createEntity(AsariClamEntity::new, EntityClassification.WATER_CREATURE, "asari_clam", 0.45f, 0.45f);
    public static EntityType<TurbanShellEntity> TURBAN_SHELL = JPEntities.createEntity(TurbanShellEntity::new, EntityClassification.WATER_CREATURE, "turban_shell", 0.5f, 0.5f);
    public static EntityType<AnglerfishEntity> ANGLERFISH = JPEntities.createEntity(AnglerfishEntity::new, EntityClassification.WATER_CREATURE, "anglerfish", 0.75f, 0.4f);

    private static <T extends Entity> EntityType<T> createEntity(EntityType.IFactory<T> factory, EntityClassification entityClassification, String name, float width, float height) {
        ResourceLocation location = new ResourceLocation("japanese_food_mod:" + name);
        EntityType entity = EntityType.Builder.func_220322_a(factory, (EntityClassification)entityClassification).func_220321_a(width, height).func_206830_a(location.toString());
        entity.setRegistryName(location);
        return entity;
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{EEL, CRAB, TUNA, CLAM, ASARI_CLAM, TURBAN_SHELL, ANGLERFISH});
        EntitySpawnPlacementRegistry.func_209343_a(EEL, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, AbstractFishEntity::func_223363_b);
        EntitySpawnPlacementRegistry.func_209343_a(CRAB, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.OCEAN_FLOOR_WG, CrabEntity::spawnHandler);
        EntitySpawnPlacementRegistry.func_209343_a(TUNA, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, AbstractFishEntity::func_223363_b);
        EntitySpawnPlacementRegistry.func_209343_a(CLAM, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.OCEAN_FLOOR_WG, ShellfishEntity::spawnHandler);
        EntitySpawnPlacementRegistry.func_209343_a(ASARI_CLAM, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.OCEAN_FLOOR_WG, ShellfishEntity::spawnHandler);
        EntitySpawnPlacementRegistry.func_209343_a(TURBAN_SHELL, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.OCEAN_FLOOR_WG, ShellfishEntity::spawnHandler);
        EntitySpawnPlacementRegistry.func_209343_a(ANGLERFISH, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.OCEAN_FLOOR_WG, AbstractFishEntity::func_223363_b);
    }

    public static void registerEntityWorldSpawns() {
        JPEntities.registerEntityWorldSpawn(EEL, 10, 1, 5, Biomes.field_76781_i, Biomes.field_76771_b, Biomes.field_203615_U, Biomes.field_203614_T);
        JPEntities.registerEntityWorldSpawn(CRAB, 25, 1, 10, Biomes.field_76771_b, Biomes.field_203615_U, Biomes.field_203614_T, Biomes.field_203616_V, Biomes.field_203619_Y, Biomes.field_150575_M, Biomes.field_203620_Z, Biomes.field_203618_X, Biomes.field_203617_W, Biomes.field_76787_r);
        JPEntities.registerEntityWorldSpawn(TUNA, 2, 1, 5, Biomes.field_76771_b, Biomes.field_203615_U, Biomes.field_203614_T, Biomes.field_150575_M, Biomes.field_203617_W, Biomes.field_203618_X);
        JPEntities.registerEntityWorldSpawn(CLAM, 30, 1, 3, Biomes.field_203615_U, Biomes.field_203614_T, Biomes.field_76771_b, Biomes.field_76787_r);
        JPEntities.registerEntityWorldSpawn(ASARI_CLAM, 40, 1, 5, Biomes.field_203615_U, Biomes.field_203614_T, Biomes.field_76771_b, Biomes.field_76787_r);
        JPEntities.registerEntityWorldSpawn(TURBAN_SHELL, 5, 1, 2, Biomes.field_76771_b, Biomes.field_203615_U, Biomes.field_203614_T);
        JPEntities.registerEntityWorldSpawn(ANGLERFISH, 1, 1, 2, Biomes.field_150575_M, Biomes.field_203619_Y, Biomes.field_203618_X, Biomes.field_203617_W);
    }

    public static void registerEntityWorldSpawn(EntityType<?> entity, int weight, int min, int max, Biome ... biomes) {
        for (Biome biome : biomes) {
            Biome inBiome = (Biome)ForgeRegistries.BIOMES.getValue(biome.getRegistryName());
            if (inBiome == null) continue;
            inBiome.func_76747_a(entity.func_220339_d()).add(new Biome.SpawnListEntry(entity, weight, min, max));
        }
    }
}

