/*
 * Decompiled with CFR 0.152.
 */
package jp.tdn.japanese_food_mod.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MicroScopeRecipe
implements IRecipe<IInventory> {
    public static final Serializer SERIALIZER = new Serializer();
    public static final IRecipeType<MicroScopeRecipe> RECIPE_TYPE = new IRecipeType<MicroScopeRecipe>(){};
    protected final ResourceLocation id;
    protected Ingredient ingredient;
    protected ItemStack result;
    protected float experience;
    protected float probability;
    protected int cookTime;

    public MicroScopeRecipe(ResourceLocation idIn, Ingredient ingredient, ItemStack result, float experience, float probability, int cookTime) {
        this.id = idIn;
        this.ingredient = ingredient;
        this.result = result;
        this.experience = experience;
        this.probability = probability;
        this.cookTime = cookTime;
    }

    public boolean func_77569_a(IInventory inventory, @Nonnull World worldIn) {
        return this.ingredient.test(inventory.func_70301_a(0));
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull IInventory inventory) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonNullList = NonNullList.func_191196_a();
        nonNullList.add((Object)this.ingredient);
        return nonNullList;
    }

    public float getExperience() {
        return this.experience;
    }

    public float getProbability() {
        return this.probability;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.result;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return RECIPE_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<MicroScopeRecipe> {
        public Serializer() {
            this.setRegistryName(new ResourceLocation("japanese_food_mod", "identifying"));
        }

        @Nonnull
        public MicroScopeRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            JsonArray inputElement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
            Ingredient ingredient = CraftingHelper.getIngredient((JsonElement)inputElement);
            int cookTime = JSONUtils.func_151208_a((JsonObject)json, (String)"process_time", (int)50);
            float experience = JSONUtils.func_151221_a((JsonObject)json, (String)"xp", (float)0.0f);
            float probability = JSONUtils.func_151217_k((JsonObject)json, (String)"probability");
            return new MicroScopeRecipe(recipeId, ingredient, result, experience, probability, cookTime);
        }

        @Nullable
        public MicroScopeRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack result = buffer.func_150791_c();
            int cookTime = buffer.func_150792_a();
            float experience = buffer.readFloat();
            float probability = buffer.readFloat();
            return new MicroScopeRecipe(recipeId, ingredient, result, experience, probability, cookTime);
        }

        public void write(@Nonnull PacketBuffer buffer, MicroScopeRecipe recipe) {
            recipe.ingredient.func_199564_a(buffer);
            buffer.func_150788_a(recipe.result);
            buffer.func_150787_b(recipe.cookTime);
            buffer.writeFloat(recipe.experience);
            buffer.writeFloat(recipe.probability);
        }
    }
}

