/*
 * Decompiled with CFR 0.152.
 */
package jp.tdn.japanese_food_mod.recipes;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class WoodenBucketRecipe
implements IRecipe<IInventory> {
    public static final Serializer SERIALIZER = new Serializer();
    public static final IRecipeType<WoodenBucketRecipe> RECIPE_TYPE = new IRecipeType<WoodenBucketRecipe>(){};
    protected final ResourceLocation id;
    protected NonNullList<Ingredient> ingredients;
    protected ItemStack result;
    protected int cookTime;

    public WoodenBucketRecipe(ResourceLocation idIn) {
        this.id = idIn;
    }

    public boolean func_77569_a(@Nonnull IInventory inventory, @Nonnull World worldIn) {
        ArrayList inputs = Lists.newArrayList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            inputs.add(stack);
        }
        boolean check = RecipeMatcher.findMatches((List)inputs, this.ingredients) != null;
        return check;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull IInventory inventory) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.result;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return RECIPE_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<WoodenBucketRecipe> {
        Serializer() {
            this.setRegistryName(new ResourceLocation("japanese_food_mod", "fermentation"));
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredients) {
            NonNullList rec = NonNullList.func_191196_a();
            for (JsonElement element : ingredients) {
                rec.add((Object)CraftingHelper.getIngredient((JsonElement)element));
            }
            if (rec.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            return rec;
        }

        @Nonnull
        public WoodenBucketRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            WoodenBucketRecipe recipe = new WoodenBucketRecipe(recipeId);
            recipe.result = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
            recipe.cookTime = JSONUtils.func_151203_m((JsonObject)json, (String)"process_time");
            recipe.ingredients = Serializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            return recipe;
        }

        @Nullable
        public WoodenBucketRecipe read(@Nonnull ResourceLocation recipeId, PacketBuffer buffer) {
            WoodenBucketRecipe recipe = new WoodenBucketRecipe(recipeId);
            int index = buffer.func_150792_a();
            NonNullList nonnulllist = NonNullList.func_191197_a((int)index, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            recipe.ingredients = nonnulllist;
            recipe.result = buffer.func_150791_c();
            recipe.cookTime = buffer.func_150792_a();
            return recipe;
        }

        public void write(@Nonnull PacketBuffer buffer, WoodenBucketRecipe recipe) {
            buffer.func_150787_b(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.result);
            buffer.func_150787_b(recipe.cookTime);
        }
    }
}

