/*
 * Decompiled with CFR 0.152.
 */
package jp.tdn.japanese_food_mod.blocks.tileentity;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jp.tdn.japanese_food_mod.JapaneseFoodUtil;
import jp.tdn.japanese_food_mod.container.MicroScopeContainer;
import jp.tdn.japanese_food_mod.init.JPBlocks;
import jp.tdn.japanese_food_mod.init.JPTileEntities;
import jp.tdn.japanese_food_mod.recipes.MicroScopeRecipe;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class MicroScopeTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public static final int INPUT_SLOT = 0;
    public static final int CONTAINER_SLOT = 2;
    public static final int OUTPUT_SLOT = 1;
    private static final String INVENTORY_TAG = "inventory";
    private static final String IDENTIFIED_TIME_LEFT_TAG = "identifiedTimeLeft";
    private static final String MAX_IDENTIFIED_TIME_TAG = "maxIdentifiedTime";
    public ItemStackHandler inventory = new ItemStackHandler(3){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            switch (slot) {
                case 0: {
                    return MicroScopeTileEntity.this.isInput(stack);
                }
                case 1: {
                    return MicroScopeTileEntity.this.isOutput(stack);
                }
                case 2: {
                    return MicroScopeTileEntity.this.isContainerInput(stack);
                }
            }
            return false;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            MicroScopeTileEntity.this.func_70296_d();
        }
    };
    private final LazyOptional<ItemStackHandler> inventoryCapabilityExternal = LazyOptional.of(() -> this.inventory);
    private final LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalUpAndSides = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 1));
    private final LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalDown = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 1, 2));
    public short identifiedTimeLeft = (short)-1;
    public short maxIdentifiedTime = (short)-1;

    public MicroScopeTileEntity() {
        super(JPTileEntities.MICROSCOPE);
    }

    private boolean isInput(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return this.getRecipe(stack).isPresent();
    }

    private boolean isContainerInput(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151069_bo;
    }

    private boolean isOutput(ItemStack stack) {
        Optional<ItemStack> result = this.getResult(this.inventory.getStackInSlot(0));
        return result.isPresent() && ItemStack.func_179545_c((ItemStack)result.get(), (ItemStack)stack);
    }

    private Optional<MicroScopeRecipe> getRecipe(ItemStack input) {
        return this.getRecipe((IInventory)new Inventory(new ItemStack[]{input}));
    }

    private Optional<MicroScopeRecipe> getRecipe(IInventory inventory) {
        return Objects.requireNonNull(this.field_145850_b).func_199532_z().func_215371_a(MicroScopeRecipe.RECIPE_TYPE, inventory, this.field_145850_b);
    }

    private Optional<ItemStack> getResult(ItemStack input) {
        Inventory dummyInventory = new Inventory(new ItemStack[]{input});
        return this.getRecipe((IInventory)dummyInventory).map(recipe -> recipe.func_77572_b((IInventory)dummyInventory));
    }

    public ItemStack getInventory() {
        return this.inventory.getStackInSlot(0);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack input = this.inventory.getStackInSlot(0);
        ItemStack container = this.inventory.getStackInSlot(2);
        ItemStack result = this.getResult(input).orElse(ItemStack.field_190927_a);
        if (!result.func_190926_b() && this.isInput(input) && this.isContainerInput(container)) {
            boolean canInsertResultIntoOutPut = this.inventory.insertItem(1, result, true).func_190926_b();
            if (canInsertResultIntoOutPut) {
                if (this.identifiedTimeLeft == -1) {
                    this.identifiedTimeLeft = this.maxIdentifiedTime = this.getIdentifiedTime(input);
                } else {
                    this.identifiedTimeLeft = (short)(this.identifiedTimeLeft - 1);
                    if (this.identifiedTimeLeft == 0) {
                        if ((float)JapaneseFoodUtil.rand.nextInt(101) <= this.getRecipe(input).get().getProbability() * 100.0f) {
                            this.inventory.insertItem(1, result, false);
                            if (input.hasContainerItem()) {
                                this.insertOrDropContainerItem(input);
                            }
                            container.func_190918_g(1);
                            this.inventory.setStackInSlot(2, container);
                        }
                        input.func_190918_g(1);
                        this.inventory.setStackInSlot(0, input);
                        this.identifiedTimeLeft = (short)-1;
                    }
                }
            }
        } else {
            this.maxIdentifiedTime = (short)-1;
            this.identifiedTimeLeft = (short)-1;
        }
    }

    private void insertOrDropContainerItem(ItemStack stack) {
        ItemStack containerItem = stack.getContainerItem();
        boolean canInsertContainerItemIntoSlot = this.inventory.insertItem(0, containerItem, true).func_190926_b();
        if (canInsertContainerItemIntoSlot) {
            this.inventory.insertItem(0, containerItem, false);
        } else {
            InventoryHelper.func_180173_a((World)Objects.requireNonNull(this.field_145850_b), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)containerItem);
        }
    }

    private short getIdentifiedTime(ItemStack input) {
        return this.getRecipe(input).map(MicroScopeRecipe::getCookTime).orElse(200).shortValue();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCapabilityExternal.cast();
        }
        switch (Objects.requireNonNull(side)) {
            case DOWN: {
                return this.inventoryCapabilityExternalDown.cast();
            }
            case UP: 
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                return this.inventoryCapabilityExternalUpAndSides.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l(INVENTORY_TAG));
        this.identifiedTimeLeft = compound.func_74765_d(IDENTIFIED_TIME_LEFT_TAG);
        this.maxIdentifiedTime = compound.func_74765_d(MAX_IDENTIFIED_TIME_TAG);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a(INVENTORY_TAG, (INBT)this.inventory.serializeNBT());
        compound.func_74777_a(IDENTIFIED_TIME_LEFT_TAG, this.identifiedTimeLeft);
        compound.func_74777_a(MAX_IDENTIFIED_TIME_TAG, this.maxIdentifiedTime);
        return compound;
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.inventoryCapabilityExternal.invalidate();
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(JPBlocks.MICRO_SCOPE.func_149739_a(), new Object[0]);
    }

    @Nonnull
    public Container createMenu(int windowId, @Nonnull PlayerInventory inventory, @Nonnull PlayerEntity player) {
        return new MicroScopeContainer(windowId, inventory, this);
    }
}

