/*
 * Decompiled with CFR 0.152.
 */
package jp.tdn.japanese_food_mod.blocks.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jp.tdn.japanese_food_mod.blocks.WoodenBucketBlock;
import jp.tdn.japanese_food_mod.container.WoodenBucketContainer;
import jp.tdn.japanese_food_mod.init.JPBlocks;
import jp.tdn.japanese_food_mod.init.JPItems;
import jp.tdn.japanese_food_mod.init.JPTileEntities;
import jp.tdn.japanese_food_mod.recipes.WoodenBucketRecipe;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class WoodenBucketTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public static final int[] INPUT_SLOT = new int[]{0, 1, 2, 3, 4, 5};
    public static final int OUTPUT_SLOT = 6;
    public static final int[] RETURN_SLOT = new int[]{7, 8, 9};
    private static final String INVENTORY_TAG = "inventory";
    private static final String FERMENTATION_TIME_LEFT = "fermentation_time_left";
    private static final String MAX_FERMENTATION_TIME = "max_fermentation_time";
    public ItemStackHandler inventory = new ItemStackHandler(10){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            switch (slot) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return true;
                }
                case 6: {
                    return WoodenBucketTileEntity.this.isOutput(stack);
                }
                case 7: 
                case 8: 
                case 9: {
                    return WoodenBucketTileEntity.this.isReturnOutput(stack);
                }
            }
            return false;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            WoodenBucketTileEntity.this.func_70296_d();
        }
    };
    private final LazyOptional<ItemStackHandler> inventoryCapabilityExternal = LazyOptional.of(() -> this.inventory);
    private final LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalUpAndSides = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, INPUT_SLOT[0], INPUT_SLOT[5] + 1));
    private final LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalDown = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 6, 7));
    public short fermentationTimeLeft = (short)-1;
    public short maxFermentationTime = (short)-1;
    private boolean lastActive = false;

    public WoodenBucketTileEntity() {
        super(JPTileEntities.WOODEN_BUCKET);
    }

    private boolean isEmpty(ItemStack[] stack) {
        boolean rec = false;
        for (int index = 0; !rec && index < stack.length; ++index) {
            rec = stack[index].func_190926_b();
        }
        return rec;
    }

    private boolean isInput(ItemStack[] stack) {
        if (this.isEmpty(stack)) {
            return false;
        }
        return this.getRecipe(stack).isPresent();
    }

    private boolean isOutput(ItemStack stack) {
        ItemStack[] input = new ItemStack[INPUT_SLOT.length];
        for (int index = 0; index < INPUT_SLOT.length; ++index) {
            input[index] = this.inventory.getStackInSlot(INPUT_SLOT[index]);
        }
        Optional<ItemStack> result = this.getResult(input);
        return result.isPresent() && ItemStack.func_179545_c((ItemStack)result.get(), (ItemStack)stack);
    }

    private boolean isReturnOutput(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151069_bo || stack.func_77973_b() == JPItems.CUP;
    }

    private Optional<WoodenBucketRecipe> getRecipe(ItemStack input) {
        return this.getRecipe((IInventory)new Inventory(new ItemStack[]{input}));
    }

    private Optional<WoodenBucketRecipe> getRecipe(ItemStack[] input) {
        return this.getRecipe((IInventory)new Inventory(input));
    }

    private Optional<WoodenBucketRecipe> getRecipe(IInventory inventory) {
        return Objects.requireNonNull(this.field_145850_b).func_199532_z().func_215371_a(WoodenBucketRecipe.RECIPE_TYPE, inventory, this.field_145850_b);
    }

    private Optional<ItemStack> getResult(ItemStack[] input) {
        Inventory dummyInventory = new Inventory(input);
        return this.getRecipe((IInventory)dummyInventory).map(recipe -> recipe.func_77572_b((IInventory)dummyInventory));
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        boolean isActive = false;
        ArrayList inputs = Lists.newArrayList();
        for (int index = 0; index < INPUT_SLOT.length; ++index) {
            ItemStack stack = this.inventory.getStackInSlot(index);
            if (stack.func_190926_b()) continue;
            inputs.add(stack);
        }
        ItemStack result = this.getResult(inputs.toArray(new ItemStack[0])).orElse(ItemStack.field_190927_a);
        if (!result.func_190926_b() && this.isInput(inputs.toArray(new ItemStack[0]))) {
            boolean canInsertResultIntoOutPut = this.inventory.insertItem(6, result, true).func_190926_b();
            if (canInsertResultIntoOutPut) {
                isActive = true;
                if (this.fermentationTimeLeft == -1) {
                    this.fermentationTimeLeft = this.maxFermentationTime = this.getFermentationTime(inputs.toArray(new ItemStack[0]));
                } else {
                    this.fermentationTimeLeft = (short)(this.fermentationTimeLeft - 1);
                    if (this.fermentationTimeLeft == 0) {
                        this.inventory.insertItem(6, result, false);
                        int i = 0;
                        for (ItemStack input : inputs) {
                            if (i >= INPUT_SLOT.length) continue;
                            if (input.hasContainerItem()) {
                                this.insertOrDropContainerItem(input, INPUT_SLOT[i]);
                            }
                            input.func_190918_g(1);
                            this.inventory.setStackInSlot(INPUT_SLOT[i], input);
                            ++i;
                        }
                        this.fermentationTimeLeft = (short)-1;
                    }
                }
            }
        } else {
            this.maxFermentationTime = (short)-1;
            this.fermentationTimeLeft = (short)-1;
        }
        if (this.lastActive != isActive) {
            this.func_70296_d();
            BlockState newState = (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)WoodenBucketBlock.FER, (Comparable)Boolean.valueOf(isActive));
            this.field_145850_b.func_175656_a(this.field_174879_c, newState);
            this.lastActive = isActive;
        }
    }

    private void insertOrDropContainerItem(ItemStack stack, int slot) {
        int index;
        ItemStack containerItem = stack.getContainerItem();
        boolean canInsertContainerItemIntoReturnSlot = false;
        for (index = 0; index < RETURN_SLOT.length && !(canInsertContainerItemIntoReturnSlot = this.inventory.insertItem(RETURN_SLOT[index], containerItem, true).func_190926_b()); ++index) {
        }
        if (canInsertContainerItemIntoReturnSlot) {
            this.inventory.insertItem(RETURN_SLOT[index], containerItem, false);
        } else {
            boolean canInsertContainerItemIntoSlot = this.inventory.insertItem(slot, containerItem, true).func_190926_b();
            if (canInsertContainerItemIntoSlot) {
                this.inventory.insertItem(slot, containerItem, false);
            } else {
                InventoryHelper.func_180173_a((World)Objects.requireNonNull(this.field_145850_b), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)containerItem);
            }
        }
    }

    private short getFermentationTime(ItemStack[] input) {
        return this.getRecipe(input).map(WoodenBucketRecipe::getCookTime).orElse(200).shortValue();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCapabilityExternal.cast();
        }
        switch (Objects.requireNonNull(side)) {
            case DOWN: {
                return this.inventoryCapabilityExternalDown.cast();
            }
            case UP: 
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                return this.inventoryCapabilityExternalUpAndSides.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l(INVENTORY_TAG));
        this.fermentationTimeLeft = compound.func_74765_d(FERMENTATION_TIME_LEFT);
        this.maxFermentationTime = compound.func_74765_d(MAX_FERMENTATION_TIME);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a(INVENTORY_TAG, (INBT)this.inventory.serializeNBT());
        compound.func_74777_a(FERMENTATION_TIME_LEFT, this.fermentationTimeLeft);
        compound.func_74777_a(MAX_FERMENTATION_TIME, this.maxFermentationTime);
        return compound;
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.inventoryCapabilityExternal.invalidate();
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(JPBlocks.WOODEN_BUCKET.func_149739_a(), new Object[0]);
    }

    @Nonnull
    public Container createMenu(int windowId, @Nonnull PlayerInventory inventory, @Nonnull PlayerEntity player) {
        return new WoodenBucketContainer(windowId, inventory, this);
    }
}

