/*
 * Decompiled with CFR 0.152.
 */
package jp.tdn.japanese_food_mod.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import jp.tdn.japanese_food_mod.blocks.tileentity.PresserTileEntity;
import jp.tdn.japanese_food_mod.container.PresserContainer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PresserScreen
extends ContainerScreen<PresserContainer> {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("japanese_food_mod", "textures/gui/container/presser.png");

    public PresserScreen(PresserContainer container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title);
        this.field_147000_g = 168;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        String tooltip;
        boolean arrowHovered;
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        int relMouseX = mouseX - this.field_147003_i;
        int relMouseY = mouseY - this.field_147009_r;
        PresserTileEntity tileEntity = ((PresserContainer)this.field_147002_h).tileEntity;
        boolean bl = arrowHovered = relMouseX > 34 && relMouseX < 50 && relMouseY > 32 && relMouseY < 52;
        if (arrowHovered && tileEntity.maxPressedTime > 0 && tileEntity.oilRemaining < 500) {
            tooltip = new TranslationTextComponent("gui.japanese_food_mod.pressingTimeProgress", new Object[]{(short)((float)(tileEntity.maxPressedTime - tileEntity.pressedTimeLeft) / (float)tileEntity.maxPressedTime * 100.0f), "%"}).func_150254_d();
            this.renderTooltip(tooltip, mouseX, mouseY);
        }
        boolean bl2 = arrowHovered = relMouseX > 22 && relMouseX < 62 && relMouseY > 59 && relMouseY < 74;
        if (arrowHovered) {
            tooltip = new TranslationTextComponent("gui.japanese_food_mod.oilRemaining", new Object[]{tileEntity.oilRemaining, tileEntity.maxOilRemaining}).func_150254_d();
            this.renderTooltip(tooltip, mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX_, int mouseY) {
        super.func_146979_b(mouseX_, mouseY);
        String s = this.title.func_150254_d();
        this.font.func_211126_b(s, (float)((double)this.field_146999_f / 1.5 - (double)(this.font.func_78256_a(s) / 2)), 6.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 94 + 2), 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        int startX = this.field_147003_i;
        int startY = this.field_147009_r;
        this.blit(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
        PresserTileEntity tileEntity = ((PresserContainer)this.field_147002_h).tileEntity;
        if (tileEntity.pressedTimeLeft > 0) {
            int arrowHeight = this.getPressedTimeScaled();
            this.blit(startX + 34, startY + 32, 176, 0, 16, arrowHeight);
        }
        if (tileEntity.oilRemaining > 0) {
            int oilRemaining = this.getOilRemainingScaled();
            this.blit(startX + 22, startY + 59 + 13 - oilRemaining, 176, 22, 40, oilRemaining);
        }
    }

    private int getPressedTimeScaled() {
        PresserTileEntity tileEntity = ((PresserContainer)this.field_147002_h).tileEntity;
        short pressedTimeLeft = tileEntity.pressedTimeLeft;
        short maxPressedTime = tileEntity.maxPressedTime;
        if (pressedTimeLeft <= 0 || maxPressedTime <= 0) {
            return 0;
        }
        return (maxPressedTime - pressedTimeLeft) * 20 / maxPressedTime;
    }

    private int getOilRemainingScaled() {
        PresserTileEntity tileEntity = ((PresserContainer)this.field_147002_h).tileEntity;
        short oilRemaining = tileEntity.oilRemaining;
        if (oilRemaining <= 0) {
            return 0;
        }
        return Math.round((float)oilRemaining / (float)tileEntity.maxOilRemaining * 13.0f);
    }
}

