/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.config.ClientConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.ingredients.Ingredients;
import mezz.jei.ingredients.IngredientsForType;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ErrorUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private static IModIdHelper modIdHelper;
    @Nullable
    private static IWorldConfig worldConfig;

    private ErrorUtil() {
    }

    public static void setModIdHelper(IModIdHelper modIdHelper) {
        ErrorUtil.modIdHelper = modIdHelper;
    }

    public static void setWorldConfig(IWorldConfig worldConfig) {
        ErrorUtil.worldConfig = worldConfig;
    }

    public static <T> String getInfoFromRecipe(T recipe, IRecipeCategory<T> recipeCategory) {
        StringBuilder recipeInfoBuilder = new StringBuilder();
        String recipeName = ErrorUtil.getNameForRecipe(recipe);
        recipeInfoBuilder.append(recipeName);
        Ingredients ingredients = new Ingredients();
        try {
            recipeCategory.setIngredients(recipe, ingredients);
        }
        catch (LinkageError | RuntimeException ignored) {
            recipeInfoBuilder.append("\nFailed to get ingredients from recipe wrapper");
            return recipeInfoBuilder.toString();
        }
        recipeInfoBuilder.append("\nOutputs:");
        List<IngredientsForType<?>> outputIngredients = ingredients.getOutputIngredients();
        for (IngredientsForType<?> output : outputIngredients) {
            IIngredientType<?> outputType = output.getIngredientType();
            List<String> ingredientOutputInfo = ErrorUtil.getIngredientOutputInfo(outputType, ingredients);
            recipeInfoBuilder.append('\n').append(outputType.getIngredientClass().getName()).append(": ").append(ingredientOutputInfo);
        }
        recipeInfoBuilder.append("\nInputs:");
        List<IngredientsForType<?>> inputIngredients = ingredients.getInputIngredients();
        for (IngredientsForType<?> input : inputIngredients) {
            IIngredientType<?> inputType = input.getIngredientType();
            List<String> ingredientInputInfo = ErrorUtil.getIngredientInputInfo(inputType, ingredients);
            recipeInfoBuilder.append('\n').append(inputType.getIngredientClass().getName()).append(": ").append(ingredientInputInfo);
        }
        return recipeInfoBuilder.toString();
    }

    private static <T> List<String> getIngredientOutputInfo(IIngredientType<T> ingredientType, IIngredients ingredients) {
        List<List<T>> outputs = ingredients.getOutputs(ingredientType);
        return ErrorUtil.getIngredientInfo(ingredientType, outputs);
    }

    private static <T> List<String> getIngredientInputInfo(IIngredientType<T> ingredientType, IIngredients ingredients) {
        List<List<T>> inputs = ingredients.getInputs(ingredientType);
        return ErrorUtil.getIngredientInfo(ingredientType, inputs);
    }

    public static String getNameForRecipe(Object recipe) {
        ResourceLocation registryName = null;
        if (recipe instanceof IRecipe) {
            registryName = ((IRecipe)recipe).func_199560_c();
        } else if (recipe instanceof IForgeRegistryEntry) {
            IForgeRegistryEntry registryEntry = (IForgeRegistryEntry)recipe;
            registryName = registryEntry.getRegistryName();
        }
        if (registryName != null) {
            if (modIdHelper != null) {
                String modId = registryName.func_110624_b();
                String modName = modIdHelper.getModNameForModId(modId);
                return modName + " " + registryName + " " + recipe.getClass();
            }
            return registryName + " " + recipe.getClass();
        }
        try {
            return recipe.toString();
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed recipe.toString", (Throwable)e);
            return recipe.getClass().toString();
        }
    }

    public static <T> String getIngredientInfo(T ingredient) {
        IIngredientHelper<T> ingredientHelper = Internal.getIngredientManager().getIngredientHelper(ingredient);
        return ingredientHelper.getErrorInfo(ingredient);
    }

    public static <T> List<String> getIngredientInfo(IIngredientType<T> ingredientType, List<? extends List<T>> ingredients) {
        IIngredientHelper<T> ingredientHelper = Internal.getIngredientManager().getIngredientHelper(ingredientType);
        ArrayList<String> allInfos = new ArrayList<String>(ingredients.size());
        for (List<T> inputList : ingredients) {
            ArrayList<String> infos = new ArrayList<String>(inputList.size());
            for (T input : inputList) {
                String errorInfo = ingredientHelper.getErrorInfo(input);
                infos.add(errorInfo);
            }
            allInfos.add(((Object)infos).toString());
        }
        return allInfos;
    }

    public static String getItemStackInfo(@Nullable ItemStack itemStack) {
        String itemName;
        if (itemStack == null) {
            return "null";
        }
        Item item = itemStack.func_77973_b();
        ResourceLocation registryName = item.getRegistryName();
        if (registryName != null) {
            itemName = registryName.toString();
        } else if (item instanceof BlockItem) {
            ResourceLocation blockRegistryName;
            Block block = ((BlockItem)item).func_179223_d();
            String blockName = block == null ? "null" : ((blockRegistryName = block.getRegistryName()) != null ? blockRegistryName.toString() : block.getClass().getName());
            itemName = "BlockItem(" + blockName + ")";
        } else {
            itemName = item.getClass().getName();
        }
        CompoundNBT nbt = itemStack.func_77978_p();
        if (nbt != null) {
            return itemStack + " " + itemName + " nbt:" + nbt;
        }
        return itemStack + " " + itemName;
    }

    public static void checkNotEmpty(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("ItemStack must not be null.");
        }
        if (itemStack.func_190926_b()) {
            String info = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("ItemStack value must not be empty. " + info);
        }
    }

    public static void checkNotEmpty(@Nullable ItemStack itemStack, String name) {
        if (itemStack == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (itemStack.func_190926_b()) {
            String info = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("ItemStack " + name + " must not be empty. " + info);
        }
    }

    public static <T> void checkNotEmpty(@Nullable T[] values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (values.length <= 0) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        for (T value : values) {
            if (value != null) continue;
            throw new NullPointerException(name + " must not contain null values.");
        }
    }

    public static void checkNotEmpty(@Nullable Collection<?> values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (values.isEmpty()) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        if (!(values instanceof NonNullList)) {
            for (Object value : values) {
                if (value != null) continue;
                throw new NullPointerException(name + " must not contain null values.");
            }
        }
    }

    public static <T> void checkNotNull(@Nullable T object, String name) {
        if (object == null) {
            throw new NullPointerException(name + " must not be null.");
        }
    }

    public static void checkNotNull(@Nullable Collection<?> values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (!(values instanceof NonNullList)) {
            for (Object value : values) {
                if (value != null) continue;
                throw new NullPointerException(name + " must not contain null values.");
            }
        }
    }

    public static <T> void checkIsValidIngredient(@Nullable T ingredient, String name) {
        ErrorUtil.checkNotNull(ingredient, name);
        IngredientManager ingredientManager = Internal.getIngredientManager();
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredient);
        if (!ingredientHelper.isValidIngredient(ingredient)) {
            String ingredientInfo = ingredientHelper.getErrorInfo(ingredient);
            throw new IllegalArgumentException("Invalid ingredient found. Parameter Name: " + name + " Ingredient Info: " + ingredientInfo);
        }
    }

    public static void assertMainThread() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft != null && !minecraft.func_213162_bc()) {
            Thread currentThread = Thread.currentThread();
            throw new IllegalStateException("A JEI API method is being called by another mod from the wrong thread:\n" + currentThread + "\nIt must be called on the main thread by using Minecraft.addScheduledTask.");
        }
    }

    public static <T> ReportedException createRenderIngredientException(Throwable throwable, T ingredient) {
        IngredientManager ingredientManager = Internal.getIngredientManager();
        IIngredientType ingredientType = ingredientManager.getIngredientType(ingredient);
        IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
        CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering ingredient");
        CrashReportCategory ingredientCategory = crashreport.func_85058_a("Ingredient being rendered");
        if (modIdHelper != null) {
            ingredientCategory.func_189529_a("Mod Name", () -> {
                String modId = ingredientHelper.getDisplayModId(ingredient);
                return modIdHelper.getModNameForModId(modId);
            });
        }
        ingredientCategory.func_189529_a("Registry Name", () -> {
            String modId = ingredientHelper.getModId(ingredient);
            String resourceId = ingredientHelper.getResourceId(ingredient);
            return modId + ":" + resourceId;
        });
        ingredientCategory.func_189529_a("Display Name", () -> ingredientHelper.getDisplayName(ingredient));
        ingredientCategory.func_189529_a("String Name", ingredient::toString);
        CrashReportCategory jeiCategory = crashreport.func_85058_a("JEI render details");
        jeiCategory.func_189529_a("Unique Id (for Blacklist)", () -> ingredientHelper.getUniqueId(ingredient));
        jeiCategory.func_189529_a("Ingredient Type", () -> ingredientType.getIngredientClass().toString());
        jeiCategory.func_189529_a("Error Info", () -> ingredientHelper.getErrorInfo(ingredient));
        if (worldConfig != null) {
            jeiCategory.func_189529_a("Filter Text", () -> worldConfig.getFilterText());
            jeiCategory.func_189529_a("Edit Mode Enabled", () -> Boolean.toString(worldConfig.isEditModeEnabled()));
        }
        jeiCategory.func_189529_a("Debug Mode Enabled", () -> Boolean.toString(ClientConfig.getInstance().isDebugModeEnabled()));
        throw new ReportedException(crashreport);
    }
}

