/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.jumbofurnace.client.jei;

import com.github.commoble.jumbofurnace.JumboFurnaceObjects;
import com.github.commoble.jumbofurnace.client.jei.JumboSmeltingCategory;
import com.github.commoble.jumbofurnace.recipes.JumboFurnaceRecipe;
import com.github.commoble.jumbofurnace.recipes.RecipeSorter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JEIProxy
implements IModPlugin {
    @Nullable
    private JumboSmeltingCategory jumboSmeltingCategory;
    public static final ResourceLocation ID = new ResourceLocation("jumbofurnace", "jumbofurnace");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.jumboSmeltingCategory = new JumboSmeltingCategory(registration.getJeiHelpers().getGuiHelper());
        registration.addRecipeCategories(new IRecipeCategory[]{this.jumboSmeltingCategory});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)JumboFurnaceObjects.JEI_DUMMY), new ResourceLocation[]{JumboSmeltingCategory.ID});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (this.jumboSmeltingCategory == null) {
            throw new NullPointerException("Jumbo Furnace's Jumbo Smelting JEI category failed to register! Notify the developer for assistance https://github.com/Commoble/jumbo-furnace/issues");
        }
        registration.addRecipes(this.getRecipes(), JumboSmeltingCategory.ID);
    }

    public List<JumboFurnaceRecipe> getRecipes() {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            RecipeManager manager = world.func_199532_z();
            return RecipeSorter.INSTANCE.getSortedFurnaceRecipes(manager);
        }
        return ImmutableList.of();
    }
}

