/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.jumbofurnace.recipes;

import com.github.commoble.jumbofurnace.recipes.JumboFurnaceRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class JumboFurnaceRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<JumboFurnaceRecipe> {
    public final IRecipeType<JumboFurnaceRecipe> recipeType;

    public JumboFurnaceRecipeSerializer(IRecipeType<JumboFurnaceRecipe> recipeType) {
        this.recipeType = recipeType;
    }

    public JumboFurnaceRecipe read(ResourceLocation recipeId, JsonObject json) {
        String groupName = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        NonNullList<Ingredient> ingredients = JumboFurnaceRecipeSerializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for jumbo furnace recipe");
        }
        if (ingredients.size() > 9) {
            throw new JsonParseException("Too many ingredients for jumbo furnace recipe! the max is 9");
        }
        ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        float experience = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.0f);
        return new JumboFurnaceRecipe(this.recipeType, recipeId, groupName, ingredients, result, experience);
    }

    public static NonNullList<Ingredient> readIngredients(JsonArray p_199568_0_) {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        for (int i = 0; i < p_199568_0_.size(); ++i) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)p_199568_0_.get(i));
            if (ingredient.func_203189_d()) continue;
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public JumboFurnaceRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        String groupName = buffer.func_150789_c(Short.MAX_VALUE);
        int ingredientCount = buffer.func_150792_a();
        NonNullList ingredients = NonNullList.func_191197_a((int)ingredientCount, (Object)Ingredient.field_193370_a);
        for (int slot = 0; slot < ingredients.size(); ++slot) {
            ingredients.set(slot, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        ItemStack result = buffer.func_150791_c();
        float experience = buffer.readFloat();
        return new JumboFurnaceRecipe(this.recipeType, recipeId, groupName, (NonNullList<Ingredient>)ingredients, result, experience);
    }

    public void write(PacketBuffer buffer, JumboFurnaceRecipe recipe) {
        buffer.func_180714_a(recipe.group);
        buffer.func_150787_b(recipe.ingredients.size());
        for (Ingredient ingredient : recipe.ingredients) {
            ingredient.func_199564_a(buffer);
        }
        buffer.func_150788_a(recipe.result);
        buffer.writeFloat(recipe.experience);
    }
}

