/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.lavadynamics;

import com.eleksploded.lavadynamics.LavaConfig;
import com.eleksploded.lavadynamics.VolcanoBlock;
import com.eleksploded.lavadynamics.WorldGenVolcano;
import com.eleksploded.lavadynamics.arrow.EntityVolcanoArrow;
import com.eleksploded.lavadynamics.arrow.VolcanoArrow;
import com.eleksploded.lavadynamics.commands.CheckedAddCommand;
import com.eleksploded.lavadynamics.commands.CheckedChunkCommand;
import com.eleksploded.lavadynamics.commands.ForcePostGenEffect;
import com.eleksploded.lavadynamics.commands.VolcanoCommand;
import com.eleksploded.lavadynamics.postgen.PostGenEffectRegistry;
import com.eleksploded.lavadynamics.postgen.RunEffects;
import com.eleksploded.lavadynamics.postgen.effects.RumbleEffect;
import com.eleksploded.lavadynamics.postgen.effects.erupt.DamageFallingBlock;
import com.eleksploded.lavadynamics.postgen.effects.erupt.EruptEffect;
import com.eleksploded.lavadynamics.proxy.CommonProxy;
import com.eleksploded.lavadynamics.storage.StorageManager;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="lavadynamics", version="5.6.14", updateJSON="https://raw.githubusercontent.com/kreezxil/Lava-Dynamics/1.12.2-fixed/Updates.json", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber(modid="lavadynamics")
public class LavaDynamics {
    public static final Block VolcanoBlock = new VolcanoBlock();
    public static final VolcanoArrow volcanoarrow = new VolcanoArrow();
    @SidedProxy(modId="lavadynamics", clientSide="com.eleksploded.lavadynamics.proxy.CommonProxy", serverSide="com.eleksploded.lavadynamics.proxy.ServerProxy")
    public static CommonProxy proxy;
    public static final Logger Logger;
    @Mod.Instance
    public static LavaDynamics instance;
    public static boolean mineralogy;
    RumbleEffect rumbleEffect = new RumbleEffect();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenVolcano(), (int)1);
        MinecraftForge.EVENT_BUS.register(StorageManager.class);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(RunEffects.class);
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Loader.isModLoaded((String)"mineralogy")) {
            // empty if block
        }
        StorageManager.init();
        PostGenEffectRegistry.registerEffect(new EruptEffect());
        PostGenEffectRegistry.registerEffect(this.rumbleEffect);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CheckedAddCommand());
        event.registerServerCommand((ICommand)new VolcanoCommand());
        event.registerServerCommand((ICommand)new CheckedChunkCommand());
        event.registerServerCommand((ICommand)new ForcePostGenEffect());
    }

    @SubscribeEvent
    public static void blocks(RegistryEvent.Register<Block> event) {
        if (LavaConfig.general.genVolcanoDebug) {
            Logger.info("Registering Blocks");
        }
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)VolcanoBlock);
    }

    @SubscribeEvent
    public static void items(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        ItemBlock itemblock = new ItemBlock(VolcanoBlock);
        itemblock.setRegistryName(VolcanoBlock.getRegistryName());
        itemblock.func_77655_b(VolcanoBlock.func_149739_a());
        registry.register((IForgeRegistryEntry)itemblock);
        Item item = Item.func_150898_a((Block)VolcanoBlock);
        proxy.registerItemModels(item, 0, "Inventory");
        registry.register((IForgeRegistryEntry)volcanoarrow);
        proxy.registerItemModels((Item)volcanoarrow, 0, "Inventory");
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    static void playerJoin(EntityJoinWorldEvent event) {
        block3: {
            ForgeVersion.Status update = ForgeVersion.getResult((ModContainer)Loader.instance().activeModContainer()).status;
            try {
                if (event.getEntity() instanceof EntityPlayerSP && update == ForgeVersion.Status.OUTDATED) {
                    EntityPlayerSP player = (EntityPlayerSP)event.getEntity();
                    player.func_145747_a(new TextComponentString("An update avaliable for ").func_150257_a(new TextComponentString("LavaDynamics").func_150255_a(new Style().func_150238_a(TextFormatting.GREEN).func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/lava-dynamics/files/")))));
                }
            }
            catch (NoClassDefFoundError e) {
                if (update != ForgeVersion.Status.OUTDATED) break block3;
                Logger.info("New update avalable for LavaDynamics");
            }
        }
    }

    @SubscribeEvent
    public void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().register(this.rumbleEffect.event.setRegistryName("lavadynamics", "rumble"));
    }

    @SubscribeEvent
    public void registerEntity(RegistryEvent.Register<EntityEntry> event) {
        EntityEntry damageFallingBlock = EntityEntryBuilder.create().entity(DamageFallingBlock.class).id(new ResourceLocation("lavadynamics", "DamageFallingBlock"), 0).name("DamageFallingBlock").tracker(80, 3, true).build();
        EntityEntry volcanoArrow = EntityEntryBuilder.create().entity(EntityVolcanoArrow.class).id(new ResourceLocation("lavadynamics", "volcanoarrow"), 33).name("VolcanoArrow").tracker(80, 1, true).build();
        IForgeRegistry reg = event.getRegistry();
        reg.register((IForgeRegistryEntry)damageFallingBlock);
        reg.register((IForgeRegistryEntry)volcanoArrow);
    }

    static {
        Logger = LogManager.getLogger((String)"LavaDynamics");
        mineralogy = false;
    }
}

