/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.lavadynamics;

import com.eleksploded.lavadynamics.LavaConfig;
import com.eleksploded.lavadynamics.LavaDynamics;
import com.eleksploded.lavadynamics.generators.ConeVolcanoGen;
import com.eleksploded.lavadynamics.generators.MountianVolcanoGen;
import com.eleksploded.lavadynamics.generators.WaterVolcanoGen;
import com.eleksploded.lavadynamics.storage.StorageManager;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.ArrayUtils;

@Mod.EventBusSubscriber
public class Volcano {
    private static boolean active = false;
    private static boolean water = false;
    private static boolean worldLoaded = false;
    static int timer = LavaConfig.volcano.volcanoCooldown;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void WorldLoaded(WorldEvent.Load event) {
        worldLoaded = true;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void WorldUnloaded(WorldEvent.Unload event) {
        worldLoaded = false;
    }

    @SubscribeEvent
    public static void OnChunkLoad(ChunkEvent.Load event) {
        if (!ArrayUtils.contains((int[])LavaConfig.volcano.validDimensions, (int)event.getWorld().field_73011_w.getDimension())) {
            return;
        }
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getWorld().field_73010_i.size() == 0) {
            return;
        }
        if (LavaConfig.general.genVolcanoDebug) {
            LavaDynamics.Logger.debug((Object)timer);
        }
        if (timer != 0) {
            --timer;
            return;
        }
        if (LavaConfig.volcano.protectChunks && Volcano.hasTileEntity(event.getWorld(), event.getChunk())) {
            return;
        }
        Chunk chunk = event.getChunk();
        if (LavaConfig.general.genVolcanoDebug) {
            LavaDynamics.Logger.info("Checking chunk at " + chunk.field_76635_g + " " + chunk.field_76647_h);
        }
        int x = (chunk.func_76632_l().func_180332_e() - chunk.func_76632_l().func_180334_c()) / 2 + chunk.func_76632_l().func_180334_c();
        int z = (chunk.func_76632_l().func_180330_f() - chunk.func_76632_l().func_180333_d()) / 2 + chunk.func_76632_l().func_180333_d();
        int y = chunk.func_177433_f(new BlockPos(x, 70, z));
        if (Volcano.canSpawn(chunk)) {
            Random rand;
            int num;
            if (LavaConfig.general.genVolcanoDebug) {
                LavaDynamics.Logger.info("Chunk at " + chunk.field_76635_g + " " + chunk.field_76647_h + " is not checked already");
            }
            if ((num = (rand = new Random()).nextInt(100) + 1) <= LavaConfig.volcano.volcanoChance) {
                if (LavaConfig.general.genVolcanoDebug) {
                    LavaDynamics.Logger.info("VOLCANO!!!");
                }
                StorageManager.getCheckedStorage(event.getWorld().field_73011_w.getDimension()).addChecked(chunk);
                if (!StorageManager.getVolcanoStorage(event.getWorld().field_73011_w.getDimension()).isVolcanoInRange(chunk)) {
                    event.getWorld().func_175656_a(new BlockPos(x, y, z), LavaDynamics.VolcanoBlock.func_176223_P());
                }
            } else {
                StorageManager.getCheckedStorage(event.getWorld().field_73011_w.getDimension()).addChecked(chunk);
            }
        } else if (LavaConfig.general.genVolcanoDebug) {
            LavaDynamics.Logger.info("Chunk " + chunk.field_76635_g + " " + chunk.field_76647_h + " has already been checked");
        }
        timer = LavaConfig.volcano.volcanoCooldown;
    }

    public static void genVolcano(Chunk chunk, World world) {
        int height;
        try {
            StorageManager.getCheckedStorage(world.field_73011_w.getDimension()).addChecked(chunk);
        }
        catch (NullPointerException e) {
            LavaDynamics.Logger.error("Must be running via command, or generation is taking place in an invalid dimension. If it is an invalid dimension, please report on the github page.");
        }
        if (active) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        active = true;
        boolean debug = LavaConfig.general.genVolcanoDebug;
        Random rand = new Random(world.func_72905_C());
        int x = (chunk.func_76632_l().func_180332_e() - chunk.func_76632_l().func_180334_c()) / 2 + chunk.func_76632_l().func_180334_c();
        int z = (chunk.func_76632_l().func_180330_f() - chunk.func_76632_l().func_180333_d()) / 2 + chunk.func_76632_l().func_180333_d();
        int y = LavaConfig.volcano.volcanoYLevel + (rand.nextInt(5) - 2);
        BlockPos center = new BlockPos(x, y, z);
        if (debug) {
            LavaDynamics.Logger.info("Center Location is " + center);
        }
        WorldGenLakes lakes = new WorldGenLakes((Block)Blocks.field_150353_l);
        lakes.func_180709_b(world, rand, center);
        if (debug) {
            LavaDynamics.Logger.info("Lava lake generated");
        }
        if (debug) {
            LavaDynamics.Logger.info("Generating Lava Pillar");
        }
        if ((height = chunk.func_177433_f(new BlockPos(x, y + 5, z)) - center.func_177956_o()) <= 0) {
            height = 1;
        }
        if (debug) {
            LavaDynamics.Logger.info("Height for Generation is: " + height);
        }
        int topY = 70;
        for (int i = 0; i <= height; ++i) {
            int j = i + center.func_177956_o();
            if (debug) {
                LavaDynamics.Logger.info("Placing Lava at y=" + j);
            }
            world.func_175656_a(new BlockPos(x, j, z), Blocks.field_189877_df.func_176223_P());
            topY = j;
        }
        if (debug) {
            LavaDynamics.Logger.info("Lava Pillar Done");
        }
        if (debug) {
            LavaDynamics.Logger.info("Generate Volcano");
        }
        WorldGenerator gen = Volcano.getGenerator(world, new BlockPos(x, 255, z));
        gen.func_180709_b(world, rand, new BlockPos(x, 255, z));
        if (debug) {
            LavaDynamics.Logger.info("Done Generating. Filling with " + Blocks.field_150353_l);
        }
        BlockPos fill = new BlockPos(x, topY, z);
        while (world.func_180495_p(fill).func_177230_c() != Blocks.field_150353_l || world.func_180495_p(fill).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(fill).func_177230_c() != Blocks.field_189877_df) {
            if (debug) {
                LavaDynamics.Logger.info("Block at " + fill + " is " + world.func_180495_p(fill).func_177230_c());
                LavaDynamics.Logger.info("Setting " + fill + " to lava");
            }
            world.func_175656_a(fill, Blocks.field_150353_l.func_176223_P());
            fill = fill.func_177984_a();
            if (world.func_180495_p(fill).func_177230_c() == Blocks.field_150350_a || world.func_180495_p(fill).func_177230_c() == Blocks.field_150355_j && water || fill.func_177956_o() >= 255 || fill.func_177956_o() <= 3) break;
            try {
                StorageManager.getVolcanoStorage(world.field_73011_w.getDimension()).addVolcano(chunk, fill.func_177956_o());
            }
            catch (NullPointerException e) {
                LavaDynamics.Logger.error("Must be running via command, or generation is taking place in an invalid dimension. If it is an invalid dimension, please report on the github page.");
            }
        }
        if (debug) {
            LavaDynamics.Logger.info("Done filling, Spawning crater");
        }
        BlockPos fill1 = fill.func_177979_c(4);
        for (int radius = 3; radius != 0; --radius) {
            int x1 = fill1.func_177958_n();
            int y1 = fill1.func_177956_o() - 1;
            int z1 = fill1.func_177952_p();
            float i1 = 0.0f;
            while (i1 < (float)radius) {
                float j1 = 0.0f;
                while ((double)j1 < Math.PI * 2 * (double)i1) {
                    world.func_175656_a(new BlockPos((int)Math.floor((double)x1 + Math.sin(j1) * (double)i1), y1 + radius, (int)Math.floor((double)z1 + Math.cos(j1) * (double)i1)), Blocks.field_150353_l.func_176223_P());
                    j1 = (float)((double)j1 + 0.5);
                }
                i1 = (float)((double)i1 + 0.5);
            }
            fill1 = fill1.func_177977_b();
        }
        world.func_72885_a(null, (double)fill.func_177958_n(), (double)(fill.func_177956_o() + 3), (double)fill.func_177952_p(), (float)LavaConfig.volcano.craterSize, LavaConfig.volcano.initialFire, true);
        if (debug) {
            LavaDynamics.Logger.info("Done with crater");
        }
        active = false;
    }

    public static WorldGenerator getGenerator(World world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        if (biome == Biomes.field_76770_e || biome == Biomes.field_76783_v || biome == Biomes.field_150580_W || biome == Biomes.field_185443_S || biome == Biomes.field_185434_af || biome == Biomes.field_150587_Y) {
            return new MountianVolcanoGen();
        }
        if (biome == Biomes.field_76771_b || biome == Biomes.field_150575_M || biome == Biomes.field_76776_l || biome == Biomes.field_76781_i || biome == Biomes.field_76777_m) {
            water = true;
            return new WaterVolcanoGen();
        }
        return new ConeVolcanoGen();
    }

    public static boolean hasTileEntity(World world, Chunk chunk) {
        for (BlockPos pos : chunk.func_177434_r().keySet()) {
            if (!world.func_175726_f(pos).equals(chunk)) continue;
            return true;
        }
        return false;
    }

    static boolean canSpawn(Chunk chunk) {
        if (LavaConfig.volcano.disaster) {
            return worldLoaded;
        }
        return worldLoaded && !StorageManager.getCheckedStorage(chunk.func_177412_p().field_73011_w.getDimension()).isChecked(chunk) && !LavaConfig.volcano.worldGen;
    }
}

