/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.lavadynamics;

import com.eleksploded.lavadynamics.LavaConfig;
import com.eleksploded.lavadynamics.Volcano;
import com.eleksploded.lavadynamics.storage.StorageManager;
import com.eleksploded.lavadynamics.storage.VolcanoStorage;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.apache.commons.lang3.ArrayUtils;

public class WorldGenVolcano
implements IWorldGenerator {
    private int timer;

    public WorldGenVolcano() {
        this.timer = LavaConfig.volcano.volcanoCooldown;
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!LavaConfig.volcano.worldGen) {
            return;
        }
        Chunk chunk = chunkProvider.func_186025_d(chunkX, chunkZ);
        if (this.timer != 0) {
            --this.timer;
            try {
                StorageManager.getCheckedStorage(world.field_73011_w.getDimension()).addChecked(chunk);
            }
            catch (NullPointerException e) {
                return;
            }
            return;
        }
        this.timer = LavaConfig.volcano.volcanoCooldown;
        if (ArrayUtils.contains((int[])LavaConfig.volcano.validDimensions, (int)world.field_73011_w.getDimension()) && rand.nextInt(100) + 1 <= LavaConfig.volcano.volcanoChance) {
            VolcanoStorage store = StorageManager.getVolcanoStorage(world.field_73011_w.getDimension());
            if (!(StorageManager.getCheckedStorage(world.field_73011_w.getDimension()).isChecked(chunk) || store.isVolcano(chunk) || store.isVolcanoInRange(chunk))) {
                Volcano.genVolcano(chunk, world);
            }
        }
    }
}

