/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.lavadynamics.generators;

import com.eleksploded.lavadynamics.LavaConfig;
import com.eleksploded.lavadynamics.LavaDynamics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;

public class ConeVolcanoGen
extends WorldGenerator {
    List<IBlockState> ores = new ArrayList<IBlockState>();

    public ConeVolcanoGen() {
        super(!LavaConfig.volcano.worldGen);
        List names = Arrays.stream(LavaConfig.volcano.ores).collect(Collectors.toList());
        if (names.size() != LavaConfig.volcano.chance.length) {
            LavaDynamics.Logger.error("Detected Invalid Config: Ores do not match OreChance in config. Disabling ore generation in volcanoes");
            names.clear();
        }
        for (String name : names) {
            String[] split = name.split("\\|");
            if (split.length != 2) {
                LavaDynamics.Logger.error("Skipping invalid Config at " + name);
                continue;
            }
            IBlockState block = Blocks.field_150348_b.func_176223_P();
            try {
                block = Block.func_149684_b((String)split[0]).func_176203_a(Integer.valueOf(split[1]).intValue());
            }
            catch (NullPointerException | NumberFormatException e) {
                LavaDynamics.Logger.error("Skipping invalid Config at " + name);
                continue;
            }
            int chance = LavaConfig.volcano.chance[names.indexOf(name)];
            for (int i = 0; i != chance; ++i) {
                this.ores.add(block);
            }
        }
    }

    public boolean func_180709_b(World world, Random random, BlockPos position) {
        BlockPos pos1;
        Random rand = new Random();
        while (world.func_175623_d(position) && position.func_177956_o() > 15 && (position = position.func_177977_b()).func_177956_o() < 255 && position.func_177956_o() > 16) {
        }
        int height = rand.nextInt(LavaConfig.volcano.volcanoHeightMax - LavaConfig.volcano.volcanoHeightMin + 1) + LavaConfig.volcano.volcanoHeightMin;
        if (height <= 0) {
            return false;
        }
        int caldera = rand.nextInt(LavaConfig.volcano.calderaMax - LavaConfig.volcano.calderaMin + 1) + LavaConfig.volcano.calderaMin;
        BlockPos pos = position.func_177981_b(height);
        int i = caldera;
        for (int j = pos.func_177956_o(); j < 255 && j > 3 && (this.isCornerAir(world, pos1 = new BlockPos(pos.func_177958_n(), j, pos.func_177952_p()), i) || pos1.func_177956_o() >= 255 || pos.func_177956_o() <= 3); --j) {
            this.circle(i, world, pos1, j);
            this.setBlockWithOre(world, pos1, false);
            ++i;
        }
        BlockPos fill1 = position.func_177981_b(height);
        while (!world.func_175623_d(fill1) && !world.func_175623_d(fill1 = fill1.func_177977_b()) && fill1.func_177956_o() > 0) {
        }
        for (int radius = caldera - 1; radius != 0; --radius) {
            int x1 = fill1.func_177958_n();
            int y1 = fill1.func_177956_o() - 1;
            int z1 = fill1.func_177952_p();
            float i1 = 0.0f;
            while (i1 < (float)radius) {
                float j1 = 0.0f;
                while ((double)j1 < Math.PI * 2 * (double)i1) {
                    world.func_175656_a(new BlockPos((int)Math.floor((double)x1 + Math.sin(j1) * (double)i1), y1 + radius, (int)Math.floor((double)z1 + Math.cos(j1) * (double)i1)), Blocks.field_150353_l.func_176223_P());
                    j1 = (float)((double)j1 + 0.5);
                }
                i1 = (float)((double)i1 + 0.5);
            }
            fill1 = fill1.func_177977_b();
        }
        return true;
    }

    private boolean isCornerAir(World world, BlockPos pos, int radius) {
        if (world.func_180495_p(pos.func_177965_g(radius)).func_177230_c() == Blocks.field_150350_a) {
            return true;
        }
        if (world.func_180495_p(pos.func_177985_f(radius)).func_177230_c() == Blocks.field_150350_a) {
            return true;
        }
        if (world.func_180495_p(pos.func_177964_d(radius)).func_177230_c() == Blocks.field_150350_a) {
            return true;
        }
        return world.func_180495_p(pos.func_177970_e(radius)).func_177230_c() == Blocks.field_150350_a;
    }

    public void circle(int radius, World world, BlockPos fill1, int j) {
        int x1 = fill1.func_177958_n();
        int y1 = fill1.func_177956_o();
        int z1 = fill1.func_177952_p();
        float i1 = 0.0f;
        while (i1 < (float)radius) {
            float j1 = 0.0f;
            while ((double)j1 < Math.PI * 2 * (double)i1) {
                if (LavaConfig.volcano.useBiome && (double)i1 == (double)radius - 0.5) {
                    this.setBlockWithBiomeTop(world, new BlockPos((int)Math.floor((double)x1 + Math.sin(j1) * (double)i1), y1, (int)Math.floor((double)z1 + Math.cos(j1) * (double)i1)));
                } else {
                    this.setBlockWithOre(world, new BlockPos((int)Math.floor((double)x1 + Math.sin(j1) * (double)i1), y1, (int)Math.floor((double)z1 + Math.cos(j1) * (double)i1)), LavaConfig.volcano.useBiome && i1 >= (float)radius - ((float)LavaConfig.volcano.fillerSize + 0.5f));
                }
                j1 = (float)((double)j1 + 0.5);
            }
            i1 = (float)((double)i1 + 0.5);
        }
    }

    private void setBlockWithOre(World worldIn, BlockPos blockpos, boolean useFiller) {
        int chance;
        Random rand = new Random();
        int ore = rand.nextInt(1000);
        IBlockState block = ore <= (chance = 1000 - LavaConfig.volcano.oreChance) ? (useFiller ? worldIn.func_180494_b((BlockPos)blockpos).field_76753_B : Blocks.field_150348_b.func_176223_P()) : this.ores.get(rand.nextInt(this.ores.size()));
        this.func_175903_a(worldIn, blockpos, block);
    }

    private void setBlockWithBiomeTop(World world, BlockPos blockpos) {
        Biome biome = world.func_180494_b(blockpos);
        this.func_175903_a(world, blockpos, biome.field_76752_A);
    }
}

