/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.lavadynamics.generators;

import com.eleksploded.lavadynamics.LavaConfig;
import com.eleksploded.lavadynamics.LavaDynamics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.commons.lang3.ArrayUtils;

public class MountianVolcanoGen
extends WorldGenerator {
    List<IBlockState> ores = new ArrayList<IBlockState>();

    public MountianVolcanoGen() {
        super(!LavaConfig.volcano.worldGen);
        List names = Arrays.stream(LavaConfig.volcano.ores).collect(Collectors.toList());
        if (names.size() != LavaConfig.volcano.chance.length) {
            LavaDynamics.Logger.error("Detected Invalid Config: Ores do not match OreChance in config. Disabling ore generation in volcanoes");
            names.clear();
        }
        for (String name : names) {
            String[] tmp = name.split("\\|");
            if (tmp.length != 2) {
                LavaDynamics.Logger.error("Skipping invalid Config at " + name);
                continue;
            }
            IBlockState block = Blocks.field_150348_b.func_176223_P();
            try {
                block = Block.func_149684_b((String)tmp[0]).func_176203_a(Integer.valueOf(tmp[1]).intValue());
            }
            catch (NullPointerException | NumberFormatException e) {
                LavaDynamics.Logger.error("Skipping invalid Config at " + name);
                continue;
            }
            int chance = LavaConfig.volcano.chance[names.indexOf(name)];
            for (int i = 0; i != chance; ++i) {
                this.ores.add(block);
            }
        }
    }

    public boolean func_180709_b(World world, Random random, BlockPos position) {
        float j1;
        float i1;
        int z1;
        int y1;
        int x1;
        int radius;
        if (ArrayUtils.contains((int[])LavaConfig.volcano.validDimensions, (int)world.field_73011_w.getDimension())) {
            return false;
        }
        Random rand = new Random();
        while (world.func_175623_d(position) && position.func_177956_o() > 2 && (position = position.func_177977_b()).func_177956_o() < 255 && position.func_177956_o() > 16) {
        }
        int caldera = rand.nextInt(LavaConfig.volcano.calderaMax - LavaConfig.volcano.calderaMin + 1) + LavaConfig.volcano.calderaMin;
        BlockPos pos = position;
        for (radius = caldera; radius != 0; --radius) {
            x1 = pos.func_177958_n();
            y1 = pos.func_177956_o() - 1;
            z1 = pos.func_177952_p();
            i1 = 0.0f;
            while (i1 < (float)radius) {
                j1 = 0.0f;
                while ((double)j1 < Math.PI * 2 * (double)i1) {
                    this.setBlockWithOre(world, new BlockPos((int)Math.floor((double)x1 + Math.sin(j1) * (double)i1), y1 + radius, (int)Math.floor((double)z1 + Math.cos(j1) * (double)i1)), false);
                    j1 = (float)((double)j1 + 0.5);
                }
                i1 = (float)((double)i1 + 0.5);
            }
            pos = pos.func_177977_b();
        }
        for (radius = caldera - 1; radius != 0; --radius) {
            x1 = position.func_177958_n();
            y1 = position.func_177956_o() - 1;
            z1 = position.func_177952_p();
            i1 = 0.0f;
            while (i1 < (float)radius) {
                j1 = 0.0f;
                while ((double)j1 < Math.PI * 2 * (double)i1) {
                    if (LavaConfig.volcano.useBiome && (double)i1 == (double)radius - 0.5) {
                        this.setBlockWithBiomeTop(world, new BlockPos((int)Math.floor((double)x1 + Math.sin(j1) * (double)i1), y1, (int)Math.floor((double)z1 + Math.cos(j1) * (double)i1)));
                    } else {
                        this.setBlockWithOre(world, new BlockPos((int)Math.floor((double)x1 + Math.sin(j1) * (double)i1), y1, (int)Math.floor((double)z1 + Math.cos(j1) * (double)i1)), LavaConfig.volcano.useBiome && i1 >= (float)radius - ((float)LavaConfig.volcano.fillerSize + 0.5f));
                    }
                    j1 = (float)((double)j1 + 0.5);
                }
                i1 = (float)((double)i1 + 0.5);
            }
            position = position.func_177977_b();
        }
        return true;
    }

    private void setBlockWithOre(World worldIn, BlockPos blockpos, boolean useFiller) {
        int chance;
        Random rand = new Random();
        int ore = rand.nextInt(1000);
        IBlockState block = ore <= (chance = 1000 - LavaConfig.volcano.oreChance) ? (useFiller ? worldIn.func_180494_b((BlockPos)blockpos).field_76753_B : Blocks.field_150348_b.func_176223_P()) : this.ores.get(rand.nextInt(this.ores.size()));
        this.func_175903_a(worldIn, blockpos, block);
    }

    private void setBlockWithBiomeTop(World world, BlockPos blockpos) {
        Biome biome = world.func_180494_b(blockpos);
        this.func_175903_a(world, blockpos, biome.field_76752_A);
    }
}

