/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.lavadynamics.generators;

import com.eleksploded.lavadynamics.LavaConfig;
import com.eleksploded.lavadynamics.LavaDynamics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.commons.lang3.ArrayUtils;

public class WaterVolcanoGen
extends WorldGenerator {
    List<IBlockState> ores = new ArrayList<IBlockState>();

    public WaterVolcanoGen() {
        super(!LavaConfig.volcano.worldGen);
        System.out.print("Test");
        List names = Arrays.stream(LavaConfig.volcano.ores).collect(Collectors.toList());
        if (names.size() != LavaConfig.volcano.chance.length) {
            LavaDynamics.Logger.error("Detected Invalid Config: Ores do not match OreChance in config. Disabling ore generation in volcanoes");
            names.clear();
        }
        for (String name : names) {
            String[] tmp = name.split("\\|");
            if (tmp.length != 2) {
                LavaDynamics.Logger.error("Skipping invalid Config at " + name);
                continue;
            }
            IBlockState block = Blocks.field_150348_b.func_176223_P();
            try {
                block = Block.func_149684_b((String)tmp[0]).func_176203_a(Integer.valueOf(tmp[1]).intValue());
            }
            catch (NullPointerException | NumberFormatException e) {
                LavaDynamics.Logger.error("Skipping invalid Config at " + name);
                continue;
            }
            int chance = LavaConfig.volcano.chance[names.indexOf(name)];
            for (int i = 0; i != chance; ++i) {
                this.ores.add(block);
            }
        }
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        BlockPos pos1;
        int height;
        if (ArrayUtils.contains((int[])LavaConfig.volcano.validDimensions, (int)world.field_73011_w.getDimension())) {
            return false;
        }
        rand = new Random();
        boolean full = false;
        if (rand.nextInt(100) + 1 <= LavaConfig.volcano.waterVolcanoChance) {
            full = true;
        }
        if ((height = rand.nextInt(LavaConfig.volcano.volcanoHeightMax - LavaConfig.volcano.volcanoHeightMin + 1) + LavaConfig.volcano.volcanoHeightMin) <= 0) {
            return false;
        }
        System.out.println(height);
        int caldera = rand.nextInt(LavaConfig.volcano.calderaMax - LavaConfig.volcano.calderaMin + 1) + LavaConfig.volcano.calderaMin;
        BlockPos pos = position.func_177981_b(height);
        int i = caldera;
        int j = pos.func_177956_o();
        while (full && this.isCornerWater(world, pos1 = new BlockPos(pos.func_177958_n(), j, pos.func_177952_p()), i)) {
            this.circle(i, world, pos1, j);
            this.setBlockWithOre(world, pos1);
            ++i;
            --j;
        }
        BlockPos fill1 = position.func_177981_b(height);
        while (world.func_180495_p(fill1).func_177230_c() == Blocks.field_150355_j && world.func_180495_p(fill1 = fill1.func_177977_b()).func_177230_c() == Blocks.field_150355_j && fill1.func_177956_o() > 0) {
        }
        float h = height;
        fill1 = fill1.func_177981_b(Math.round(h / 2.0f));
        for (int radius = caldera - 1; radius != 0; --radius) {
            int x1 = fill1.func_177958_n();
            int y1 = fill1.func_177956_o() - 1;
            int z1 = fill1.func_177952_p();
            float i1 = 0.0f;
            while (i1 < (float)radius) {
                float j1 = 0.0f;
                while ((double)j1 < Math.PI * 2 * (double)i1) {
                    world.func_175656_a(new BlockPos((int)Math.floor((double)x1 + Math.sin(j1) * (double)i1), y1 + radius, (int)Math.floor((double)z1 + Math.cos(j1) * (double)i1)), Blocks.field_150353_l.func_176223_P());
                    j1 = (float)((double)j1 + 0.5);
                }
                i1 = (float)((double)i1 + 0.5);
            }
            fill1 = fill1.func_177977_b();
        }
        return true;
    }

    private boolean isCornerWater(World world, BlockPos pos, int radius) {
        if (world.func_180495_p(pos.func_177965_g(radius)).func_177230_c() == Blocks.field_150355_j) {
            return true;
        }
        if (world.func_180495_p(pos.func_177985_f(radius)).func_177230_c() == Blocks.field_150355_j) {
            return true;
        }
        if (world.func_180495_p(pos.func_177964_d(radius)).func_177230_c() == Blocks.field_150355_j) {
            return true;
        }
        return world.func_180495_p(pos.func_177970_e(radius)).func_177230_c() == Blocks.field_150355_j;
    }

    public void circle(int radius, World world, BlockPos fill1, int j) {
        int x1 = fill1.func_177958_n();
        int y1 = fill1.func_177956_o();
        int z1 = fill1.func_177952_p();
        float i1 = 0.0f;
        while (i1 < (float)radius) {
            float j1 = 0.0f;
            while ((double)j1 < Math.PI * 2 * (double)i1) {
                this.setBlockWithOre(world, new BlockPos((int)Math.floor((double)x1 + Math.sin(j1) * (double)i1), y1, (int)Math.floor((double)z1 + Math.cos(j1) * (double)i1)));
                j1 = (float)((double)j1 + 0.5);
            }
            i1 = (float)((double)i1 + 0.5);
        }
    }

    private void setBlockWithOre(World worldIn, BlockPos blockpos) {
        int chance;
        Random rand = new Random();
        int ore = rand.nextInt(1000);
        IBlockState block = ore <= (chance = 1000 - LavaConfig.volcano.oreChance) ? Blocks.field_150348_b.func_176223_P() : this.ores.get(rand.nextInt(this.ores.size()));
        this.func_175903_a(worldIn, blockpos, block);
    }
}

